/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import me.eigenraven.lwjgl3ify.api.FloatMouseHelper;
import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import me.eigenraven.lwjgl3ify.core.Config;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDLMouse;
import org.lwjgl.sdl.SDLVideo;
import org.lwjgl.sdl.SDL_MouseMotionEvent;
import org.lwjgl.system.MemoryStack;
import org.lwjglx.Sys;
import org.lwjglx.input.Cursor;
import org.lwjglx.input.EventQueue;
import org.lwjglx.opengl.Display;

public class Mouse {
    public static final int EVENT_SIZE = 22;
    private static ByteBuffer buttons = BufferUtils.createByteBuffer((int)32);
    private static IntBuffer coord_buffer = BufferUtils.createIntBuffer((int)32);
    private static ByteBuffer readBuffer = BufferUtils.createByteBuffer((int)32);
    private static boolean grabbed = false;
    private static int lastEventX = 0;
    private static int lastEventY = 0;
    private static int latestX = 0;
    private static int latestY = 0;
    private static int x = 0;
    private static int y = 0;
    private static int dx = 0;
    private static int dy = 0;
    private static int dwheel = 0;
    private static float dxFloat = 0.0f;
    private static float dyFloat = 0.0f;
    private static EventQueue queue = new EventQueue(128);
    public static volatile int sdlMouseButtonFlags = 0;
    private static int[] buttonEvents = new int[queue.getMaxEvents()];
    private static boolean[] buttonEventStates = new boolean[queue.getMaxEvents()];
    private static int[] xEvents = new int[queue.getMaxEvents()];
    private static int[] yEvents = new int[queue.getMaxEvents()];
    private static int[] wheelEvents = new int[queue.getMaxEvents()];
    private static int[] lastxEvents = new int[queue.getMaxEvents()];
    private static int[] lastyEvents = new int[queue.getMaxEvents()];
    private static long[] nanoTimeEvents = new long[queue.getMaxEvents()];
    private static boolean clipPostionToDisplay = true;
    private static int ignoreNextDelta = 0;
    private static int ignoreNextMove = 0;
    static float dxAccum = 0.0f;
    static float dyAccum = 0.0f;
    static double fractionalWheelPosition = 0.0;
    public static double totalScrollAmount = 0.0;
    private static Cursor currentCursor;
    private static long systemCursor;

    public static int sdlToLwjglMouseButton(byte sdlMouseButton) {
        int n;
        switch (sdlMouseButton) {
            case 1: {
                n = 0;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            default: {
                n = sdlMouseButton;
            }
        }
        return n;
    }

    public static byte lwjglToSdlMouseButton(int lwjglMouseButton) {
        byte by;
        switch (lwjglMouseButton) {
            case 0: {
                by = 1;
                break;
            }
            case 1: {
                by = 3;
                break;
            }
            case 2: {
                by = 2;
                break;
            }
            case 3: {
                by = 4;
                break;
            }
            case 4: {
                by = 5;
                break;
            }
            default: {
                by = (byte)lwjglMouseButton;
            }
        }
        return by;
    }

    public static void addMoveEvent(SDL_MouseMotionEvent event) {
        if (ignoreNextMove > 0) {
            --ignoreNextMove;
            return;
        }
        float scale = Display.getPixelScaleFactor();
        float mouseX = event.x() * scale;
        float mouseY = event.y() * scale;
        dxFloat += event.xrel() * scale;
        dyFloat -= event.yrel() * scale;
        int wholeDx = Math.round(dxAccum += event.xrel() * scale);
        int wholeDy = Math.round(dyAccum -= event.yrel() * scale);
        dxAccum -= (float)wholeDx;
        dyAccum -= (float)wholeDy;
        dx += wholeDx;
        dy += wholeDy;
        latestX = (int)mouseX;
        latestY = Display.getHeight() - (int)mouseY;
        if (ignoreNextDelta > 0) {
            --ignoreNextDelta;
            x = latestX;
            y = latestY;
            lastEventX = latestX;
            lastEventY = latestY;
            dx = 0;
            dy = 0;
            dxAccum = 0.0f;
            dyAccum = 0.0f;
            dxFloat = 0.0f;
            dyFloat = 0.0f;
        }
        Mouse.lastxEvents[Mouse.queue.getNextPos()] = lastEventX;
        Mouse.lastyEvents[Mouse.queue.getNextPos()] = lastEventY;
        lastEventX = latestX;
        lastEventY = latestY;
        Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
        Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
        Mouse.wheelEvents[Mouse.queue.getNextPos()] = 0;
        Mouse.buttonEvents[Mouse.queue.getNextPos()] = -1;
        Mouse.buttonEventStates[Mouse.queue.getNextPos()] = false;
        Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
        queue.add();
    }

    public static void addButtonEvent(int button, boolean pressed) {
        Mouse.lastxEvents[Mouse.queue.getNextPos()] = lastEventX;
        Mouse.lastyEvents[Mouse.queue.getNextPos()] = lastEventY;
        lastEventX = latestX;
        lastEventY = latestY;
        Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
        Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
        Mouse.wheelEvents[Mouse.queue.getNextPos()] = 0;
        Mouse.buttonEvents[Mouse.queue.getNextPos()] = button;
        Mouse.buttonEventStates[Mouse.queue.getNextPos()] = pressed;
        Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
        queue.add();
    }

    public static void addWheelEvent(double delta) {
        if (Config.INPUT_INVERT_WHEEL) {
            delta = -delta;
        }
        delta *= Config.INPUT_SCROLL_SPEED;
        if (Config.FORCE_DISCRETE_SCROLLING) {
            delta = Math.signum(delta);
        }
        int lastWheel = (int)fractionalWheelPosition;
        totalScrollAmount += delta;
        int newWheel = (int)(fractionalWheelPosition += delta);
        if (newWheel != lastWheel) {
            Mouse.lastxEvents[Mouse.queue.getNextPos()] = lastEventX;
            Mouse.lastyEvents[Mouse.queue.getNextPos()] = lastEventY;
            lastEventX = latestX;
            lastEventY = latestY;
            dwheel += newWheel - lastWheel;
            Mouse.xEvents[Mouse.queue.getNextPos()] = latestX;
            Mouse.yEvents[Mouse.queue.getNextPos()] = latestY;
            Mouse.wheelEvents[Mouse.queue.getNextPos()] = newWheel - lastWheel;
            Mouse.buttonEvents[Mouse.queue.getNextPos()] = -1;
            Mouse.buttonEventStates[Mouse.queue.getNextPos()] = false;
            Mouse.nanoTimeEvents[Mouse.queue.getNextPos()] = Sys.getNanoTime();
            queue.add();
        }
        fractionalWheelPosition %= 1.0;
    }

    public static void poll() {
        if (!grabbed && clipPostionToDisplay) {
            if (latestX < 0) {
                latestX = 0;
            }
            if (latestY < 0) {
                latestY = 0;
            }
            if (latestX > Display.getWidth() - 1) {
                latestX = Display.getWidth() - 1;
            }
            if (latestY > Display.getHeight() - 1) {
                latestY = Display.getHeight() - 1;
            }
        }
        x = latestX;
        y = latestY;
    }

    public static void create() {
        if (currentCursor != null) {
            Mouse.setNativeCursor(currentCursor);
        }
    }

    public static boolean isCreated() {
        return Display.isCreated();
    }

    public static void setGrabbed(boolean grab) {
        if (grabbed == grab) {
            return;
        }
        MainThreadExec.runOnMainThread(() -> {
            try (MemoryStack ms = MemoryStack.stackPush();){
                IntBuffer w = ms.ints(0);
                IntBuffer h = ms.ints(0);
                SDLVideo.SDL_GetWindowSize((long)Display.getWindow(), (IntBuffer)w, (IntBuffer)h);
                if (!grab) {
                    SDLMouse.SDL_WarpMouseInWindow((long)Display.getWindow(), (float)((float)w.get(0) / 2.0f), (float)((float)h.get(0) / 2.0f));
                }
                SDLMouse.SDL_SetWindowRelativeMouseMode((long)Display.getWindow(), (boolean)grab);
                if (!grab) {
                    SDLMouse.SDL_WarpMouseInWindow((long)Display.getWindow(), (float)((float)w.get(0) / 2.0f), (float)((float)h.get(0) / 2.0f));
                }
                dx = 0;
                dy = 0;
                dxAccum = 0.0f;
                dyAccum = 0.0f;
                dxFloat = 0.0f;
                dyFloat = 0.0f;
            }
        });
        grabbed = grab;
    }

    public static boolean isGrabbed() {
        return grabbed;
    }

    public static boolean isButtonDown(int button) {
        return (sdlMouseButtonFlags & 1 << Mouse.lwjglToSdlMouseButton(button) - 1) != 0;
    }

    public static boolean next() {
        return queue.next();
    }

    public static int getEventX() {
        return xEvents[queue.getCurrentPos()];
    }

    public static int getEventY() {
        return yEvents[queue.getCurrentPos()];
    }

    public static int getEventDX() {
        return xEvents[queue.getCurrentPos()] - lastxEvents[queue.getCurrentPos()];
    }

    public static int getEventDY() {
        return yEvents[queue.getCurrentPos()] - lastyEvents[queue.getCurrentPos()];
    }

    public static long getEventNanoseconds() {
        return nanoTimeEvents[queue.getCurrentPos()];
    }

    public static int getEventButton() {
        return buttonEvents[queue.getCurrentPos()];
    }

    public static boolean getEventButtonState() {
        return buttonEventStates[queue.getCurrentPos()];
    }

    public static int getEventDWheel() {
        return wheelEvents[queue.getCurrentPos()];
    }

    public static int getX() {
        return x;
    }

    public static int getY() {
        return y;
    }

    public static int getDX() {
        int value = dx;
        dx = 0;
        dxFloat = 0.0f;
        return value;
    }

    public static int getDY() {
        int value = dy;
        dy = 0;
        dyFloat = 0.0f;
        return value;
    }

    public static float lwjgl3ify$getDXFloat() {
        float value = dxFloat;
        dx = 0;
        dxFloat = 0.0f;
        return value;
    }

    public static float lwjgl3ify$getDYFloat() {
        float value = dyFloat;
        dy = 0;
        dyFloat = 0.0f;
        return value;
    }

    public static void lwjgl3ify$updateMouseHelper(FloatMouseHelper mouseHelper) {
        mouseHelper.lwjgl3ify$setIntDX(dx);
        mouseHelper.lwjgl3ify$setIntDY(dy);
        mouseHelper.lwjgl3ify$setFloatDX(dxFloat);
        mouseHelper.lwjgl3ify$setFloatDY(dyFloat);
        dx = 0;
        dxFloat = 0.0f;
        dy = 0;
        dyFloat = 0.0f;
    }

    public static int getDWheel() {
        int value = dwheel;
        dwheel = 0;
        return value;
    }

    public static int getButtonCount() {
        return 8;
    }

    public static void setClipMouseCoordinatesToWindow(boolean clip) {
        clipPostionToDisplay = clip;
    }

    public static void setCursorPosition(int new_x, int new_y) {
        if (grabbed) {
            return;
        }
        float inv_scale = 1.0f / Display.getPixelScaleFactor();
        MainThreadExec.runOnMainThread(() -> SDLMouse.SDL_WarpMouseInWindow((long)Display.getWindow(), (float)((float)new_x * inv_scale), (float)((float)new_y * inv_scale)));
    }

    public static synchronized Cursor getNativeCursor() {
        return currentCursor;
    }

    public static synchronized Cursor setNativeCursor(Cursor cursor) {
        Cursor prevCursor = currentCursor;
        currentCursor = cursor;
        if (!Display.isCreated()) {
            return prevCursor;
        }
        if (cursor == null) {
            if (systemCursor == 0L) {
                systemCursor = Sys.checkSdl(SDLMouse.SDL_CreateSystemCursor((int)0));
            }
            MainThreadExec.runOnMainThread(() -> SDLMouse.SDL_SetCursor((long)systemCursor));
        } else {
            cursor.sdlSet();
        }
        return prevCursor;
    }

    public static void destroy() {
    }

    public static int getButtonIndex(String buttonName) {
        if (buttonName.matches("BUTTON[0-9]+")) {
            return Integer.parseInt(StringUtils.removeStart((String)buttonName, (String)"BUTTON"));
        }
        return -1;
    }

    public static String getButtonName(int button) {
        return "BUTTON" + button;
    }

    public static boolean hasWheel() {
        return true;
    }

    public static boolean isClipMouseCoordinatesToWindow() {
        return clipPostionToDisplay;
    }

    public static boolean isInsideWindow() {
        return Display.isVisible();
    }

    public static void updateCursor() {
    }
}

