/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncher;

import com.google.common.base.Throwables;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import me.eigenraven.lwjgl3ify.relauncher.Downloader;
import me.eigenraven.lwjgl3ify.relauncher.JvmLocator;
import me.eigenraven.lwjgl3ify.relauncher.ProgressDialog;
import me.eigenraven.lwjgl3ify.relauncher.Relauncher;
import me.eigenraven.lwjgl3ify.relauncher.RelauncherConfig;
import me.eigenraven.lwjgl3ify.relauncher.SettingsDialog;
import org.apache.commons.lang3.StringUtils;

public class RelauncherUserInterface {
    private final Relauncher relauncher;
    private boolean swingInitialized = false;
    public boolean runClicked = false;

    public RelauncherUserInterface(Relauncher relauncher) {
        this.relauncher = relauncher;
    }

    private void initSwingIfNeeded() {
        if (this.swingInitialized) {
            return;
        }
        this.swingInitialized = true;
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        ClassLoader mcLoader = RelauncherUserInterface.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(mcLoader);
        try {
            System.setProperty("awt.useSystemAAFontSettings", "on");
            if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux")) {
                UIManager.setLookAndFeel("javax.swing.plaf.nimbus.NimbusLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            Relauncher.logger.warn("Could not initialize GUI theme", (Throwable)e);
        }
        Thread.currentThread().setContextClassLoader(original);
    }

    private void invokeOnSwingThread(boolean wait, Runnable runnable) {
        try {
            if (wait) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public void downloadWithGui(Downloader dler) {
        this.invokeOnSwingThread(true, () -> {
            this.initSwingIfNeeded();
            int totalTasks = dler.remainingTasks();
            JDialog progressDialog = new JDialog(null, "Lwjgl3ify Library Downloader", Dialog.ModalityType.APPLICATION_MODAL);
            progressDialog.setMinimumSize(new Dimension(400, 128));
            progressDialog.setSize(new Dimension(400, 128));
            progressDialog.setLocationRelativeTo(null);
            progressDialog.setResizable(false);
            progressDialog.setDefaultCloseOperation(2);
            ProgressDialog dialogContent = new ProgressDialog();
            dialogContent.loadTranslations();
            progressDialog.add(dialogContent.panel);
            dialogContent.progressBar.setMinimum(0);
            dialogContent.progressBar.setMaximum(totalTasks);
            dialogContent.progressBar.setValue(0);
            dialogContent.cancelButton.addActionListener(al -> this.relauncher.runtimeExit(1));
            final Thread dlThread = new Thread(dler::runDownloads, "Download thread");
            dlThread.setContextClassLoader(RelauncherUserInterface.class.getClassLoader());
            dlThread.setDaemon(true);
            final AtomicBoolean normallyTerminated = new AtomicBoolean(false);
            AtomicReference<Object> dlException = new AtomicReference<Object>(null);
            dlThread.setUncaughtExceptionHandler((_thread, exception) -> dlException.set(exception));
            Timer updater = new Timer(8, al -> {
                int remaining = dler.remainingTasks();
                dialogContent.progressBar.setValue(totalTasks - remaining);
                String files = StringUtils.join(dler.busyDownloads, (String)", ");
                dialogContent.filesLabel.setText(files);
                if (remaining <= 0) {
                    try {
                        dlThread.join();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    Throwable exception = (Throwable)dlException.get();
                    if (exception != null) {
                        dialogContent.filesLabel.setText("Exception happened when downloading required files, check the log for details.\n" + exception);
                        throw Throwables.propagate((Throwable)exception);
                    }
                    normallyTerminated.set(true);
                    progressDialog.dispose();
                }
            });
            updater.start();
            progressDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (!normallyTerminated.get()) {
                        RelauncherUserInterface.this.relauncher.runtimeExit(1);
                    }
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    dlThread.start();
                }
            });
            progressDialog.setVisible(true);
        });
    }

    private static long getTotalMemoryBytes() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
            return Long.parseLong(attribute.toString());
        }
        catch (Exception e) {
            return 8192L;
        }
    }

    public void startSettingsIfNeeded() {
        if (RelauncherConfig.config.hideSettingsOnLaunch) {
            return;
        }
        this.invokeOnSwingThread(true, () -> {
            this.initSwingIfNeeded();
            JDialog settingsDialog = new JDialog(null, "Lwjgl3ify settings", Dialog.ModalityType.APPLICATION_MODAL);
            settingsDialog.setMinimumSize(new Dimension(800, 600));
            settingsDialog.setSize(new Dimension(800, 600));
            settingsDialog.setLocationRelativeTo(null);
            settingsDialog.setResizable(true);
            settingsDialog.setDefaultCloseOperation(2);
            final SettingsDialog contents = new SettingsDialog();
            contents.loadTranslations();
            settingsDialog.add(contents.rootPanel);
            long totalSystemMemory = RelauncherUserInterface.getTotalMemoryBytes();
            int totalSystemMemoryMB = (int)((totalSystemMemory + 0x100000L - 1L) / 0x100000L);
            contents.optMinMemory.setMaximum(totalSystemMemoryMB);
            contents.optMaxMemory.setMaximum(totalSystemMemoryMB);
            int memTickSpacing = 1024;
            while (totalSystemMemoryMB / memTickSpacing > 9) {
                memTickSpacing *= 2;
            }
            contents.optMinMemory.setLabelTable(null);
            contents.optMaxMemory.setLabelTable(null);
            contents.optMinMemory.setMajorTickSpacing(memTickSpacing);
            contents.optMaxMemory.setMajorTickSpacing(memTickSpacing);
            contents.labelMinJavaVer.setText(String.format(contents.translations.getString("minModJava"), 17));
            RelauncherConfig.ConfigObject initCfg = RelauncherConfig.config;
            DefaultComboBoxModel<String> modelJavaPaths = new DefaultComboBoxModel<String>((String[])initCfg.javaInstallationsCache.clone());
            contents.comboJavaExecutable.setModel(modelJavaPaths);
            if (modelJavaPaths.getSize() > 0) {
                contents.comboJavaExecutable.setSelectedIndex(initCfg.javaInstallation);
            }
            contents.optMinMemory.setValue(initCfg.minMemoryMB);
            contents.optMaxMemory.setValue(initCfg.maxMemoryMB);
            contents.optGC.setModel(new GCComboModel());
            contents.optGC.setSelectedItem((Object)initCfg.garbageCollector);
            contents.optCustom.getDocument().putProperty("__EndOfLine__", "\n");
            contents.optCustom.setText(initCfg.customOptionsToQuotedString());
            contents.optForwardLogs.setSelected(initCfg.forwardLogs);
            contents.optDebugAgent.setSelected(initCfg.allowDebugger);
            contents.optDebugSuspend.setSelected(initCfg.waitForDebugger);
            contents.optMixinDebug.setSelected(initCfg.mixinDebug);
            contents.optMixinExport.setSelected(initCfg.mixinDebugExport);
            contents.optMixinCount.setSelected(initCfg.mixinDebugCount);
            contents.optFmlDebugAts.setSelected(initCfg.fmlDebugAts);
            contents.optRfbDumpClasses.setSelected(initCfg.rfbDumpClasses);
            contents.optRfbDumpTransformers.setSelected(initCfg.rfbDumpPerTransformer);
            contents.optHideOnFutureLaunches.setSelected(initCfg.hideSettingsOnLaunch);
            contents.optHideOnFutureLaunches.setEnabled(false);
            contents.optHideOnFutureLaunches.setVisible(false);
            RelauncherUserInterface.refreshJavaInstalls(contents);
            RelauncherUserInterface.saveConfig(contents);
            settingsDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RelauncherUserInterface.saveConfig(contents);
                }
            });
            contents.buttonAddJava.addActionListener(al -> {
                JFileChooser jfc = new JFileChooser();
                jfc.setFileSelectionMode(0);
                jfc.setDialogType(0);
                jfc.setDialogTitle("Pick java executable");
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f == null) {
                            return false;
                        }
                        String name = f.getName();
                        return !f.isFile() || name.equalsIgnoreCase("java") || name.equalsIgnoreCase("javaw") || name.equalsIgnoreCase("java.exe") || name.equalsIgnoreCase("javaw.exe");
                    }

                    @Override
                    public String getDescription() {
                        return "Java binaries";
                    }
                };
                jfc.addChoosableFileFilter(fileFilter);
                jfc.setFileFilter(fileFilter);
                int result = jfc.showOpenDialog(settingsDialog);
                if (result == 0) {
                    String path = jfc.getSelectedFile().getAbsolutePath();
                    DefaultComboBoxModel model = (DefaultComboBoxModel)contents.comboJavaExecutable.getModel();
                    model.addElement(path);
                    model.setSelectedItem(path);
                    RelauncherUserInterface.refreshJavaInstalls(contents);
                }
            });
            contents.buttonPreviewJavaOpts.addActionListener(al -> {
                RelauncherUserInterface.saveConfig(contents);
                JOptionPane.showMessageDialog(settingsDialog, String.join((CharSequence)System.lineSeparator(), RelauncherConfig.config.toJvmArgs()), "Java", 1);
            });
            contents.buttonRun.addActionListener(al -> {
                this.runClicked = true;
                RelauncherUserInterface.saveConfig(contents);
                settingsDialog.dispose();
            });
            settingsDialog.setVisible(true);
        });
    }

    private static void refreshJavaInstalls(SettingsDialog contents) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)contents.comboJavaExecutable.getModel();
        String oldSelection = Objects.toString(model.getSelectedItem());
        List<Path> validInstalls = JvmLocator.detectJavaInstalls(RelauncherUserInterface.comboToList(model));
        model.removeAllElements();
        for (Path p : validInstalls) {
            String pString = p.toString();
            model.addElement(pString);
            if (!pString.equals(oldSelection)) continue;
            model.setSelectedItem(pString);
        }
    }

    private static <T> List<T> comboToList(ComboBoxModel<T> model) {
        ArrayList out = new ArrayList(model.getSize());
        for (int i = 0; i < model.getSize(); ++i) {
            out.add(model.getElementAt(i));
        }
        return out;
    }

    private static void saveConfig(SettingsDialog contents) {
        RelauncherConfig.ConfigObject initCfg = RelauncherConfig.config;
        initCfg.javaInstallationsCache = RelauncherUserInterface.comboToList(contents.comboJavaExecutable.getModel()).toArray(new String[0]);
        initCfg.javaInstallation = contents.comboJavaExecutable.getSelectedIndex();
        initCfg.minMemoryMB = contents.optMinMemory.getValue();
        initCfg.maxMemoryMB = contents.optMaxMemory.getValue();
        initCfg.garbageCollector = (RelauncherConfig.GCOption)((Object)contents.optGC.getSelectedItem());
        initCfg.setCustomOptionsFromQuotedString(contents.optCustom.getText().replace("\r\n", "\n"));
        initCfg.forwardLogs = contents.optForwardLogs.isSelected();
        initCfg.allowDebugger = contents.optDebugAgent.isSelected();
        initCfg.waitForDebugger = contents.optDebugSuspend.isSelected();
        initCfg.mixinDebug = contents.optMixinDebug.isSelected();
        initCfg.mixinDebugExport = contents.optMixinExport.isSelected();
        initCfg.mixinDebugCount = contents.optMixinCount.isSelected();
        initCfg.fmlDebugAts = contents.optFmlDebugAts.isSelected();
        initCfg.rfbDumpClasses = contents.optRfbDumpClasses.isSelected();
        initCfg.rfbDumpPerTransformer = contents.optRfbDumpTransformers.isSelected();
        initCfg.hideSettingsOnLaunch = contents.optHideOnFutureLaunches.isSelected();
        RelauncherConfig.save();
    }

    public static class GCComboModel
    extends DefaultComboBoxModel<RelauncherConfig.GCOption> {
        public GCComboModel() {
            super(RelauncherConfig.GCOption.values());
        }
    }
}

