/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncher;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LetsEncryptAdder {
    private static boolean alreadyAdded = false;
    private static final Logger LOGGER = LogManager.getLogger(LetsEncryptAdder.class);

    private static void trustLetsEncryptRoots() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream keystoreBytes = Objects.requireNonNull(LetsEncryptAdder.class.getResourceAsStream("/assets/lwjgl3ify/ssl/java-cacerts.jks"));){
            keyStore.load(keystoreBytes, "changeit".toCharArray());
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmf.getTrustManagers(), null);
        SSLContext.setDefault(sslContext);
    }

    public static void addLetsEncryptCertificates() {
        int minorVersion;
        String majorVersion;
        if (alreadyAdded) {
            return;
        }
        String version = System.getProperty("java.version");
        Pattern p = Pattern.compile("^(\\d+\\.\\d+).*?_(\\d+).*");
        Matcher matcher = p.matcher(version);
        if (matcher.matches()) {
            majorVersion = matcher.group(1);
            minorVersion = Integer.parseInt(matcher.group(2));
        } else {
            majorVersion = "1.7";
            minorVersion = 110;
            LOGGER.info("Regex to parse Java version failed - applying anyway.");
        }
        switch (majorVersion) {
            case "1.7": {
                if (minorVersion < 111) break;
                LOGGER.info("Not running as Java version is at least Java 7u111.");
                alreadyAdded = true;
                return;
            }
            case "1.8": {
                if (minorVersion < 101) break;
                LOGGER.info("Not running as Java version is at least Java 8u101.");
                alreadyAdded = true;
                return;
            }
        }
        try {
            LetsEncryptAdder.trustLetsEncryptRoots();
            LOGGER.info("Added Let's Encrypt certificate to the Java SSL trust store.");
        }
        catch (Exception e) {
            LOGGER.error("An error occurred whilst adding the Let's Encrypt root certificate. I'm afraid you wont be able to access resources with a Let's Encrypt certificate D:", (Throwable)e);
        }
        alreadyAdded = true;
    }
}

