/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.client;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import me.eigenraven.lwjgl3ify.CommonProxy;
import me.eigenraven.lwjgl3ify.api.InputEvents;
import me.eigenraven.lwjgl3ify.client.GLDebugLog;
import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import me.eigenraven.lwjgl3ify.client.TextFieldHandler;
import me.eigenraven.lwjgl3ify.core.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.Version;
import org.lwjgl.sdl.SDLVersion;
import org.lwjgl.sdl.SDLVideo;
import org.lwjglx.input.Keyboard;
import org.lwjglx.opengl.Display;

public class ClientProxy
extends CommonProxy {
    static final String javaVersion;
    static final String lwjglVersion;
    private static final AtomicBoolean gameIsLoading;
    static float lastProgress;

    @Override
    public void runCompatHooks() {
        super.runCompatHooks();
        if (Config.DEBUG_REGISTER_OPENGL_LOGGER) {
            GLDebugLog.setupDebugMessageCallback();
        }
        Keyboard.populateKeyLookupTables();
        this.registerKeybindHandler();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    private void registerKeybindHandler() {
        InputEvents.addKeyboardListener(new McKeybindHandler());
    }

    @Override
    public void registerEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderGameOverlayTextEvent(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P && event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            if (Config.SHOW_LWJGL_VERSION) {
                event.right.add(Math.min(3, event.right.size()), lwjglVersion);
            }
            if (Config.SHOW_JAVA_VERSION) {
                event.right.add(Math.min(3, event.right.size()), javaVersion);
            }
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.modID.equals("lwjgl3ify")) {
            return;
        }
        Config.config.save();
        Config.reloadConfigObject();
        Display.lwjgl3ify$updateRawMouseMode(Config.INPUT_RAW_MOUSE);
    }

    @SubscribeEvent
    public void onGuiChange(GuiOpenEvent event) {
        GuiScreen oldScreen = Minecraft.func_71410_x().field_71462_r;
        GuiScreen newScreen = event.gui;
        if (gameIsLoading.get()) {
            gameIsLoading.set(false);
            MainThreadExec.runOnMainThread(() -> SDLVideo.SDL_SetWindowProgressState((long)Display.getWindow(), (int)0));
        }
        if (oldScreen != newScreen) {
            TextFieldHandler.resetTextInput();
        }
    }

    public static void onProgressUpdate() {
        if (!Config.WINDOW_LOADING_PROGRESS || !gameIsLoading.get()) {
            return;
        }
        float newProgress = 0.0f;
        float curUnit = 1.0f;
        Iterator it = ProgressManager.barIterator();
        while (it.hasNext()) {
            ProgressManager.ProgressBar bar = (ProgressManager.ProgressBar)it.next();
            float barUnit = 1.0f / (float)(bar.getSteps() + 1);
            float barProgress = (float)(bar.getStep() + 1) * barUnit;
            newProgress += curUnit * barProgress;
            curUnit *= barUnit;
        }
        if (Math.abs((newProgress = Math.max(0.0f, Math.min(newProgress, 1.0f))) - lastProgress) < 0.01f) {
            return;
        }
        float finalNewProgress = newProgress;
        MainThreadExec.runOnMainThread(() -> {
            long window = Display.getWindow();
            SDLVideo.SDL_SetWindowProgressState((long)window, (int)2);
            SDLVideo.SDL_SetWindowProgressValue((long)window, (float)finalNewProgress);
        });
        lastProgress = finalNewProgress;
    }

    static {
        String javaVersionRaw = "Java: " + System.getProperty("java.version");
        if (javaVersionRaw.length() > 32) {
            javaVersionRaw = javaVersionRaw.substring(0, 29) + "...";
        }
        javaVersion = javaVersionRaw;
        int sdlVer = SDLVersion.SDL_GetVersion();
        int sdlMajor = SDLVersion.SDL_VERSIONNUM_MAJOR((int)sdlVer);
        int sdlMinor = SDLVersion.SDL_VERSIONNUM_MINOR((int)sdlVer);
        int sdlMicro = SDLVersion.SDL_VERSIONNUM_MICRO((int)sdlVer);
        lwjglVersion = String.format("LWJGL: %s  SDL: %d.%d.%d", Version.getVersion(), sdlMajor, sdlMinor, sdlMicro);
        gameIsLoading = new AtomicBoolean(true);
        lastProgress = -1.0f;
    }

    private static final class McKeybindHandler
    implements InputEvents.KeyboardListener {
        private McKeybindHandler() {
        }

        @Override
        public void onKeyEvent(InputEvents.KeyEvent event) {
        }

        @Override
        public void onTextEvent(InputEvents.TextEvent event) {
            TextFieldHandler.onTextInput(event);
        }
    }
}

