/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lain.lib.SharedPool;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.impl.Shared;
import lain.mods.skins.impl.SkinData;
import lain.mods.skins.impl.forge.MinecraftUtils;

public class MojangSkinProvider
implements ISkinProvider {
    private Function<ByteBuffer, ByteBuffer> _filter;

    @Override
    public ISkin getSkin(IPlayerProfile profile) {
        SkinData skin = new SkinData();
        if (this._filter != null) {
            skin.setSkinFilter(this._filter);
        }
        SharedPool.execute(() -> {
            Map textures = MinecraftUtils.getSessionService().getTextures((GameProfile)profile.getOriginal(), false);
            if (textures != null && textures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                MinecraftProfileTexture tex = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
                ((CompletableFuture)Shared.downloadSkin(tex.getUrl(), Runnable::run).thenApply(Optional::get)).thenAccept(data -> {
                    if (SkinData.validateData(data)) {
                        skin.put((byte[])data, SkinData.getSkinType(tex));
                    }
                });
            }
        });
        return skin;
    }

    public MojangSkinProvider withFilter(Function<ByteBuffer, ByteBuffer> filter) {
        this._filter = filter;
        return this;
    }
}

