/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.impl;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import lain.mods.skins.api.interfaces.ISkin;

public class SkinData
implements ISkin {
    private volatile ByteBuffer data;
    private volatile String type;
    private final Collection<Consumer<ISkin>> listeners = new CopyOnWriteArrayList<Consumer<ISkin>>();
    private final Collection<Function<ByteBuffer, ByteBuffer>> filters = new CopyOnWriteArrayList<Function<ByteBuffer, ByteBuffer>>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String judgeSkinType(byte[] data) {
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            BufferedImage image = ImageIO.read(input);
            int w = image.getWidth();
            int h = image.getHeight();
            if (w == h * 2) {
                String string = "default";
                return string;
            }
            if (w == h) {
                int r = Math.max(w / 64, 1);
                if ((image.getRGB(55 * r, 20 * r) & 0xFF000000) >>> 24 == 0) {
                    String string = "slim";
                    return string;
                }
                String string = "default";
                return string;
            }
            String string = "unknown";
            return string;
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    public static String getSkinType(MinecraftProfileTexture tex) {
        String model = tex.getMetadata("model");
        if (model == null) {
            return "default";
        }
        return model;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String judgeSkinType(ByteBuffer data) {
        try (InputStream input = SkinData.wrapByteBufferAsInputStream(data);){
            BufferedImage image = ImageIO.read(input);
            int w = image.getWidth();
            int h = image.getHeight();
            if (w == h * 2) {
                String string = "default";
                return string;
            }
            if (w == h) {
                int r = Math.max(w / 64, 1);
                if ((image.getRGB(55 * r, 20 * r) & 0xFF000000) >>> 24 == 0) {
                    String string = "slim";
                    return string;
                }
                String string = "default";
                return string;
            }
            String string = "unknown";
            return string;
        }
        catch (Throwable t) {
            return "unknown";
        }
    }

    public static ByteBuffer toBuffer(byte[] data) {
        ByteBuffer buf = ByteBuffer.allocateDirect(data.length).order(ByteOrder.nativeOrder());
        buf.put(data);
        buf.rewind();
        return buf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateData(byte[] data) {
        try (ByteArrayInputStream input = new ByteArrayInputStream(data);){
            boolean bl = ImageIO.read(input) != null;
            return bl;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static InputStream wrapByteBufferAsInputStream(ByteBuffer original) {
        final ByteBuffer buf = original.duplicate();
        return new InputStream(){

            @Override
            public int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }

    @Override
    public ByteBuffer getData() {
        return this.data;
    }

    @Override
    public String getSkinType() {
        return this.type;
    }

    @Override
    public boolean isDataReady() {
        return this.data != null;
    }

    @Override
    public synchronized void onRemoval() {
        for (Consumer<ISkin> listener : this.listeners) {
            listener.accept(this);
        }
        this.data = null;
        this.type = null;
    }

    public synchronized void put(byte[] data, String type) {
        ByteBuffer buf = null;
        if (data != null) {
            Function<ByteBuffer, ByteBuffer> filter;
            buf = SkinData.toBuffer(data);
            Iterator<Function<ByteBuffer, ByteBuffer>> iterator = this.filters.iterator();
            while (iterator.hasNext() && (buf = (filter = iterator.next()).apply(buf)) != null) {
            }
        }
        this.type = type;
        this.data = buf;
    }

    @Override
    public boolean setRemovalListener(Consumer<ISkin> listener) {
        if (listener == null || this.listeners.contains(listener)) {
            return false;
        }
        return this.listeners.add(listener);
    }

    @Override
    public boolean setSkinFilter(Function<ByteBuffer, ByteBuffer> filter) {
        if (filter == null || this.filters.contains(filter)) {
            return false;
        }
        return this.filters.add(filter);
    }
}

