/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skinport.init.forge;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.UUID;
import lain.mods.skinport.impl.forge.SkinCustomization;
import lain.mods.skinport.impl.forge.network.NetworkManager;
import lain.mods.skinport.impl.forge.network.packet.PacketGet0;
import lain.mods.skinport.impl.forge.network.packet.PacketGet1;
import lain.mods.skinport.impl.forge.network.packet.PacketPut0;
import lain.mods.skinport.impl.forge.network.packet.PacketPut1;
import lain.mods.skinport.init.forge.CommonProxy;
import lain.mods.skinport.init.forge.DefaultSkins;
import lain.mods.skins.api.SkinProviderAPI;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.impl.SkinData;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@Mod(modid="skinport", useMetadata=true)
public class ForgeSkinPort {
    @SidedProxy(clientSide="lain.mods.skinport.init.forge.ClientProxy", serverSide="lain.mods.skinport.init.forge.CommonProxy")
    public static CommonProxy proxy = new CommonProxy();
    public static NetworkManager network = new NetworkManager("skinport");

    public static void loadOptions() {
        try {
            for (String line : FileUtils.readLines((File)Paths.get(".", "options_skinport.txt").toFile(), (Charset)StandardCharsets.UTF_8)) {
                String[] as = line.split(":", 2);
                if (as.length != 2 || as[0].startsWith("#") || !"clientFlags".equals(as[0])) continue;
                SkinCustomization.ClientFlags = Integer.parseInt(as[1]);
            }
        }
        catch (FileNotFoundException | NumberFormatException e) {
            ForgeSkinPort.saveOptions();
        }
        catch (IOException e) {
            System.err.println(String.format("Error loading options: %s", e.getMessage()));
        }
    }

    public static void saveOptions() {
        try {
            FileUtils.write((File)Paths.get(".", "options_skinport.txt").toFile(), (CharSequence)String.format("clientFlags:%d", SkinCustomization.ClientFlags), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println(String.format("Error saving options: %s", e.getMessage()));
        }
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        if (event.getSide().isClient()) {
            DefaultSkins.INSTANCE = new DefaultSkins();
            ForgeSkinPort.loadOptions();
            SkinProviderAPI.SKIN.clearProviders();
            SkinProviderAPI.SKIN.registerProvider(new DefaultSkinProvider());
            SkinProviderAPI.CAPE.clearProviders();
        }
        network.registerPacket(1, PacketGet0.class);
        network.registerPacket(2, PacketPut0.class);
        network.registerPacket(3, PacketGet1.class);
        network.registerPacket(4, PacketPut1.class);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        FMLCommonHandler.instance().bus().register((Object)proxy);
    }

    private static class DefaultSkinProvider
    implements ISkinProvider {
        ISkin DefaultSteve;
        ISkin DefaultAlex;

        DefaultSkinProvider() {
            try {
                this.DefaultSteve = new SkinData();
                byte[] data = IOUtils.toByteArray((URL)DefaultSkinProvider.class.getResource("/DefaultSteve.png"));
                ((SkinData)this.DefaultSteve).put(data, "default");
                this.DefaultAlex = new SkinData();
                data = IOUtils.toByteArray((URL)DefaultSkinProvider.class.getResource("/DefaultAlex.png"));
                ((SkinData)this.DefaultAlex).put(data, "slim");
            }
            catch (IOException e) {
                this.DefaultSteve = null;
                this.DefaultAlex = null;
            }
        }

        @Override
        public ISkin getSkin(IPlayerProfile profile) {
            if (profile == null) {
                return this.DefaultSteve;
            }
            UUID uuid = profile.getPlayerID();
            if (uuid != null && (uuid.hashCode() & 1) == 1) {
                return this.DefaultAlex;
            }
            return this.DefaultSteve;
        }
    }
}

