/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skinport.init.forge;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import lain.mods.skinport.impl.forge.SkinCustomization;
import lain.mods.skinport.impl.forge.SkinPortGuiCustomizeSkin;
import lain.mods.skinport.impl.forge.SkinPortModelHumanoidHead;
import lain.mods.skinport.impl.forge.SkinPortRenderPlayer;
import lain.mods.skinport.impl.forge.SpecialModel;
import lain.mods.skinport.impl.forge.SpecialRenderer;
import lain.mods.skinport.impl.forge.compat.SkinPortRenderPlayer_MPM;
import lain.mods.skinport.impl.forge.compat.SkinPortRenderPlayer_RPA;
import lain.mods.skinport.init.forge.CommonProxy;
import lain.mods.skinport.init.forge.DefaultSkins;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.impl.forge.CustomSkinTexture;
import lain.mods.skins.impl.forge.MinecraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private static final Map<String, Render> renderers = new HashMap<String, Render>();
    private static final Map<ByteBuffer, CustomSkinTexture> textures = new WeakHashMap<ByteBuffer, CustomSkinTexture>();
    private static final SkinPortModelHumanoidHead modelHumanoidHead = new SkinPortModelHumanoidHead();
    private static Cache<GameProfile, String> modelCache = CacheBuilder.newBuilder().concurrencyLevel(2).build();

    public static ResourceLocation bindTexture(GameProfile profile, ResourceLocation result) {
        if (result != null && !result.func_110623_a().equals("textures/entity/steve.png")) {
            return result;
        }
        return DefaultSkins.INSTANCE.get(profile).getLocation();
    }

    public static ResourceLocation generateRandomLocation() {
        return new ResourceLocation("skinport", String.format("textures/generated/%s", UUID.randomUUID().toString()));
    }

    public static ModelSkeletonHead getHumanoidHead(ResourceLocation location, ModelSkeletonHead result) {
        return modelHumanoidHead;
    }

    public static ResourceLocation getLocationCape(AbstractClientPlayer player, ResourceLocation result) {
        return result;
    }

    public static ResourceLocation getLocationSkin(AbstractClientPlayer player, ResourceLocation result) {
        if (result != null && !result.func_110623_a().equals("textures/entity/steve.png")) {
            return result;
        }
        return DefaultSkins.INSTANCE.get(player.func_146103_bH()).getLocation();
    }

    public static CustomSkinTexture getOrCreateTexture(ByteBuffer data, ISkin skin) {
        if (!textures.containsKey(data)) {
            CustomSkinTexture texture = new CustomSkinTexture(ClientProxy.generateRandomLocation(), data);
            FMLClientHandler.instance().getClient().func_110434_K().func_110579_a(texture.getLocation(), (ITextureObject)texture);
            textures.put(data, texture);
            if (skin != null) {
                skin.setRemovalListener(s -> {
                    if (data == s.getData()) {
                        FMLClientHandler.instance().getClient().func_152344_a(() -> {
                            FMLClientHandler.instance().getClient().func_110434_K().func_147645_c(texture.getLocation());
                            textures.remove(data);
                        });
                    }
                });
            }
        }
        return textures.get(data);
    }

    public static Render getPlayerRenderer(RenderManager manager, AbstractClientPlayer player, Render result) {
        if (renderers.isEmpty()) {
            ClientProxy.setupRenderers(manager);
        }
        if ((result = renderers.getOrDefault(ClientProxy.getSkinType(player), result)) instanceof SpecialRenderer) {
            ((SpecialRenderer)result).onGetRenderer(manager, player);
        }
        return result;
    }

    public static String getSkinType(AbstractClientPlayer player) {
        String type;
        GameProfile profile = player.func_146103_bH();
        if (!profile.isComplete()) {
            return (player.func_110124_au().hashCode() & 1) == 0 ? "default" : "slim";
        }
        try {
            type = (String)modelCache.get((Object)profile, () -> ClientProxy.getSkinType(profile));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (type.isEmpty()) {
            return (player.func_110124_au().hashCode() & 1) == 0 ? "default" : "slim";
        }
        return type;
    }

    private static String getSkinType(GameProfile profile) {
        Map textures = MinecraftUtils.getSessionService().getTextures(profile, false);
        MinecraftProfileTexture texture = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
        if (texture == null) {
            return "";
        }
        String model = texture.getMetadata("model");
        if (model == null) {
            return "default";
        }
        return model;
    }

    public static boolean hasCape(AbstractClientPlayer player, boolean result) {
        return player.func_110303_q() != null;
    }

    public static boolean hasSkin(AbstractClientPlayer player, boolean result) {
        return player.func_110306_p() != null;
    }

    public static int initHeight(ModelBiped model, int textureHeight) {
        if (model instanceof SpecialModel) {
            return ((SpecialModel)model).initHeight();
        }
        return textureHeight;
    }

    public static int initWidth(ModelBiped model, int textureWidth) {
        if (model instanceof SpecialModel) {
            return ((SpecialModel)model).initWidth();
        }
        return textureWidth;
    }

    @SideOnly(value=Side.CLIENT)
    public static void onButtonAction(GuiOptions gui, GuiButton button) {
        if (!button.field_146124_l || button.field_146127_k != 110) {
            return;
        }
        gui.field_146297_k.field_71474_y.func_74303_b();
        gui.field_146297_k.func_147108_a((GuiScreen)new SkinPortGuiCustomizeSkin((GuiScreen)gui));
    }

    public static void setupButton(GuiOptions gui, List<GuiButton> buttonList) {
        buttonList.add(new GuiButton(110, gui.field_146294_l / 2 - 155, gui.field_146295_m / 6 + 48 - 6, 150, 20, I18n.func_135052_a((String)"options.skinCustomisation", (Object[])new Object[0])));
    }

    public static void setupRenderers(RenderManager manager) {
        if (Loader.isModLoaded((String)"moreplayermodels")) {
            renderers.put("default", (Render)new SkinPortRenderPlayer_MPM(manager, false));
            renderers.put("slim", (Render)new SkinPortRenderPlayer_MPM(manager, true));
        } else if (Loader.isModLoaded((String)"RenderPlayerAPI")) {
            renderers.put("default", (Render)new SkinPortRenderPlayer_RPA(manager, false));
            renderers.put("slim", (Render)new SkinPortRenderPlayer_RPA(manager, true));
        } else {
            renderers.put("default", (Render)new SkinPortRenderPlayer(manager, false));
            renderers.put("slim", (Render)new SkinPortRenderPlayer(manager, true));
        }
    }

    @SubscribeEvent
    public void handleClientTicks(TickEvent.ClientTickEvent event) {
        WorldClient world;
        if (event.phase == TickEvent.Phase.START && (world = Minecraft.func_71410_x().field_71441_e) != null) {
            for (Object obj : world.field_73010_i) {
                EntityPlayer entityPlayer = (EntityPlayer)obj;
            }
            if (TileEntityRendererDispatcher.field_147556_a.func_147546_a(TileEntitySkull.class).getClass() != TileEntitySkullRenderer.class) {
                ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySkull.class, (TileEntitySpecialRenderer)new TileEntitySkullRenderer());
            }
        }
    }

    @SubscribeEvent
    public void handleEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        SkinCustomization.Flags.clear(Side.CLIENT);
    }
}

