/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import cpw.mods.fml.client.config.GuiButtonExt;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.GuiUnicodeGlyphButton;
import cpw.mods.fml.client.config.GuiUtils;
import cpw.mods.fml.client.config.HoverChecker;
import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditRegistryConfig
extends GuiScreen {
    public static final String OMITTED = "..";
    public static final int LIST_WINDOW_PADDING = 20;
    public static final int MID_SECTION_WIDTH = 10;
    public final GuiScreen parentScreen;
    private final IConfigElement<String> disabledElement;
    private final String[] beforeDisabledValue;
    private final IConfigElement<String> orderElement;
    private final String[] beforeOrderValue;
    final Collection<EntriesList> lists;
    private final String registryName;
    EntriesList disabledEntries;
    EntriesList orderEntries;
    public String title = "Config GUI";
    public String titleLine2;
    private GuiButtonExt btnDefault;
    private GuiButtonExt btnUndoAll;
    public final String modID;
    public final String configID;
    public final boolean isWorldRunning;
    public final boolean allRequireWorldRestart;
    public final boolean allRequireMcRestart;
    public boolean needsRefresh = true;
    private HoverChecker undoHoverChecker;
    private HoverChecker resetHoverChecker;

    public GuiEditRegistryConfig(GuiScreen parentScreen, IConfigElement disabled, IConfigElement order, String registryName, String modID, String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2) {
        this.field_146297_k = parentScreen.field_146297_k;
        this.lists = Collections.newSetFromMap(new WeakHashMap());
        this.disabledElement = disabled;
        this.beforeDisabledValue = (String[])this.disabledElement.getList();
        this.orderElement = order;
        this.beforeOrderValue = (String[])this.orderElement.getList();
        this.parentScreen = parentScreen;
        this.allRequireWorldRestart = allRequireWorldRestart;
        this.allRequireMcRestart = allRequireMcRestart;
        this.registryName = registryName;
        this.modID = modID;
        this.configID = configID;
        boolean bl = this.isWorldRunning = this.field_146297_k.field_71441_e != null;
        if (title != null) {
            this.title = title;
        }
        this.titleLine2 = titleLine2;
        if (this.titleLine2 != null && this.titleLine2.startsWith(" > ")) {
            this.titleLine2 = this.titleLine2.replaceFirst(" > ", "");
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.disabledEntries == null || this.needsRefresh) {
            this.disabledEntries = new EntriesList((this.field_146294_l - 10) / 2 - 20, 20, I18n.func_135052_a((String)"structurelib.configgui.disabled", (Object[])new Object[0]));
            this.disabledEntries.initEntries(Arrays.asList(this.disabledElement.getList()));
        } else {
            this.disabledEntries.reinit((this.field_146294_l - 10) / 2 - 20, 20);
        }
        if (this.orderEntries == null || this.needsRefresh) {
            this.orderEntries = new EntriesList((this.field_146294_l - 10) / 2 - 20, (this.field_146294_l + 10) / 2, I18n.func_135052_a((String)"structurelib.configgui.enabled", (Object[])new Object[0]));
            this.orderEntries.initEntries(Arrays.asList(this.orderElement.getList()));
        } else {
            this.orderEntries.reinit((this.field_146294_l - 10) / 2 - 20, (this.field_146294_l + 10) / 2);
        }
        this.needsRefresh = false;
        int undoGlyphWidth = this.field_146297_k.field_71466_p.func_78256_a("\u21b6") * 2;
        int resetGlyphWidth = this.field_146297_k.field_71466_p.func_78256_a("\u2604") * 2;
        int doneWidth = Math.max(this.field_146297_k.field_71466_p.func_78256_a(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])) + 20, 100);
        int undoWidth = this.field_146297_k.field_71466_p.func_78256_a(" " + I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.field_146297_k.field_71466_p.func_78256_a(" " + I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0])) + resetGlyphWidth + 20;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth + 5) / 2;
        this.field_146292_n.add(new GuiButtonExt(2000, this.field_146294_l / 2 - buttonWidthHalf, this.field_146295_m - 29, doneWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.btnDefault = new GuiUnicodeGlyphButton(2001, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.field_146295_m - 29, resetWidth, 20, " " + I18n.func_135052_a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]), "\u2604", 2.0f);
        this.field_146292_n.add(this.btnDefault);
        this.btnUndoAll = new GuiUnicodeGlyphButton(2002, this.field_146294_l / 2 - buttonWidthHalf + doneWidth + 5, this.field_146295_m - 29, undoWidth, 20, " " + I18n.func_135052_a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]), "\u21b6", 2.0f);
        this.field_146292_n.add(this.btnUndoAll);
        this.undoHoverChecker = new HoverChecker((GuiButton)this.btnUndoAll, 800);
        this.resetHoverChecker = new HoverChecker((GuiButton)this.btnDefault, 800);
    }

    public void func_146281_b() {
        if (this.configID != null && this.parentScreen instanceof GuiConfig) {
            GuiConfig parentGuiConfig = (GuiConfig)this.parentScreen;
            parentGuiConfig.needsRefresh = true;
            parentGuiConfig.func_73866_w_();
        }
        if (!(this.parentScreen instanceof GuiConfig)) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    public boolean saveConfigElements() {
        if (this.isChanged()) {
            this.disabledElement.set((Object[])((String[])this.disabledEntries.entries.stream().map(e -> e.name).toArray(String[]::new)));
            this.orderElement.set((Object[])((String[])this.orderEntries.entries.stream().map(e -> e.name).toArray(String[]::new)));
        }
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2000) {
            try {
                if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof GuiConfig)) && this.isChanged()) {
                    this.saveConfigElements();
                    if (Loader.isModLoaded((String)this.modID)) {
                        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, false);
                        FMLCommonHandler.instance().bus().post((Event)event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            FMLCommonHandler.instance().bus().post((Event)new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, false));
                        }
                        if (this.parentScreen instanceof GuiConfig) {
                            ((GuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.field_146297_k.func_147108_a(this.parentScreen);
        } else if (button.field_146127_k == 2001) {
            this.setToDefault();
        } else if (button.field_146127_k == 2002) {
            this.undoChanges();
        }
    }

    public boolean isInitialized() {
        return this.disabledEntries != null && this.orderEntries != null;
    }

    public void undoChanges() {
        this.disabledEntries.initEntries(Arrays.asList(this.beforeDisabledValue));
        this.orderEntries.initEntries(Arrays.asList(this.beforeOrderValue));
    }

    public void setToDefault() {
        this.disabledEntries.initEntries(Arrays.asList(this.disabledElement.getList()));
        this.orderEntries.initEntries(Arrays.asList(this.orderElement.getList()));
    }

    public boolean isDefault() {
        return !this.orderEntries.areContentEqual(this.orderElement.getDefaults()) || !this.disabledEntries.areContentEqual(this.disabledElement.getDefaults());
    }

    public boolean isChanged() {
        return !this.orderEntries.areContentEqual(this.beforeOrderValue) || !this.disabledEntries.areContentEqual(this.beforeDisabledValue);
    }

    protected void func_73864_a(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.disabledEntries.func_148179_a(x, y, mouseEvent) && !this.orderEntries.func_148179_a(x, y, mouseEvent)) {
            super.func_73864_a(x, y, mouseEvent);
        }
    }

    protected void func_146286_b(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.disabledEntries.func_148181_b(x, y, mouseEvent) && !this.orderEntries.func_148181_b(x, y, mouseEvent)) {
            super.func_146286_b(x, y, mouseEvent);
        }
    }

    protected void func_73869_a(char eventChar, int eventKey) {
        if (eventKey == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        }
    }

    String trimStringToWidth(String str, int width) {
        int elipsisWidth;
        int strwidth = this.field_146297_k.field_71466_p.func_78256_a(str);
        if (strwidth > width - (elipsisWidth = this.field_146297_k.field_71466_p.func_78256_a(OMITTED)) && elipsisWidth > strwidth) {
            return this.field_146297_k.field_71466_p.func_78269_a(str, width - elipsisWidth).trim() + OMITTED;
        }
        return str;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        for (EntriesList list : this.lists) {
            list.handleDrag(mouseX, mouseY, partialTicks);
        }
        this.func_146276_q_();
        for (EntriesList list : this.lists) {
            list.func_148128_a(mouseX, mouseY, partialTicks);
        }
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        String title2 = this.titleLine2;
        if (title2 != null) {
            title2 = this.trimStringToWidth(title2, this.field_146294_l - 6);
            this.func_73732_a(this.field_146289_q, title2, this.field_146294_l / 2, 18, 0xFFFFFF);
        }
        this.btnUndoAll.field_146124_l = this.isChanged();
        this.btnDefault.field_146124_l = this.isDefault();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (EntriesList list : this.lists) {
            list.drawScreenPost(mouseX, mouseY, partialTicks);
        }
        if (this.undoHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.field_146297_k.field_71466_p.func_78271_c(I18n.func_135052_a((String)"fml.configgui.tooltip.undoAll", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        if (this.resetHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.field_146297_k.field_71466_p.func_78271_c(I18n.func_135052_a((String)"fml.configgui.tooltip.resetAll", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
    }

    public void drawToolTip(List stringList, int x, int y) {
        this.func_146283_a(stringList, x, y);
    }

    private static String trans(String transKey, String fallback) {
        String translated = I18n.func_135052_a((String)transKey, (Object[])new Object[0]);
        return translated.equals(transKey) ? fallback : translated;
    }

    private class EntriesList
    extends GuiListExtended {
        final String heading;
        final List<ListEntry> entries;
        int controlX;

        public EntriesList(int width, int left, String heading) {
            super(GuiEditRegistryConfig.this.field_146297_k, width, GuiEditRegistryConfig.this.field_146295_m, GuiEditRegistryConfig.this.titleLine2 != null ? 33 : 23, GuiEditRegistryConfig.this.field_146295_m - 32, 20);
            this.entries = new ArrayList<ListEntry>();
            this.heading = heading;
            if (heading != null) {
                this.func_148133_a(true, GuiEditRegistryConfig.this.field_146297_k.field_71466_p.field_78288_b + 4);
            }
            this.func_148140_g(left);
            this.controlX = this.func_148137_d() - 20;
            GuiEditRegistryConfig.this.lists.add(this);
        }

        public void func_148128_a(int p_148128_1_, int p_148128_2_, float p_148128_3_) {
            GL11.glEnable((int)3089);
            ScaledResolution scaledresolution = new ScaledResolution(GuiEditRegistryConfig.this.field_146297_k, GuiEditRegistryConfig.this.field_146297_k.field_71443_c, GuiEditRegistryConfig.this.field_146297_k.field_71440_d);
            GL11.glScissor((int)((this.field_148152_e - 4) * scaledresolution.func_78325_e()), (int)((int)((scaledresolution.func_78324_d() - (double)(this.field_148154_c + 4)) * (double)scaledresolution.func_78325_e())), (int)((this.field_148155_a + 8) * scaledresolution.func_78325_e()), (int)((this.field_148158_l + 8) * scaledresolution.func_78325_e()));
            super.func_148128_a(p_148128_1_, p_148128_2_, p_148128_3_);
            GL11.glDisable((int)3089);
        }

        public void func_148136_c(int p_148136_1_, int p_148136_2_, int p_148136_3_, int p_148136_4_) {
        }

        protected void drawContainerBackground(Tessellator tessellator) {
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)0, (int)1);
            GL11.glDisable((int)3008);
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 64);
            tessellator.func_78377_a((double)this.field_148152_e, (double)this.field_148154_c, 0.0);
            tessellator.func_78377_a((double)this.field_148151_d, (double)this.field_148154_c, 0.0);
            tessellator.func_78377_a((double)this.field_148151_d, (double)this.field_148153_b, 0.0);
            tessellator.func_78377_a((double)this.field_148152_e, (double)this.field_148153_b, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
        }

        protected void func_148129_a(int p_148129_1_, int p_148129_2_, Tessellator p_148129_3_) {
            if (this.heading == null) {
                return;
            }
            FontRenderer fr = GuiEditRegistryConfig.this.field_146297_k.field_71466_p;
            fr.func_78276_b(this.heading, p_148129_1_ + this.field_148155_a / 2 - fr.func_78256_a(this.heading) / 2, Math.min(this.field_148153_b + 3, p_148129_2_), 0xFFFFFF);
        }

        void reinit(int width, int left) {
            this.field_148155_a = width;
            this.field_148154_c = GuiEditRegistryConfig.this.field_146295_m - 32;
            this.func_148140_g(left);
            this.controlX = this.func_148137_d() - 20;
        }

        void initEntries(Iterable<?> entries) {
            this.controlX = this.func_148137_d() - 20;
            this.entries.clear();
            for (Object entry : entries) {
                this.addEntry(new ListEntry(entry.toString()));
            }
        }

        void addEntry(ListEntry entry) {
            entry.entriesList = this;
            this.entries.add(entry);
            this.controlX = Math.min(this.controlX, this.func_148137_d() - entry.getControlSetWidth() - 2);
        }

        public GuiListExtended.IGuiListEntry func_148180_b(int i) {
            return this.entries.get(i);
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        int getLabelX() {
            return this.field_148152_e + 2;
        }

        int getControlX() {
            return this.controlX;
        }

        public int func_148139_c() {
            return this.field_148155_a;
        }

        protected int func_148137_d() {
            return this.field_148152_e + this.func_148139_c() - 6;
        }

        public void handleDrag(int mouseX, int mouseY, float partialTicks) {
            int entriesSize = this.entries.size();
            for (int i = 0; i < entriesSize; ++i) {
                ListEntry entry = this.entries.get(i);
                if (!entry.handleDrag(i, mouseX, mouseY, partialTicks)) continue;
                return;
            }
        }

        public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
            for (ListEntry entry : this.entries) {
                entry.drawToolTip(mouseX, mouseY);
            }
        }

        public boolean areContentEqual(Object[] vals) {
            if (vals.length != this.entries.size()) {
                return false;
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                ListEntry entry = this.entries.get(i);
                if (entry.name.equals(vals[i])) continue;
                return false;
            }
            return true;
        }
    }

    class ListEntry
    implements GuiListExtended.IGuiListEntry {
        private EntriesList entriesList;
        private final HoverChecker hoverCheckerText = new HoverChecker(0, 0, 0, 0, 0);
        final String name;
        final String localizedName;
        private final String tooltip;
        public boolean modified = false;
        private final GuiButtonExt btnDrag = new GuiButtonDrag(1, 0, 0, 20, 20);
        private final HoverChecker hoverCheckerBtnDrag = new HoverChecker((GuiButton)this.btnDrag, 800);
        private boolean isDragging = false;
        private long lastScroll = 0L;

        ListEntry(String name) {
            this.name = name;
            String nameKey = "structurelib.sortedregistry." + GuiEditRegistryConfig.this.registryName + "." + name;
            this.localizedName = GuiEditRegistryConfig.trans(nameKey, name);
            String tooltipKey = nameKey + ".tooltip";
            String tooltip = GuiEditRegistryConfig.trans(tooltipKey, null);
            StringBuilder tooltipBuilder = new StringBuilder();
            tooltipBuilder.append(EnumChatFormatting.GREEN);
            tooltipBuilder.append(this.localizedName);
            if (tooltip != null) {
                tooltipBuilder.append('\n').append(EnumChatFormatting.YELLOW).append(tooltip);
            }
            tooltipBuilder.append('\n');
            tooltipBuilder.append(EnumChatFormatting.DARK_GRAY);
            tooltipBuilder.append(this.name);
            this.tooltip = tooltipBuilder.toString();
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            this.drawOutlineBox(x, y, listWidth, slotHeight, tessellator);
            this.drawLabel(y, slotHeight);
            this.drawControlSet(y, slotHeight, mouseX, mouseY);
        }

        private void drawOutlineBox(int x, int y, int listWidth, int slotHeight, Tessellator tessellator) {
            if (this.isDragging) {
                int lx = x;
                int rx = this.entriesList.func_148137_d() - 4;
                int ty = y;
                int by = y + slotHeight;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78378_d(0x808080);
                tessellator.func_78374_a((double)(lx - 4), (double)(by + 4), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)(rx + 4), (double)(by + 4), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)(rx + 4), (double)(ty - 4), 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)(lx - 4), (double)(ty - 4), 0.0, 0.0, 0.0);
                tessellator.func_78378_d(0x202020);
                tessellator.func_78374_a((double)(lx - 2), (double)(by + 2), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)(rx + 2), (double)(by + 2), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)(rx + 2), (double)(ty - 2), 0.0, 1.0, 0.0);
                tessellator.func_78374_a((double)(lx - 2), (double)(ty - 2), 0.0, 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
            }
        }

        private void drawControlSet(int y, int slotHeight, int mouseX, int mouseY) {
            this.btnDrag.field_146128_h = this.entriesList.getControlX();
            this.btnDrag.field_146129_i = y + (slotHeight - this.btnDrag.field_146121_g) / 2;
            this.btnDrag.func_146112_a(GuiEditRegistryConfig.this.field_146297_k, mouseX, mouseY);
        }

        private void drawLabel(int y, int slotHeight) {
            String label = this.modified ? EnumChatFormatting.ITALIC + this.localizedName : this.localizedName;
            int allowedWidth = this.entriesList.getControlX() - this.entriesList.getLabelX() - 4;
            String toDraw = GuiEditRegistryConfig.this.trimStringToWidth(label, allowedWidth);
            this.hoverCheckerText.updateBounds(y + slotHeight / 2 - GuiEditRegistryConfig.this.field_146297_k.field_71466_p.field_78288_b / 2, y + slotHeight / 2 + GuiEditRegistryConfig.this.field_146297_k.field_71466_p.field_78288_b / 2, this.entriesList.getLabelX(), this.entriesList.getLabelX() + GuiEditRegistryConfig.this.field_146297_k.field_71466_p.func_78256_a(toDraw));
            GuiEditRegistryConfig.this.field_146297_k.field_71466_p.func_78276_b(toDraw, this.entriesList.getLabelX(), y + slotHeight / 2 - GuiEditRegistryConfig.this.field_146297_k.field_71466_p.field_78288_b / 2, this.getLabelColor());
        }

        void drawToolTip(int mouseX, int mouseY) {
            if (this.hoverCheckerText.checkHover(mouseX, mouseY)) {
                GuiEditRegistryConfig.this.drawToolTip(GuiEditRegistryConfig.this.field_146297_k.field_71466_p.func_78271_c(this.tooltip, this.entriesList.func_148139_c()), mouseX, mouseY);
            }
            if (this.hoverCheckerBtnDrag.checkHover(mouseX, mouseY) && !this.isDragging) {
                GuiEditRegistryConfig.this.drawToolTip(GuiEditRegistryConfig.this.field_146297_k.field_71466_p.func_78271_c(I18n.func_135052_a((String)"structurelib.configgui.drag.tooltip", (Object[])new Object[0]), this.entriesList.func_148139_c()), mouseX, mouseY);
            }
        }

        protected int getLabelColor() {
            return this.isDragging ? 0x888888 : 0xFFFFFF;
        }

        int getControlSetWidth() {
            return this.btnDrag.func_146117_b();
        }

        public boolean handleDrag(int index, int mouseX, int mouseY, float partialTicks) {
            int l;
            if (!this.isDragging) {
                return false;
            }
            for (EntriesList list : GuiEditRegistryConfig.this.lists) {
                if (list == this.entriesList || mouseX <= list.field_148152_e || mouseX >= list.field_148151_d || mouseY <= list.field_148153_b || mouseY >= list.field_148154_c) continue;
                int l2 = list.entries.isEmpty() ? 0 : list.func_148124_c(mouseX, mouseY);
                if (l2 < 0) {
                    l2 = mouseY < (list.field_148154_c + list.field_148153_b) / 2 ? 0 : list.entries.size();
                }
                this.entriesList.func_148143_b(true);
                this.entriesList.entries.remove(index);
                list.func_148143_b(false);
                list.entries.add(l2, this);
                this.entriesList = list;
                return true;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastScroll > 20L) {
                if (mouseY < this.entriesList.field_148153_b) {
                    this.entriesList.func_148145_f(-3);
                    this.lastScroll = now;
                } else if (mouseY > this.entriesList.field_148154_c) {
                    this.entriesList.func_148145_f(3);
                    this.lastScroll = now;
                }
            }
            if ((l = this.entriesList.func_148124_c(MathHelper.func_76125_a((int)mouseX, (int)this.entriesList.field_148152_e, (int)this.entriesList.field_148151_d), MathHelper.func_76125_a((int)mouseY, (int)this.entriesList.field_148153_b, (int)this.entriesList.field_148154_c))) < 0 || l == index) {
                return true;
            }
            this.entriesList.entries.remove(index);
            this.entriesList.entries.add(l, this);
            return true;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.isDragging = false;
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnDrag.func_146116_c(GuiEditRegistryConfig.this.field_146297_k, x, y)) {
                this.isDragging = true;
                return true;
            }
            return false;
        }
    }

    private static class GuiButtonDrag
    extends GuiButtonExt {
        public GuiButtonDrag(int id, int xPos, int yPos, int width, int height) {
            super(id, xPos, yPos, width, height, null);
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int k = this.func_146114_a(this.field_146123_n);
                GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)(46 + k * 20), (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
                mc.field_71446_o.func_110577_a(new ResourceLocation("structurelib", "textures/gui/fourwayarrow2.png"));
                int x = this.field_146128_h + (this.field_146120_f - 12) / 2;
                int y = this.field_146129_i + (this.field_146121_g - 12) / 2;
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)x, (double)(y + 12), (double)this.field_73735_i, 0.0, 1.0);
                tessellator.func_78374_a((double)(x + 12), (double)(y + 12), (double)this.field_73735_i, 1.0, 1.0);
                tessellator.func_78374_a((double)(x + 12), (double)y, (double)this.field_73735_i, 1.0, 0.0);
                tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, 0.0, 0.0);
                tessellator.func_78381_a();
            }
        }
    }
}

