/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.opengl;

import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.sdl.SDLVideo;
import org.lwjglx.PointerBuffer;
import org.lwjglx.Sys;
import org.lwjglx.opengl.Context;
import org.lwjglx.opengl.Display;

public final class ContextGL
implements Context {
    public long sdlWindow = 0L;
    public long sdlContext = 0L;
    public final boolean shared;
    GLCapabilities glCaps = null;

    public ContextGL(long sdlWindow, long sdlContext, boolean shared) {
        this.sdlWindow = sdlWindow;
        this.sdlContext = sdlContext;
        this.shared = shared;
    }

    @Override
    public void releaseCurrent() {
        Display.glContextMutex.lock();
        try {
            GL.setCapabilities(null);
            SDLVideo.SDL_GL_MakeCurrent((long)this.sdlWindow, (long)0L);
        }
        finally {
            Display.glContextMutex.unlock();
        }
    }

    @Override
    public synchronized void releaseDrawable() {
    }

    public synchronized void update() {
    }

    public static void swapBuffers() {
        Display.swapBuffers();
    }

    @Override
    public synchronized void makeCurrent() {
        Display.glContextMutex.lock();
        try {
            Sys.checkSdl(SDLVideo.SDL_GL_MakeCurrent((long)this.sdlWindow, (long)this.sdlContext));
            if (this.glCaps == null) {
                this.glCaps = GL.createCapabilities();
            } else {
                GL.setCapabilities((GLCapabilities)this.glCaps);
            }
        }
        finally {
            Display.glContextMutex.unlock();
        }
    }

    @Override
    public synchronized boolean isCurrent() {
        return SDLVideo.SDL_GL_GetCurrentContext() == this.sdlContext;
    }

    public static void setSwapInterval(int value) {
        Display.setSwapInterval(value);
    }

    public synchronized void forceDestroy() {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.shared && this.sdlWindow != 0L) {
            if (this.sdlContext != 0L) {
                SDLVideo.SDL_GL_DestroyContext((long)this.sdlContext);
                this.sdlContext = 0L;
            }
            SDLVideo.SDL_DestroyWindow((long)this.sdlWindow);
            this.sdlWindow = 0L;
        }
    }

    public synchronized void setCLSharingProperties(PointerBuffer properties) {
    }
}

