/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx.input;

import java.nio.IntBuffer;
import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import net.minecraft.util.MathHelper;
import org.lwjgl.sdl.SDLMouse;
import org.lwjgl.sdl.SDLPixels;
import org.lwjgl.sdl.SDLSurface;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.system.MemoryStack;
import org.lwjglx.Sys;
import org.lwjglx.input.Mouse;

public class Cursor {
    public static final int CURSOR_ONE_BIT_TRANSPARENCY = 1;
    public static final int CURSOR_8_BIT_ALPHA = 2;
    public static final int CURSOR_ANIMATION = 4;
    private final CursorElement[] cursors = null;
    private int index;
    private boolean destroyed;
    private long sdlCursor;
    private SDL_Surface sdlSurface;

    public Cursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) {
        int pixels = width * height;
        if (numImages < 1) {
            throw new IllegalArgumentException("There must be at least 1 cursor image");
        }
        if (images.remaining() < pixels) {
            throw new IllegalArgumentException("Not enough pixels in the cursor image");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.sdlSurface = Sys.checkSdl(SDLSurface.SDL_CreateSurface((int)width, (int)height, (int)SDLPixels.SDL_PIXELFORMAT_BGRA32));
            Sys.checkSdl(SDLSurface.SDL_LockSurface((SDL_Surface)this.sdlSurface));
            IntBuffer targetInts = this.sdlSurface.pixels().asIntBuffer();
            for (int i = 0; i < pixels; ++i) {
                targetInts.put(i, images.get(i));
            }
            SDLSurface.SDL_UnlockSurface((SDL_Surface)this.sdlSurface);
            SDLSurface.SDL_FlipSurface((SDL_Surface)this.sdlSurface, (int)2);
            this.sdlCursor = Sys.checkSdl(SDLMouse.SDL_CreateColorCursor((SDL_Surface)this.sdlSurface, (int)MathHelper.func_76125_a((int)xHotspot, (int)0, (int)(width - 1)), (int)MathHelper.func_76125_a((int)(height - 1 - yHotspot), (int)0, (int)(height - 1))));
        }
    }

    public static int getMinCursorSize() {
        return 8;
    }

    public static int getMaxCursorSize() {
        return 64;
    }

    public static int getCapabilities() {
        return 3;
    }

    Object getHandle() {
        this.checkValid();
        return this.cursors[this.index].cursorHandle;
    }

    private void checkValid() {
        if (this.destroyed) {
            throw new IllegalStateException("The cursor is destroyed");
        }
    }

    public void destroy() {
        if (Mouse.getNativeCursor() == this) {
            Mouse.setNativeCursor(null);
        }
        if (this.sdlCursor != 0L) {
            SDLMouse.SDL_DestroyCursor((long)this.sdlCursor);
            this.sdlCursor = 0L;
        }
        if (this.sdlSurface != null) {
            SDLSurface.SDL_DestroySurface((SDL_Surface)this.sdlSurface);
            this.sdlSurface = null;
        }
    }

    protected void setTimeout() {
        this.checkValid();
        this.cursors[this.index].timeout = System.currentTimeMillis() + this.cursors[this.index].delay;
    }

    protected boolean hasTimedOut() {
        this.checkValid();
        return this.cursors.length > 1 && this.cursors[this.index].timeout < System.currentTimeMillis();
    }

    protected void nextCursor() {
        this.checkValid();
        ++this.index;
        this.index %= this.cursors.length;
    }

    void sdlSet() {
        if (this.sdlCursor == 0L) {
            return;
        }
        MainThreadExec.runOnMainThread(() -> SDLMouse.SDL_SetCursor((long)this.sdlCursor));
    }

    private static class CursorElement {
        final Object cursorHandle;
        final long delay;
        long timeout;

        CursorElement(Object cursorHandle, long delay, long timeout) {
            this.cursorHandle = cursorHandle;
            this.delay = delay;
            this.timeout = timeout;
        }
    }
}

