/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.common.gui.controls.GuiFocusControl;
import com.creativemd.creativecore.common.gui.event.ControlChangedEvent;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ChatAllowedCharacters;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

public class GuiTextfield
extends GuiFocusControl {
    public static FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    public String text = "";
    public int cursorPosition;
    private int scrollOffset = 0;
    public int maxLength = 32;
    public int selEnd = 0;
    public char[] allowedChars;
    private int cursorCounter;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;

    public GuiTextfield(String name, String text, int x, int y, int width, int height) {
        this(name, text, x, y, width, height, 0);
    }

    public GuiTextfield(String name, String text, int x, int y, int width, int height, int rotation) {
        super(name, x, y, width, height, rotation);
        this.text = text;
    }

    public GuiTextfield setFloatOnly() {
        this.allowedChars = new char[]{'-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'};
        return this;
    }

    public GuiTextfield setNumbersOnly() {
        this.allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return this;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public boolean hasSelectedText() {
        return this.selEnd != -1 && this.selEnd != this.cursorPosition;
    }

    public String getSelectedText() {
        if (this.hasSelectedText() && this.text != null) {
            return this.text.substring(Math.min(this.cursorPosition, this.selEnd), Math.max(this.cursorPosition, this.selEnd));
        }
        return "";
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        boolean wasFocused = this.focused;
        super.mousePressed(posX, posY, button);
        if (this.focused && !wasFocused) {
            this.cursorCounter = 0;
        }
        int l = posX - (this.posX - this.width / 2);
        String s = fontRenderer.func_78269_a(this.text.substring(this.scrollOffset), this.getWidth());
        this.setCursorPosition(fontRenderer.func_78269_a(s, l).length() + this.scrollOffset);
        return true;
    }

    public void writeText(String text) {
        int l;
        int i;
        String s1 = "";
        String s2 = ChatAllowedCharacters.func_71565_a((String)text);
        String s3 = "";
        char[] chars = s2.toCharArray();
        if (this.allowedChars != null) {
            for (i = 0; i < chars.length; ++i) {
                if (!ArrayUtils.contains((char[])this.allowedChars, (char)chars[i])) continue;
                s3 = s3 + chars[i];
            }
            s2 = s3;
        }
        i = this.cursorPosition < this.selEnd ? this.cursorPosition : this.selEnd;
        int j = this.cursorPosition < this.selEnd ? this.selEnd : this.cursorPosition;
        int k = this.maxLength - this.text.length() - (i - this.selEnd);
        boolean flag = false;
        if (this.text.length() > 0) {
            s1 = s1 + this.text.substring(0, i);
        }
        if (k < s2.length()) {
            s1 = s1 + s2.substring(0, k);
            l = k;
        } else {
            s1 = s1 + s2;
            l = s2.length();
        }
        if (this.text.length() > 0 && j < this.text.length()) {
            s1 = s1 + this.text.substring(j);
        }
        this.text = s1;
        this.moveCursorBy(i - this.selEnd + l);
        this.raiseEvent(new ControlChangedEvent(this));
    }

    public void moveCursorBy(int offset) {
        this.setCursorPosition(this.selEnd + offset);
    }

    public int getNthWordFromCursor(int pos) {
        return this.getNthWordFromPos(pos, this.cursorPosition);
    }

    public int getNthWordFromPos(int pos, int cursorPos) {
        return this.func_146197_a(pos, this.cursorPosition, true);
    }

    public int func_146197_a(int p_146197_1_, int p_146197_2_, boolean p_146197_3_) {
        int k = p_146197_2_;
        boolean flag1 = p_146197_1_ < 0;
        int l = Math.abs(p_146197_1_);
        for (int i1 = 0; i1 < l; ++i1) {
            if (flag1) {
                while (p_146197_3_ && k > 0 && this.text.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.text.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int j1 = this.text.length();
            if ((k = this.text.indexOf(32, k)) == -1) {
                k = j1;
                continue;
            }
            while (p_146197_3_ && k < j1 && this.text.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void deleteWords(int pos) {
        if (this.text.length() != 0) {
            if (this.selEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(pos) - this.cursorPosition);
            }
        }
        this.raiseEvent(new ControlChangedEvent(this));
    }

    @Override
    public ArrayList<String> getTooltip() {
        ArrayList<String> strings = new ArrayList<String>();
        return strings;
    }

    public void deleteFromCursor(int pos) {
        if (this.text.length() != 0) {
            if (this.selEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                boolean flag = pos < 0;
                int j = flag ? this.cursorPosition + pos : this.cursorPosition;
                int k = flag ? this.cursorPosition : this.cursorPosition + pos;
                String s = "";
                if (j >= 0) {
                    s = this.text.substring(0, j);
                }
                if (k < this.text.length()) {
                    s = s + this.text.substring(k);
                }
                this.text = s;
                if (flag) {
                    this.moveCursorBy(pos);
                }
            }
        }
        this.raiseEvent(new ControlChangedEvent(this));
    }

    public int getWidth() {
        return this.width - 8;
    }

    public void setSelectionPos(int p_146199_1_) {
        int j = this.text.length();
        if (p_146199_1_ > j) {
            p_146199_1_ = j;
        }
        if (p_146199_1_ < 0) {
            p_146199_1_ = 0;
        }
        this.selEnd = p_146199_1_;
        if (fontRenderer != null) {
            if (this.scrollOffset > j) {
                this.scrollOffset = j;
            }
            int k = this.getWidth();
            String s = fontRenderer.func_78269_a(this.text.substring(this.scrollOffset), k);
            int l = s.length() + this.scrollOffset;
            if (p_146199_1_ == this.scrollOffset) {
                this.scrollOffset -= fontRenderer.func_78262_a(this.text, k, true).length();
            }
            if (p_146199_1_ > l) {
                this.scrollOffset += p_146199_1_ - l;
            } else if (p_146199_1_ <= this.scrollOffset) {
                this.scrollOffset -= this.scrollOffset - p_146199_1_;
            }
            if (this.scrollOffset < 0) {
                this.scrollOffset = 0;
            }
            if (this.scrollOffset > j) {
                this.scrollOffset = j;
            }
        }
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        int j = this.text.length();
        if (this.cursorPosition < 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition > j) {
            this.cursorPosition = j;
        }
        this.setSelectionPos(this.cursorPosition);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        if (!this.focused) {
            return false;
        }
        switch (character) {
            case '\u0001': {
                this.setCursorPositionEnd();
                this.setSelectionPos(0);
                return true;
            }
            case '\u0003': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                return true;
            }
            case '\u0016': {
                if (this.enabled) {
                    this.writeText(GuiScreen.func_146277_j());
                }
                return true;
            }
            case '\u0018': {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                if (this.enabled) {
                    this.writeText("");
                }
                return true;
            }
        }
        switch (key) {
            case 14: {
                if (GuiScreen.func_146271_m()) {
                    if (this.enabled) {
                        this.deleteWords(-1);
                    }
                } else if (this.enabled) {
                    this.deleteFromCursor(-1);
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(0);
                } else {
                    this.setCursorPositionZero();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(-1, this.selEnd));
                    } else {
                        this.setSelectionPos(this.selEnd - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPos(this.getNthWordFromPos(1, this.selEnd));
                    } else {
                        this.setSelectionPos(this.selEnd + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPos(this.text.length());
                } else {
                    this.setCursorPositionEnd();
                }
                return true;
            }
            case 211: {
                if (GuiScreen.func_146271_m()) {
                    if (this.enabled) {
                        this.deleteWords(1);
                    }
                } else if (this.enabled) {
                    this.deleteFromCursor(1);
                }
                return true;
            }
        }
        if (ChatAllowedCharacters.func_71566_a((char)character)) {
            if (this.enabled) {
                this.writeText(Character.toString(character));
            }
            return true;
        }
        return false;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void onTextChange() {
    }

    @Override
    public void drawControl(FontRenderer renderer) {
        Gui.func_73734_a((int)-1, (int)-1, (int)(0 + this.width + 1), (int)(0 + this.height + 1), (int)-6250336);
        Gui.func_73734_a((int)0, (int)0, (int)(0 + this.width), (int)(0 + this.height), (int)-16777216);
        int i = this.enabled ? this.enabledColor : this.disabledColor;
        int j = this.cursorPosition - this.scrollOffset;
        int k = this.selEnd - this.scrollOffset;
        String s = fontRenderer.func_78269_a(this.text.substring(this.scrollOffset), this.getWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.focused && this.cursorCounter / 6 % 2 == 0 && flag;
        boolean enableBackgroundDrawing = true;
        int l = enableBackgroundDrawing ? 4 : 0;
        int i1 = enableBackgroundDrawing ? (this.height - 8) / 2 : 0;
        int j1 = l;
        if (k > s.length()) {
            k = s.length();
        }
        if (s.length() > 0) {
            String s1 = flag ? s.substring(0, j) : s;
            j1 = fontRenderer.func_78261_a(s1, l, i1, i);
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.maxLength;
        int k1 = j1;
        if (!flag) {
            k1 = j > 0 ? l + this.width : l;
        } else if (flag2) {
            k1 = j1 - 1;
            --j1;
        }
        if (s.length() > 0 && flag && j < s.length()) {
            fontRenderer.func_78261_a(s.substring(j), j1, i1, i);
        }
        if (flag1) {
            if (flag2) {
                Gui.func_73734_a((int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + GuiTextfield.fontRenderer.field_78288_b), (int)-3092272);
            } else {
                fontRenderer.func_78261_a("_", k1, i1, i);
            }
        }
        if (k != j) {
            int l1 = l + fontRenderer.func_78256_a(s.substring(0, k));
            this.drawCursorVertical(k1, i1 - 1, l1 - 1, i1 + 1 + GuiTextfield.fontRenderer.field_78288_b);
        }
    }

    public void drawCursorVertical(int p_146188_1_, int p_146188_2_, int p_146188_3_, int p_146188_4_) {
        int i1;
        if (p_146188_1_ < p_146188_3_) {
            i1 = p_146188_1_;
            p_146188_1_ = p_146188_3_;
            p_146188_3_ = i1;
        }
        if (p_146188_2_ < p_146188_4_) {
            i1 = p_146188_2_;
            p_146188_2_ = p_146188_4_;
            p_146188_4_ = i1;
        }
        if (p_146188_3_ > this.posX + this.width) {
            p_146188_3_ = this.posX + this.width;
        }
        if (p_146188_1_ > this.posX + this.width) {
            p_146188_1_ = this.posX + this.width;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)p_146188_1_, (double)p_146188_4_, 0.0);
        tessellator.func_78377_a((double)p_146188_3_, (double)p_146188_4_, 0.0);
        tessellator.func_78377_a((double)p_146188_3_, (double)p_146188_2_, 0.0);
        tessellator.func_78377_a((double)p_146188_1_, (double)p_146188_2_, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }
}

