/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.webmap;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.webmap.routes.Data;
import journeymap.client.webmap.routes.Logs;
import journeymap.client.webmap.routes.Polygons;
import journeymap.client.webmap.routes.Properties;
import journeymap.client.webmap.routes.Resource;
import journeymap.client.webmap.routes.Skin;
import journeymap.client.webmap.routes.Status;
import journeymap.client.webmap.routes.Tiles;
import journeymap.common.Journeymap;
import journeymap.shadow.io.javalin.Javalin;
import journeymap.shadow.io.javalin.http.staticfiles.Location;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class WebMap {
    public static final Logger logger = Journeymap.getLogger();
    private int port = 0;
    private boolean started = false;
    private Javalin app;
    private static WebMap instance;

    public static WebMap getInstance() {
        if (instance == null) {
            instance = new WebMap();
        }
        return instance;
    }

    public void start() {
        if (!this.started) {
            this.findPort(true);
            this.initialise();
            this.started = true;
            logger.info("Webmap is now listening on port: {}.", new Object[]{this.port});
        }
    }

    private void initialise() {
        try {
            this.app = Javalin.create(config -> {
                String assetsRootProperty = System.getProperty("journeymap.webmap.assets_root", null);
                File testFile = new File("../src/main/resources/assets/journeymap/web");
                if (assetsRootProperty != null) {
                    logger.info("Detected 'journeymap.webmap.assets_root' property, serving static files from: {}", new Object[]{assetsRootProperty});
                    config.addStaticFiles(assetsRootProperty, Location.EXTERNAL);
                    if (testFile.exists()) {
                        try {
                            String assets = testFile.getCanonicalPath();
                            logger.info("Development environment detected, serving static files from the filesystem.: {}", new Object[]{assets});
                            config.addStaticFiles(testFile.getCanonicalPath(), Location.EXTERNAL);
                        }
                        catch (IOException e) {
                            logger.error("Webmap error finding local assets path", (Throwable)e);
                        }
                    }
                } else {
                    File dir = new File(FileHandler.getMinecraftDirectory(), Constants.WEB_DIR);
                    if (!dir.exists()) {
                        ResourceLocation location = new ResourceLocation("journeymap", "web");
                        String assetPath = String.format("/assets/%s/%s", location.func_110624_b(), location.func_110623_a());
                        logger.info("Attempting to copy web content to {}", new Object[]{dir});
                        boolean created = FileHandler.copyResources(dir, assetPath, "", false);
                        logger.info("Web content copied successfully: {}", new Object[]{created});
                    }
                    if (dir.exists()) {
                        logger.info("Loading web content from local: {}", new Object[]{dir.getPath()});
                        config.addStaticFiles(dir.getPath(), Location.EXTERNAL);
                    } else {
                        logger.info("Loading web content from jar: {}", new Object[]{"/assets/journeymap/web"});
                        config.addStaticFiles("/assets/journeymap/web", Location.CLASSPATH);
                    }
                }
            }).before(ctx -> {
                ctx.header("Access-Control-Allow-Origin", "*");
                ctx.header("Cache-Control", "no-cache");
            }).get("/data/{type}", Data::get).get("/logs", Logs::get).get("/properties", Properties::get).get("/resources", Resource::get).get("/skin/{uuid}", Skin::get).get("/status", Status::get).get("/tiles/tile.png", Tiles::get).get("/polygons", Polygons::get).post("/properties", Properties::post).start();
        }
        catch (Exception e) {
            logger.error("Failed to start server:", (Throwable)e);
            this.stop();
        }
    }

    public void stop() {
        if (this.started) {
            this.app.stop();
            this.started = false;
            logger.info("Webmap stopped.");
        }
    }

    private void findPort(boolean tryCurrentPort) {
        if (this.port == 0) {
            if (JourneymapClient.getInstance() == null || JourneymapClient.getWebMapProperties() == null) {
                this.port = 8080;
            } else {
                this.port = JourneymapClient.getWebMapProperties().port.get();
                logger.info("port found, set to {}", new Object[]{this.port});
            }
        }
        if (tryCurrentPort) {
            try {
                ServerSocket socket = new ServerSocket(this.port);
                this.port = socket.getLocalPort();
                socket.close();
            }
            catch (IOException e) {
                logger.warn("Configured port {} could not be bound: ", new Object[]{this.port, e});
                this.findPort(false);
            }
            logger.info("Configured port {} is available.", new Object[]{this.port});
        } else {
            try {
                ServerSocket socket = new ServerSocket(0);
                this.port = socket.getLocalPort();
                socket.close();
                logger.info("New port {} assigned by ServerSocket.", new Object[]{this.port});
            }
            catch (IOException e) {
                logger.error("Configured port {} could not be bound on second attempt, failing: ", new Object[]{this.port, e});
                this.stop();
            }
        }
    }

    public int getPort() {
        return this.port;
    }
}

