/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft.shutup;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.mitchej123.hodgepodge.config.FixesConfig;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FMLClientHandler.class}, remap=false)
public class MixinFMLClientHandler {
    @Shadow
    private SetMultimap<String, ResourceLocation> missingTextures;
    @Shadow
    private Set<String> badTextureDomains;
    @Shadow
    private Table<String, String, Set<ResourceLocation>> brokenTextures;

    @Inject(method={"logMissingTextureErrors"}, at={@At(value="HEAD")}, cancellable=true)
    private void shutup(CallbackInfo ci) {
        ci.cancel();
        if (this.missingTextures.isEmpty() && this.brokenTextures.isEmpty()) {
            return;
        }
        int missingCount = 0;
        int brokenCount = 0;
        for (String resourceDomain : this.missingTextures.keySet()) {
            missingCount += this.missingTextures.get((Object)resourceDomain).size();
            if (!this.brokenTextures.containsRow((Object)resourceDomain)) continue;
            Map resourceErrs = this.brokenTextures.row((Object)resourceDomain);
            for (String error : resourceErrs.keySet()) {
                brokenCount += ((Set)resourceErrs.get(error)).size();
            }
        }
        Logger logger = LogManager.getLogger((String)"TEXTURE ERRORS");
        logger.error(Strings.repeat((String)"+=", (int)25));
        logger.error("{} missing textures and {} broken textures were found. Change TweaksConfig.hideTextureErrors in the Hodgepodge config for more info.", new Object[]{missingCount, brokenCount});
        logger.error(Strings.repeat((String)"+=", (int)25));
        if (FixesConfig.enableMemoryFixes) {
            this.missingTextures = HashMultimap.create();
            this.badTextureDomains = Sets.newHashSet();
            this.brokenTextures = HashBasedTable.create();
        }
    }
}

