/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft.fastload;

import com.mitchej123.hodgepodge.config.SpeedupsConfig;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S26PacketMapChunkBulk;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkWatchEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayerMP.class})
public abstract class MixinEntityPlayerMP
extends EntityPlayer {
    @Shadow
    @Final
    public List<ChunkCoordIntPair> field_71129_f;
    @Shadow
    public NetHandlerPlayServer field_71135_a;
    @Unique
    private final ObjectArrayList<ObjectImmutableList<Chunk>> hodgepodge$chunkSends = new ObjectArrayList();
    @Unique
    private final ObjectArrayList<Chunk> hodgepodge$rollingChunks = new ObjectArrayList();
    @Unique
    private final ObjectArrayList<TileEntity> hodgepodge$rollingTEs = new ObjectArrayList();

    @Shadow
    protected abstract void func_147097_b(TileEntity var1);

    @Shadow
    public abstract WorldServer func_71121_q();

    public MixinEntityPlayerMP(World world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(method={"onUpdate", "localOnUpdate"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/EntityPlayerMP;loadedChunks:Ljava/util/List;", shift=At.Shift.BEFORE, ordinal=0)}, cancellable=true)
    private void hodgepodge$replaceChunkSending(CallbackInfo ci) {
        if (this.field_71129_f.isEmpty()) {
            ci.cancel();
            return;
        }
        int numChunks = 0;
        Iterator<ChunkCoordIntPair> allChunks = this.field_71129_f.iterator();
        int chunksPerPacket = S26PacketMapChunkBulk.func_149258_c();
        while (allChunks.hasNext() && numChunks < SpeedupsConfig.maxSendSpeed) {
            Chunk chunk;
            ChunkCoordIntPair ccip = allChunks.next();
            if (ccip == null) {
                allChunks.remove();
                continue;
            }
            if (!this.field_70170_p.func_72899_e(ccip.field_77276_a << 4, 0, ccip.field_77275_b << 4) || !(chunk = this.field_70170_p.func_72964_e(ccip.field_77276_a, ccip.field_77275_b)).func_150802_k()) continue;
            if (this.hodgepodge$rollingChunks.size() == chunksPerPacket) {
                this.hodgepodge$chunkSends.add((Object)new ObjectImmutableList(this.hodgepodge$rollingChunks));
                this.hodgepodge$rollingChunks.clear();
            }
            this.hodgepodge$rollingChunks.add((Object)chunk);
            this.hodgepodge$rollingTEs.addAll((Collection)((WorldServer)this.field_70170_p).func_147486_a(ccip.field_77276_a * 16, 0, ccip.field_77275_b * 16, ccip.field_77276_a * 16 + 15, 256, ccip.field_77275_b * 16 + 15));
            allChunks.remove();
            ++numChunks;
        }
        this.hodgepodge$chunkSends.add((Object)new ObjectImmutableList(this.hodgepodge$rollingChunks));
        if (numChunks > 0) {
            for (int i = 0; i < this.hodgepodge$chunkSends.size(); ++i) {
                this.field_71135_a.func_147359_a((Packet)new S26PacketMapChunkBulk((List)this.hodgepodge$chunkSends.get(i)));
            }
            for (TileEntity tileentity : this.hodgepodge$rollingTEs) {
                this.func_147097_b(tileentity);
            }
            for (int i = 0; i < numChunks; ++i) {
                int div = i / chunksPerPacket;
                int rem = i % chunksPerPacket;
                Chunk chunk = (Chunk)((ObjectImmutableList)this.hodgepodge$chunkSends.get(div)).get(rem);
                this.func_71121_q().func_73039_n().func_85172_a((EntityPlayerMP)this, chunk);
                MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.Watch(chunk.func_76632_l(), (EntityPlayerMP)this));
            }
        }
        this.hodgepodge$chunkSends.clear();
        this.hodgepodge$rollingChunks.clear();
        this.hodgepodge$rollingTEs.clear();
        ci.cancel();
    }
}

