/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.rfb.transformers;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.mitchej123.hodgepodge.core.shared.EarlyConfig;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ForgeConfigurationTransformer
implements RfbClassTransformer,
Opcodes {
    private static final String HOOK_CLASS_INTERNAL = "com/mitchej123/hodgepodge/core/rfb/hooks/ForgeConfigurationHook";
    private static final String PROPERTY_INTERNAL = "net/minecraftforge/common/config/Property";
    private static final String OPEN_MAP_INTERNAL = "it/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap";

    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "forge-configuration";
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        return classNode.isPresent() && (className.equals("net.minecraftforge.common.config.Property") || className.equals("net.minecraftforge.common.config.ConfigCategory"));
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return;
        }
        if (className.equals("net.minecraftforge.common.config.Property")) {
            ForgeConfigurationTransformer.transformProperty(cn);
        } else if (className.equals("net.minecraftforge.common.config.ConfigCategory")) {
            ForgeConfigurationTransformer.transformConfigCategory(cn);
        }
        if (EarlyConfig.dumpASMClass) {
            HodgepodgeClassDump.dumpRFBClass(className, classNode, this);
        }
    }

    private static void transformProperty(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            for (int i = 0; i < mn.instructions.size(); ++i) {
                AbstractInsnNode nextNode;
                AbstractInsnNode aInsn = mn.instructions.get(i);
                if (aInsn.getOpcode() == 184 && aInsn instanceof MethodInsnNode) {
                    MethodInsnNode mInsn = (MethodInsnNode)aInsn;
                    if (ForgeConfigurationTransformer.isString$valueOfI(mInsn) || ForgeConfigurationTransformer.isInteger$toString(mInsn)) {
                        mInsn.owner = HOOK_CLASS_INTERNAL;
                        mInsn.name = "intToCachedString";
                        continue;
                    }
                    if (!ForgeConfigurationTransformer.isString$valueOfD(mInsn) && !ForgeConfigurationTransformer.isDouble$toString(mInsn)) continue;
                    mInsn.owner = HOOK_CLASS_INTERNAL;
                    mInsn.name = "doubleToCachedString";
                    continue;
                }
                if (aInsn.getOpcode() == 181 && aInsn instanceof FieldInsnNode) {
                    FieldInsnNode fInsn = (FieldInsnNode)aInsn;
                    if (PROPERTY_INTERNAL.equals(fInsn.owner)) {
                        if ("Ljava/lang/String;".equals(fInsn.desc) && ("value".equals(fInsn.name) || "defaultValue".equals(fInsn.name))) {
                            mn.instructions.insertBefore((AbstractInsnNode)fInsn, (AbstractInsnNode)new MethodInsnNode(182, "java/lang/String", "intern", "()Ljava/lang/String;", false));
                            ++i;
                            continue;
                        }
                        if (!"[Ljava/lang/String;".equals(fInsn.desc) || !"values".equals(fInsn.name) && !"defaultValues".equals(fInsn.name) && !"validValues".equals(fInsn.name)) continue;
                        mn.instructions.insertBefore((AbstractInsnNode)fInsn, (AbstractInsnNode)new MethodInsnNode(184, HOOK_CLASS_INTERNAL, "internArray", "([Ljava/lang/String;)[Ljava/lang/String;", false));
                        ++i;
                        continue;
                    }
                }
                if (aInsn.getOpcode() != 3 || (nextNode = aInsn.getNext()).getOpcode() != 189 || !(nextNode instanceof TypeInsnNode)) continue;
                TypeInsnNode tInsn = (TypeInsnNode)nextNode;
                if (!"java/lang/String".equals(tInsn.desc)) continue;
                mn.instructions.insert(nextNode, (AbstractInsnNode)new MethodInsnNode(184, HOOK_CLASS_INTERNAL, "emptyStringArray", "()[Ljava/lang/String;", false));
                mn.instructions.remove(aInsn);
                mn.instructions.remove(nextNode);
                --i;
            }
        }
    }

    private static void transformConfigCategory(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            if ("<init>".equals(mn.name)) {
                for (AbstractInsnNode aInsn : mn.instructions.toArray()) {
                    MethodInsnNode mInsn;
                    AbstractInsnNode thirdNode;
                    AbstractInsnNode secondNode;
                    if (aInsn.getOpcode() != 187 || !(aInsn instanceof TypeInsnNode)) continue;
                    TypeInsnNode tInsn = (TypeInsnNode)aInsn;
                    if (!"java/util/TreeMap".equals(tInsn.desc) || (secondNode = aInsn.getNext()).getOpcode() != 89 || !((thirdNode = secondNode.getNext()) instanceof MethodInsnNode) || !ForgeConfigurationTransformer.isTreeMapInit(mInsn = (MethodInsnNode)thirdNode)) continue;
                    tInsn.desc = OPEN_MAP_INTERNAL;
                    mInsn.owner = OPEN_MAP_INTERNAL;
                }
                continue;
            }
            if (!"getOrderedValues".equals(mn.name)) continue;
            for (AbstractInsnNode aInsn : mn.instructions.toArray()) {
                if (aInsn.getOpcode() != 185 || !(aInsn instanceof MethodInsnNode)) continue;
                MethodInsnNode mInsn = (MethodInsnNode)aInsn;
                if (!"values".equals(mInsn.name) || !"()Ljava/util/Collection;".equals(mInsn.desc)) continue;
                mInsn.setOpcode(184);
                mInsn.owner = HOOK_CLASS_INTERNAL;
                mInsn.name = "keySortedMapValues";
                mInsn.desc = "(Ljava/util/Map;)Ljava/util/Collection;";
                mInsn.itf = false;
            }
        }
    }

    private static boolean isTreeMapInit(MethodInsnNode node) {
        return node.getOpcode() == 183 && node.owner.equals("java/util/TreeMap") && node.name.equals("<init>") && node.desc.equals("()V");
    }

    private static boolean isDouble$toString(MethodInsnNode mInsn) {
        return "java/lang/Double".equals(mInsn.owner) && "toString".equals(mInsn.name) && "(D)Ljava/lang/String;".equals(mInsn.desc);
    }

    private static boolean isString$valueOfD(MethodInsnNode mInsn) {
        return "java/lang/String".equals(mInsn.owner) && "valueOf".equals(mInsn.name) && "(D)Ljava/lang/String;".equals(mInsn.desc);
    }

    private static boolean isInteger$toString(MethodInsnNode mInsn) {
        return "java/lang/Integer".equals(mInsn.owner) && "toString".equals(mInsn.name) && "(I)Ljava/lang/String;".equals(mInsn.desc);
    }

    private static boolean isString$valueOfI(MethodInsnNode mInsn) {
        return "java/lang/String".equals(mInsn.owner) && "valueOf".equals(mInsn.name) && "(I)Ljava/lang/String;".equals(mInsn.desc);
    }
}

