/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.mc;

import com.mitchej123.hodgepodge.core.HodgepodgeCore;
import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class NBTTagCompoundHashMapTransformer
implements IClassTransformer,
Opcodes {
    private static final Logger LOGGER = LogManager.getLogger((String)"NBTTagCompoundHashMapTransformer");
    private static final String INIT = "<init>";
    private static final String EMPTY_DESC = "()V";
    private static final String HASHMAP = "java/util/HashMap";
    private static final String FASTUTIL_HASHMAP = "it/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap";
    private static String copy_name;
    private static String copy_desc;
    private static String nbtbase_name;
    private static String nbttagcompound_name;
    private static String tagMap_name;
    private static String setTag_name;
    private static String setTag_desc;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if ("net.minecraft.nbt.NBTTagCompound".equals(transformedName)) {
            NBTTagCompoundHashMapTransformer.initNames();
            byte[] transformedBytes = NBTTagCompoundHashMapTransformer.transformBytes(basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private static void initNames() {
        copy_name = HodgepodgeCore.isObf() ? "b" : "copy";
        copy_desc = HodgepodgeCore.isObf() ? "()Ldy;" : "()Lnet/minecraft/nbt/NBTBase;";
        nbtbase_name = HodgepodgeCore.isObf() ? "dy" : "net/minecraft/nbt/NBTBase";
        nbttagcompound_name = HodgepodgeCore.isObf() ? "dh" : "net/minecraft/nbt/NBTTagCompound";
        tagMap_name = HodgepodgeCore.isObf() ? "c" : "tagMap";
        setTag_name = HodgepodgeCore.isObf() ? "a" : "setTag";
        setTag_desc = HodgepodgeCore.isObf() ? "(Ljava/lang/String;Ldy;)V" : "(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V";
    }

    private static byte[] transformBytes(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        NBTTagCompoundHashMapTransformer.transformClassNode(cn);
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private static void transformClassNode(ClassNode cn) {
        NBTTagCompoundHashMapTransformer.addConstructor(cn);
        for (MethodNode mn : cn.methods) {
            if (mn.name.equals(INIT) && mn.desc.equals(EMPTY_DESC)) {
                NBTTagCompoundHashMapTransformer.transformConstructor(mn);
                continue;
            }
            if (!mn.name.equals(copy_name) || !mn.desc.equals(copy_desc)) continue;
            NBTTagCompoundHashMapTransformer.overwriteCopy(mn);
        }
    }

    private static void addConstructor(ClassNode cn) {
        MethodVisitor mv = cn.visitMethod(1, INIT, "(I)V", null, null);
        mv.visitCode();
        Label label0 = new Label();
        mv.visitLabel(label0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, nbtbase_name, INIT, EMPTY_DESC, false);
        Label label1 = new Label();
        mv.visitLabel(label1);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, FASTUTIL_HASHMAP);
        mv.visitInsn(89);
        mv.visitVarInsn(21, 1);
        mv.visitMethodInsn(183, FASTUTIL_HASHMAP, INIT, "(I)V", false);
        mv.visitFieldInsn(181, nbttagcompound_name, tagMap_name, "Ljava/util/Map;");
        Label label2 = new Label();
        mv.visitLabel(label2);
        mv.visitInsn(177);
        Label label3 = new Label();
        mv.visitLabel(label3);
        mv.visitLocalVariable("this", "L" + nbttagcompound_name + ";", null, label0, label3, 0);
        mv.visitLocalVariable("capacity", "I", null, label0, label3, 1);
        mv.visitMaxs(4, 2);
        mv.visitEnd();
    }

    private static void transformConstructor(MethodNode mn) {
        for (AbstractInsnNode node : mn.instructions.toArray()) {
            AbstractInsnNode thirdNode;
            AbstractInsnNode secondNode;
            if (node.getOpcode() != 187 || !(node instanceof TypeInsnNode)) continue;
            TypeInsnNode tNode = (TypeInsnNode)node;
            if (!tNode.desc.equals(HASHMAP) || (secondNode = node.getNext()).getOpcode() != 89 || (thirdNode = secondNode.getNext()).getOpcode() != 183 || !(thirdNode instanceof MethodInsnNode)) continue;
            MethodInsnNode mNode = (MethodInsnNode)thirdNode;
            if (!mNode.name.equals(INIT) || !mNode.desc.equals(EMPTY_DESC) || !mNode.owner.equals(HASHMAP)) continue;
            HodgepodgeCore.logASM(LOGGER, "Replaced HashMap instantiation in NBTTagCompound.<init> with it/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap");
            tNode.desc = FASTUTIL_HASHMAP;
            mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new InsnNode(7));
            mNode.owner = FASTUTIL_HASHMAP;
            mNode.desc = "(I)V";
        }
    }

    private static void overwriteCopy(MethodNode mn) {
        mn.instructions.clear();
        mn.exceptions.clear();
        mn.tryCatchBlocks.clear();
        mn.localVariables.clear();
        mn.visitCode();
        Label label0 = new Label();
        mn.visitLabel(label0);
        mn.visitTypeInsn(187, nbttagcompound_name);
        mn.visitInsn(89);
        mn.visitVarInsn(25, 0);
        mn.visitFieldInsn(180, nbttagcompound_name, tagMap_name, "Ljava/util/Map;");
        mn.visitMethodInsn(185, "java/util/Map", "size", "()I", true);
        mn.visitMethodInsn(183, nbttagcompound_name, INIT, "(I)V", false);
        mn.visitVarInsn(58, 1);
        Label label1 = new Label();
        mn.visitLabel(label1);
        mn.visitVarInsn(25, 0);
        mn.visitFieldInsn(180, nbttagcompound_name, tagMap_name, "Ljava/util/Map;");
        mn.visitTypeInsn(192, FASTUTIL_HASHMAP);
        Label label2 = new Label();
        mn.visitLabel(label2);
        mn.visitMethodInsn(182, FASTUTIL_HASHMAP, "object2ObjectEntrySet", "()Lit/unimi/dsi/fastutil/objects/Object2ObjectMap$FastEntrySet;", false);
        mn.visitVarInsn(58, 2);
        Label label3 = new Label();
        mn.visitLabel(label3);
        mn.visitVarInsn(25, 2);
        mn.visitMethodInsn(185, "it/unimi/dsi/fastutil/objects/Object2ObjectMap$FastEntrySet", "fastIterator", "()Lit/unimi/dsi/fastutil/objects/ObjectIterator;", true);
        mn.visitVarInsn(58, 3);
        Label label4 = new Label();
        mn.visitLabel(label4);
        mn.visitFrame(1, 3, new Object[]{nbttagcompound_name, "it/unimi/dsi/fastutil/objects/Object2ObjectMap$FastEntrySet", "it/unimi/dsi/fastutil/objects/ObjectIterator"}, 0, null);
        mn.visitVarInsn(25, 3);
        mn.visitMethodInsn(185, "it/unimi/dsi/fastutil/objects/ObjectIterator", "hasNext", "()Z", true);
        Label label5 = new Label();
        mn.visitJumpInsn(153, label5);
        Label label6 = new Label();
        mn.visitLabel(label6);
        mn.visitVarInsn(25, 3);
        mn.visitMethodInsn(185, "it/unimi/dsi/fastutil/objects/ObjectIterator", "next", "()Ljava/lang/Object;", true);
        mn.visitTypeInsn(192, "it/unimi/dsi/fastutil/objects/Object2ObjectMap$Entry");
        mn.visitVarInsn(58, 4);
        Label label7 = new Label();
        mn.visitLabel(label7);
        mn.visitVarInsn(25, 1);
        mn.visitVarInsn(25, 4);
        mn.visitMethodInsn(185, "it/unimi/dsi/fastutil/objects/Object2ObjectMap$Entry", "getKey", "()Ljava/lang/Object;", true);
        mn.visitTypeInsn(192, "java/lang/String");
        mn.visitVarInsn(25, 4);
        mn.visitMethodInsn(185, "it/unimi/dsi/fastutil/objects/Object2ObjectMap$Entry", "getValue", "()Ljava/lang/Object;", true);
        mn.visitTypeInsn(192, nbtbase_name);
        mn.visitMethodInsn(182, nbtbase_name, copy_name, copy_desc, false);
        mn.visitMethodInsn(182, nbttagcompound_name, setTag_name, setTag_desc, false);
        Label label8 = new Label();
        mn.visitLabel(label8);
        mn.visitJumpInsn(167, label4);
        mn.visitLabel(label5);
        mn.visitFrame(3, 0, null, 0, null);
        mn.visitVarInsn(25, 1);
        mn.visitInsn(176);
        Label label9 = new Label();
        mn.visitLabel(label9);
        mn.visitLocalVariable("entry", "Lit/unimi/dsi/fastutil/objects/Object2ObjectMap$Entry;", "Lit/unimi/dsi/fastutil/objects/Object2ObjectMap$Entry<Ljava/lang/String;L" + nbtbase_name + ";>;", label7, label8, 4);
        mn.visitLocalVariable("this", "L" + nbttagcompound_name + ";", null, label0, label9, 0);
        mn.visitLocalVariable("nbt", "L" + nbttagcompound_name + ";", null, label1, label9, 1);
        mn.visitLocalVariable("entries", "Lit/unimi/dsi/fastutil/objects/Object2ObjectMap$FastEntrySet;", "Lit/unimi/dsi/fastutil/objects/Object2ObjectMap$FastEntrySet<Ljava/lang/String;L" + nbtbase_name + ";>;", label3, label9, 2);
        mn.visitLocalVariable("fastIterator", "Lit/unimi/dsi/fastutil/objects/ObjectIterator;", "Lit/unimi/dsi/fastutil/objects/ObjectIterator<Lit/unimi/dsi/fastutil/objects/Object2ObjectMap$Entry<Ljava/lang/String;L" + nbtbase_name + ";>;>;", label4, label9, 3);
        mn.visitMaxs(3, 5);
        mn.visitEnd();
    }
}

