/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipOutputStream;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Utils {
    private static Unsafe cachedUnsafe;
    private static MethodHandles.Lookup cachedImplLookup;

    public static Unsafe getUnsafe() {
        if (cachedUnsafe != null) {
            return cachedUnsafe;
        }
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            cachedUnsafe = (Unsafe)f.get(null);
            return cachedUnsafe;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new UnsupportedOperationException("Unable to get Unsafe instance", e);
        }
    }

    public static MethodHandles.Lookup getImplLookup() {
        if (cachedImplLookup != null) {
            return cachedImplLookup;
        }
        MethodHandles.lookup();
        MethodHandles.Lookup lookup = Utils.getImplLookupWithUnsafe();
        if (lookup == null) {
            lookup = Utils.getImplLookupWithSerialization();
        }
        if (lookup == null) {
            lookup = Utils.constructImplLookupWithReflection();
        }
        if (lookup == null) {
            lookup = Utils.constructImplLookupWithSerialization();
        }
        if (lookup == null) {
            throw new UnsupportedOperationException("Unable to get or construct IMPL_LOOKUP");
        }
        cachedImplLookup = lookup;
        return cachedImplLookup;
    }

    private static MethodHandles.Lookup getImplLookupWithUnsafe() {
        try {
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            Unsafe unsafe = Utils.getUnsafe();
            MethodHandles.Lookup IMPL_LOOKUP = (MethodHandles.Lookup)unsafe.getObject(MethodHandles.Lookup.class, unsafe.staticFieldOffset(implLookupField));
            return IMPL_LOOKUP;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static MethodHandles.Lookup constructImplLookupWithReflection() {
        try {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            return (MethodHandles.Lookup)constructor.newInstance(Object.class, -1);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static MethodHandles.Lookup getImplLookupWithSerialization() {
        ReflectionFactory factory = ReflectionFactory.getReflectionFactory();
        try {
            Constructor<?> constructor = factory.newConstructorForSerialization(MethodHandles.Lookup.class, MethodHandles.Lookup.class.getDeclaredConstructor(Class.class));
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)constructor.newInstance(MethodHandles.Lookup.class);
            MethodHandle getter = lookup.findStaticGetter(MethodHandles.Lookup.class, "IMPL_LOOKUP", MethodHandles.Lookup.class);
            return getter.invokeExact();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static MethodHandles.Lookup constructImplLookupWithSerialization() {
        ReflectionFactory factory = ReflectionFactory.getReflectionFactory();
        try {
            Constructor<?> constructor = factory.newConstructorForSerialization(MethodHandles.Lookup.class, MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE));
            return (MethodHandles.Lookup)constructor.newInstance(Object.class, -1);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static FileSystem openZipFileSystem(Path path, boolean create) throws IOException {
        if (create && !Files.exists(path, new LinkOption[0])) {
            new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0])).close();
        }
        return FileSystems.newFileSystem(path, null);
    }

    public static byte[] readAllBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }

    public static int getCurrentClassVersion() {
        String version = System.getProperty("java.class.version");
        if (version != null) {
            try {
                return Integer.parseInt(version.split("\\.")[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException("Unable to determine current class version");
    }

    public static int classVersionToMajorVersion(int version) {
        if (version == 196653) {
            return 1;
        }
        return version - 46 + 2;
    }

    public static int majorVersionToClassVersion(int version) {
        if (version == 1) {
            return 196653;
        }
        return version + 46 - 2;
    }

    public static <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }

    public static String getDescForClass(Class<?> cls) {
        if (cls.isPrimitive()) {
            if (cls == Void.TYPE) {
                return "V";
            }
            if (cls == Boolean.TYPE) {
                return "Z";
            }
            if (cls == Byte.TYPE) {
                return "B";
            }
            if (cls == Character.TYPE) {
                return "C";
            }
            if (cls == Short.TYPE) {
                return "S";
            }
            if (cls == Integer.TYPE) {
                return "I";
            }
            if (cls == Long.TYPE) {
                return "J";
            }
            if (cls == Float.TYPE) {
                return "F";
            }
            if (cls == Double.TYPE) {
                return "D";
            }
        }
        if (cls.isArray()) {
            return "[" + Utils.getDescForClass(cls.getComponentType());
        }
        return "L" + cls.getName().replace('.', '/') + ";";
    }

    public static Class<?> getClassForDesc(String desc) throws ClassNotFoundException {
        if (desc.length() == 1) {
            switch (desc) {
                case "Z": {
                    return Boolean.TYPE;
                }
                case "B": {
                    return Byte.TYPE;
                }
                case "C": {
                    return Character.TYPE;
                }
                case "S": {
                    return Short.TYPE;
                }
                case "I": {
                    return Integer.TYPE;
                }
                case "J": {
                    return Long.TYPE;
                }
                case "F": {
                    return Float.TYPE;
                }
                case "D": {
                    return Double.TYPE;
                }
                case "V": {
                    return Void.TYPE;
                }
            }
            throw new ClassNotFoundException("Unable to determine class for " + desc);
        }
        if (desc.startsWith("[")) {
            int dims = 0;
            for (int i = 0; i < desc.length() && desc.charAt(i) == '['; ++i) {
                ++dims;
            }
            Class<?> type = Utils.getClassForDesc(desc.substring(dims));
            return Array.newInstance(type, new int[dims]).getClass();
        }
        return Class.forName(desc.substring(1, desc.length() - 1).replace('/', '.'));
    }

    public static Class<?> getBoxFor(Class<?> prim) {
        if (!prim.isPrimitive()) {
            throw new IllegalArgumentException("type " + prim + " is not a primitive");
        }
        switch (prim.getName()) {
            case "boolean": {
                return Boolean.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "char": {
                return Character.class;
            }
            case "short": {
                return Short.class;
            }
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
            case "void": {
                return Void.class;
            }
        }
        throw new IllegalArgumentException("type " + prim + " not found");
    }

    public static boolean isReflectionFrame(String className) {
        return className.equals(Method.class.getName()) || className.equals(Constructor.class.getName()) || className.startsWith("sun.reflect.") || className.startsWith("jdk.internal.reflect.") || className.startsWith("java.lang.invoke.LambdaForm");
    }

    public static Class<?> getCaller(MethodHandles.Lookup lookup) throws ClassNotFoundException {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stack.length; ++i) {
            String className = stack[i].getClassName();
            if (Utils.isReflectionFrame(className)) continue;
            return Class.forName(className, false, lookup.lookupClass().getClassLoader());
        }
        throw new ClassNotFoundException("Could not find caller class???");
    }

    public static boolean equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        if (aLength == 0) {
            return true;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return false;
        }
        return true;
    }
}

