/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.providers;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import xyz.wagyourtail.jvmdg.ClassDowngrader;
import xyz.wagyourtail.jvmdg.asm.ASMUtils;
import xyz.wagyourtail.jvmdg.j7.stub.J_L_Throwable;
import xyz.wagyourtail.jvmdg.util.Function;
import xyz.wagyourtail.jvmdg.util.IOFunction;
import xyz.wagyourtail.jvmdg.util.Pair;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.ReflectionReferences;
import xyz.wagyourtail.jvmdg.version.VersionProvider;
import xyz.wagyourtail.jvmdg.version.map.FullyQualifiedMemberNameAndDesc;
import xyz.wagyourtail.jvmdg.version.map.MemberNameAndDesc;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Java7Downgrader
extends VersionProvider {
    public Java7Downgrader() {
        super(51, 50, 0);
    }

    public void ensureInit(ClassDowngrader downgrader) {
        if (!this.isInitialized()) {
            downgrader.logger.warn("Java 7 -> 6 Stubs are VERY incomplete!");
        }
        super.ensureInit(downgrader);
    }

    public void init() {
        this.stub(J_L_Throwable.class);
    }

    public ClassNode otherTransforms(ClassNode clazz, Set<ClassNode> extra, Function<String, ClassNode> getReadOnly, Set<String> warnings, boolean enableRuntime, IOFunction<Type, Set<MemberNameAndDesc>> memberResolver, IOFunction<Type, List<Pair<Type, Boolean>>> superTypeResolver) throws IOException {
        InsnList addToClinit = new InsnList();
        Type handleType = this.stubClass(Type.getObjectType((String)"java/lang/invoke/MethodHandle"), warnings);
        Type callSiteType = this.stubClass(Type.getObjectType((String)"java/lang/invoke/CallSite"), warnings);
        Type handlesType = this.stubClass(Type.getObjectType((String)"java/lang/invoke/MethodHandles"), warnings);
        Type lookupType = this.stubClass(Type.getObjectType((String)"java/lang/invoke/MethodHandles$Lookup"), warnings);
        Type methodType = this.stubClass(Type.getObjectType((String)"java/lang/invoke/MethodType"), warnings);
        MethodNode clinit = null;
        ArrayList<FullyQualifiedMemberNameAndDesc> reflectionRefList = new ArrayList<FullyQualifiedMemberNameAndDesc>();
        for (MethodNode method : new ArrayList(clazz.methods)) {
            if (method.name.equals("<clinit>")) {
                clinit = method;
            }
            if (method.instructions == null) continue;
            for (int i = 0; i < method.instructions.size(); ++i) {
                String name;
                AbstractInsnNode insn = method.instructions.get(i);
                if (insn.getType() == 6) {
                    InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
                    name = this.indyToMethod(method, indy, clazz, addToClinit, callSiteType, handleType, lookupType, methodType, reflectionRefList);
                    InsnList insns = new InsnList();
                    method.instructions.set((AbstractInsnNode)indy, (AbstractInsnNode)new MethodInsnNode(184, clazz.name, name, indy.desc, false));
                }
                if (insn.getType() != 9) continue;
                assert (insn instanceof LdcInsnNode);
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Handle) {
                    name = this.handleToLookupField((Handle)cst, clazz, addToClinit, handleType, lookupType, methodType, reflectionRefList);
                    method.instructions.set(insn, (AbstractInsnNode)new FieldInsnNode(178, clazz.name, name, handleType.getDescriptor()));
                    continue;
                }
                if (!(cst instanceof Type) || ((Type)cst).getSort() != 11) continue;
                name = Java7Downgrader.methodDescToLookupField((Type)cst, clazz, addToClinit, methodType);
                method.instructions.set(insn, (AbstractInsnNode)new FieldInsnNode(178, clazz.name, name, methodType.getDescriptor()));
            }
        }
        if (addToClinit.size() > 0) {
            if (clinit == null) {
                clinit = new MethodNode(589824, 8, "<clinit>", "()V", null, null);
                clinit.visitCode();
                clinit.visitInsn(177);
                clinit.visitMaxs(0, 0);
                clinit.visitEnd();
                clazz.methods.add(clinit);
            }
            if (clinit.visibleAnnotations == null) {
                clinit.visibleAnnotations = new ArrayList();
            }
            String reflectionRefs = Type.getType(ReflectionReferences.class).getDescriptor();
            String refType = Type.getType(Ref.class).getDescriptor();
            AnnotationNode node = null;
            for (AnnotationNode a : clinit.visibleAnnotations) {
                if (!a.desc.equals(reflectionRefs)) continue;
                node = a;
                break;
            }
            if (node == null) {
                node = new AnnotationNode(reflectionRefs);
                clinit.visibleAnnotations.add(node);
                node.values = new ArrayList<Serializable>(Arrays.asList("value", new ArrayList()));
            }
            List refs = (List)node.values.get(1);
            for (FullyQualifiedMemberNameAndDesc ref : reflectionRefList) {
                AnnotationNode refAnn = new AnnotationNode(refType);
                refAnn.visit("value", (Object)ref.getOwner().getInternalName());
                refAnn.visit("member", (Object)ref.getName());
                refAnn.visit("desc", (Object)ref.getDesc().toString());
                refAnn.visitEnd();
                refs.add(refAnn);
            }
            Handle lookup = this.stubHandle(clazz, clinit, extra, null, null, enableRuntime, memberResolver, superTypeResolver, warnings, new Handle(6, handlesType.getInternalName(), "lookup", "()" + lookupType.getDescriptor(), false));
            clazz.visitField(26, "jvmdg$lookup", lookupType.getDescriptor(), null, null);
            InsnList lookupInsns = new InsnList();
            lookupInsns.add((AbstractInsnNode)new MethodInsnNode(184, lookup.getOwner(), lookup.getName(), lookup.getDesc(), false));
            lookupInsns.add((AbstractInsnNode)new FieldInsnNode(179, clazz.name, "jvmdg$lookup", lookupType.getDescriptor()));
            addToClinit.insert(lookupInsns);
            clinit.instructions.insert(addToClinit);
        }
        return super.otherTransforms(clazz);
    }

    public String indyToMethod(MethodNode method, InvokeDynamicInsnNode indy, ClassNode clazz, InsnList addToClinit, Type callsiteType, Type handleType, Type lookupType, Type methodType, List<FullyQualifiedMemberNameAndDesc> reflectionRefList) {
        InvokeDynamicType it = new InvokeDynamicType(indy);
        for (FieldNode field : clazz.fields) {
            if (!(field instanceof IndyField) || !((IndyField)field).indy.equals(it)) continue;
            return field.name;
        }
        int count = clazz.fields.size();
        IndyField indyField = new IndyField(it, callsiteType, count);
        clazz.fields.add(indyField);
        addToClinit.add((AbstractInsnNode)new FieldInsnNode(178, clazz.name, "jvmdg$lookup", lookupType.getDescriptor()));
        addToClinit.add((AbstractInsnNode)new LdcInsnNode((Object)indy.name));
        addToClinit.add(Java7Downgrader.methodDescToMethodType(Type.getMethodType((String)indy.desc), methodType));
        for (Object arg : indy.bsmArgs) {
            if (arg instanceof Type) {
                if (((Type)arg).getSort() == 11) {
                    addToClinit.add(Java7Downgrader.methodDescToMethodType((Type)arg, methodType));
                    continue;
                }
                addToClinit.add((AbstractInsnNode)new LdcInsnNode(arg));
                continue;
            }
            if (arg instanceof Handle) {
                addToClinit.add(this.handleToLookupStack((Handle)arg, clazz, handleType, lookupType, methodType, reflectionRefList));
                continue;
            }
            addToClinit.add((AbstractInsnNode)new LdcInsnNode(arg));
        }
        addToClinit.add((AbstractInsnNode)new MethodInsnNode(184, indy.bsm.getOwner(), indy.bsm.getName(), indy.bsm.getDesc(), indy.bsm.isInterface()));
        addToClinit.add((AbstractInsnNode)new FieldInsnNode(179, clazz.name, indyField.name, indyField.desc));
        IndyMethod indyMethod = new IndyMethod(it, count);
        clazz.methods.add(indyMethod);
        indyMethod.visitCode();
        indyMethod.visitFieldInsn(178, clazz.name, indyField.name, callsiteType.getDescriptor());
        indyMethod.visitMethodInsn(182, callsiteType.getInternalName(), "getTarget", Type.getMethodDescriptor((Type)handleType, (Type[])new Type[0]), false);
        int i = 0;
        for (Type arg : Type.getArgumentTypes((String)indy.desc)) {
            indyMethod.visitVarInsn(arg.getOpcode(21), i);
            i += arg.getSize();
        }
        indyMethod.visitMethodInsn(182, handleType.getInternalName(), "invokeExact", indy.desc, false);
        Type returnType = Type.getReturnType((String)indy.desc);
        indyMethod.visitInsn(returnType.getOpcode(172));
        indyMethod.visitMaxs(0, 0);
        indyMethod.visitEnd();
        return indyMethod.name;
    }

    public String handleToLookupField(Handle handle, ClassNode clazz, InsnList addToClinit, Type handleType, Type lookupType, Type methodType, List<FullyQualifiedMemberNameAndDesc> reflectionRefList) {
        for (FieldNode field : clazz.fields) {
            if (!(field instanceof HandleField) || !handle.equals((Object)((HandleField)field).handle)) continue;
            return field.name;
        }
        HandleField field = new HandleField(handle, handleType, clazz.fields.size());
        clazz.fields.add(field);
        addToClinit.add(this.handleToLookupStack(handle, clazz, handleType, lookupType, methodType, reflectionRefList));
        addToClinit.add((AbstractInsnNode)new FieldInsnNode(179, clazz.name, field.name, field.desc));
        return field.name;
    }

    public InsnList handleToLookupStack(Handle handle, ClassNode clazz, Type handleType, Type lookupType, Type methodType, List<FullyQualifiedMemberNameAndDesc> reflectionRefList) {
        String desc;
        String funcName;
        reflectionRefList.add(FullyQualifiedMemberNameAndDesc.of((Handle)handle));
        InsnList insns = new InsnList();
        insns.add((AbstractInsnNode)new FieldInsnNode(178, clazz.name, "jvmdg$lookup", lookupType.getDescriptor()));
        insns.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType((String)handle.getOwner())));
        if (handle.getTag() != 8) {
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)handle.getName()));
        }
        switch (handle.getTag()) {
            case 1: {
                funcName = "findGetter";
                break;
            }
            case 2: {
                funcName = "findStaticGetter";
                break;
            }
            case 3: {
                funcName = "findSetter";
                break;
            }
            case 4: {
                funcName = "findStaticSetter";
                break;
            }
            case 5: 
            case 9: {
                funcName = "findVirtual";
                break;
            }
            case 6: {
                funcName = "findStatic";
                break;
            }
            case 7: {
                funcName = "findSpecial";
                break;
            }
            case 8: {
                funcName = "findConstructor";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        switch (handle.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                desc = Type.getMethodDescriptor((Type)handleType, (Type[])new Type[]{Type.getObjectType((String)"java/lang/Class"), Type.getObjectType((String)"java/lang/String"), Type.getObjectType((String)"java/lang/Class")});
                insns.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)handle.getDesc())));
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                desc = Type.getMethodDescriptor((Type)handleType, (Type[])new Type[]{Type.getObjectType((String)"java/lang/Class"), Type.getObjectType((String)"java/lang/String"), methodType});
                insns.add(Java7Downgrader.methodDescToMethodType(Type.getMethodType((String)handle.getDesc()), methodType));
                break;
            }
            case 7: {
                desc = Type.getMethodDescriptor((Type)handleType, (Type[])new Type[]{Type.getObjectType((String)"java/lang/Class"), Type.getObjectType((String)"java/lang/String"), methodType, Type.getObjectType((String)"java/lang/Class")});
                insns.add(Java7Downgrader.methodDescToMethodType(Type.getMethodType((String)handle.getDesc()), methodType));
                insns.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType((String)clazz.name)));
                break;
            }
            case 8: {
                desc = Type.getMethodDescriptor((Type)handleType, (Type[])new Type[]{Type.getObjectType((String)"java/lang/Class"), methodType});
                insns.add(Java7Downgrader.methodDescToMethodType(Type.getMethodType((String)handle.getDesc()), methodType));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        insns.add((AbstractInsnNode)new MethodInsnNode(182, lookupType.getInternalName(), funcName, desc, false));
        return insns;
    }

    public static String methodDescToLookupField(Type desc, ClassNode clazz, InsnList addToClinit, Type methodType) {
        int i = 0;
        for (FieldNode field : clazz.fields) {
            if (!(field instanceof MethodTypeField)) continue;
            if (desc.equals((Object)((MethodTypeField)field).type)) {
                return field.name;
            }
            ++i;
        }
        MethodTypeField type = new MethodTypeField(desc, "jvmdg$methodtype$" + i, methodType);
        clazz.fields.add(type);
        addToClinit.add(Java7Downgrader.methodDescToMethodType(desc, methodType));
        addToClinit.add((AbstractInsnNode)new FieldInsnNode(179, clazz.name, type.name, type.desc));
        return type.name;
    }

    public static InsnList methodDescToMethodType(Type desc, Type methodType) {
        InsnList l = new InsnList();
        Type returnType = desc.getReturnType();
        Type[] args = desc.getArgumentTypes();
        if (returnType.getSort() < 9) {
            l.add((AbstractInsnNode)new FieldInsnNode(178, ASMUtils.getBoxFor((Type)returnType).getInternalName(), "TYPE", "Ljava/lang/Class;"));
        } else {
            l.add((AbstractInsnNode)new LdcInsnNode((Object)returnType));
        }
        l.add((AbstractInsnNode)new LdcInsnNode((Object)args.length));
        l.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Class"));
        for (int i = 0; i < args.length; ++i) {
            l.add((AbstractInsnNode)new InsnNode(89));
            l.add((AbstractInsnNode)new LdcInsnNode((Object)i));
            if (args[i].getSort() < 9) {
                l.add((AbstractInsnNode)new FieldInsnNode(178, ASMUtils.getBoxFor((Type)args[i]).getInternalName(), "TYPE", "Ljava/lang/Class;"));
            } else {
                l.add((AbstractInsnNode)new LdcInsnNode((Object)args[i]));
            }
            l.add((AbstractInsnNode)new InsnNode(83));
        }
        l.add((AbstractInsnNode)new MethodInsnNode(184, methodType.getInternalName(), "methodType", "(Ljava/lang/Class;[Ljava/lang/Class;)" + methodType.getDescriptor(), false));
        return l;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class InvokeDynamicType {
        InvokeDynamicInsnNode indy;

        public InvokeDynamicType(InvokeDynamicInsnNode indy) {
            this.indy = indy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InvokeDynamicType)) {
                return false;
            }
            InvokeDynamicType that = (InvokeDynamicType)o;
            return this.indy.bsm.equals((Object)that.indy.bsm) && this.indy.name.equals(that.indy.name) && this.indy.desc.equals(that.indy.desc) && Arrays.equals(this.indy.bsmArgs, that.indy.bsmArgs);
        }

        public int hashCode() {
            return Objects.hash(this.indy.bsm, this.indy.name, this.indy.desc, Arrays.hashCode(this.indy.bsmArgs));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class IndyField
    extends FieldNode {
        private final InvokeDynamicType indy;

        public IndyField(InvokeDynamicType indy, Type callsiteType, int count) {
            super(589824, 26, "jvmdg$indy$" + indy.indy.name + "$" + count, callsiteType.getDescriptor(), null, null);
            this.indy = indy;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class HandleField
    extends FieldNode {
        private final Handle handle;

        public HandleField(Handle handle, Type handleType, int count) {
            super(589824, 26, "jvmdg$handle$" + handle.getName() + "$" + count, handleType.getDescriptor(), null, null);
            this.handle = handle;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class MethodTypeField
    extends FieldNode {
        private final Type type;

        public MethodTypeField(Type type, String name, Type methodType) {
            super(1, name, methodType.getDescriptor(), null, null);
            this.type = type;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class IndyMethod
    extends MethodNode {
        private final InvokeDynamicType indy;

        public IndyMethod(InvokeDynamicType indy, int count) {
            super(589824, 10, "jvmdg$indy$" + indy.indy.name + "$" + count, indy.indy.desc, null, null);
            this.indy = indy;
        }
    }
}

