/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.providers;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_I_Reader;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_L_CharSequence;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_L_IO;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_L_R_AccessFlag;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_L_ScopedValue;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_U_Currency;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_U_TimeZone;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_U_Z_Deflater;
import xyz.wagyourtail.jvmdg.j25.stub.java_base.J_U_Z_Inflater;
import xyz.wagyourtail.jvmdg.j25.stub.java_net_http.J_N_H_HttpResponse;
import xyz.wagyourtail.jvmdg.util.Function;
import xyz.wagyourtail.jvmdg.util.IOFunction;
import xyz.wagyourtail.jvmdg.util.Pair;
import xyz.wagyourtail.jvmdg.version.VersionProvider;
import xyz.wagyourtail.jvmdg.version.map.MemberNameAndDesc;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Java25Downgrader
extends VersionProvider {
    public Java25Downgrader() {
        super(69, 68, 0);
    }

    public void init() {
        this.stub(J_I_Reader.class);
        this.stub(J_L_CharSequence.class);
        this.stub(J_L_IO.class);
        this.stub(J_L_R_AccessFlag.class);
        this.stub(J_L_ScopedValue.class);
        this.stub(J_U_Currency.class);
        this.stub(J_U_TimeZone.class);
        this.stub(J_U_Z_Deflater.class);
        this.stub(J_U_Z_Inflater.class);
        this.stub(J_N_H_HttpResponse.class);
    }

    public ClassNode otherTransforms(ClassNode clazz, Set<ClassNode> extra, Function<String, ClassNode> getReadOnly, Set<String> warnings, boolean enableRuntime, IOFunction<Type, Set<MemberNameAndDesc>> memberResolver, IOFunction<Type, List<Pair<Type, Boolean>>> superTypeResolver) throws IOException {
        this.addMissingMains(clazz, getReadOnly, superTypeResolver);
        this.renameInstanceMains(clazz);
        return super.otherTransforms(clazz);
    }

    private void renameInstanceMains(ClassNode clazz) {
        block0: for (MethodNode method : clazz.methods) {
            if (method.name.equals("main") && method.desc.equals("([Ljava/lang/String;)V") && (method.access & 8) == 0) {
                method.name = "jvmdg$instanceMain";
            }
            for (AbstractInsnNode insn : method.instructions) {
                MethodInsnNode min;
                if (insn.getType() != 5 || (min = (MethodInsnNode)insn).getOpcode() == 184 || !min.name.equals("main") || !min.desc.equals("([Ljava/lang/String;)V")) continue;
                min.name = "jvmdg$instanceMain";
                continue block0;
            }
        }
    }

    private void addMissingMains(ClassNode clazz, Function<String, ClassNode> getReadOnly, IOFunction<Type, List<Pair<Type, Boolean>>> superTypeResolver) throws IOException {
        EnumSet<MainType> mainMethods = EnumSet.noneOf(MainType.class);
        int publicStatic = 9;
        List<Pair<Type, Boolean>> superTypes = superTypeResolver.apply(Type.getObjectType((String)clazz.name));
        superTypes.add(0, new Pair<Type, Boolean>(Type.getObjectType((String)clazz.name), false));
        for (Pair<Type, Boolean> superType : superTypes) {
            ClassNode cn = getReadOnly.apply(superType.getFirst().getInternalName());
            if (cn == null) continue;
            for (MethodNode mn : cn.methods) {
                if (!mn.name.equals("main") || (mn.access & 2) == 2) continue;
                if (mn.desc.equals("([Ljava/lang/String;)V")) {
                    if ((mn.access & publicStatic) == publicStatic) {
                        mainMethods.add(MainType.TRADITIONAL);
                        continue;
                    }
                    if ((mn.access & 8) == 8) {
                        mainMethods.add(MainType.STATIC_ARGS);
                        continue;
                    }
                    mainMethods.add(MainType.INSTANCE_ARGS);
                    continue;
                }
                if (!mn.desc.equals("()V")) continue;
                if ((mn.access & 8) == 8) {
                    mainMethods.add(MainType.STATIC);
                    continue;
                }
                mainMethods.add(MainType.INSTANCE);
            }
        }
        if (mainMethods.isEmpty() || mainMethods.contains((Object)MainType.TRADITIONAL)) {
            return;
        }
        MainType firstType = (MainType)((Object)mainMethods.iterator().next());
        switch (firstType) {
            case STATIC_ARGS: {
                for (MethodNode mn : clazz.methods) {
                    if (!mn.name.equals("main") || !mn.desc.equals("([Ljava/lang/String;)V")) continue;
                    mn.access |= 1;
                }
                break;
            }
            case STATIC: {
                MethodVisitor mv = clazz.visitMethod(9 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "main", "([Ljava/lang/String;)V", null, null);
                mv.visitCode();
                mv.visitMethodInsn(184, clazz.name, "main", "()V", false);
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                break;
            }
            case INSTANCE_ARGS: {
                if ((clazz.access & 0x200) == 512) break;
                MethodVisitor mv = clazz.visitMethod(9 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "main", "([Ljava/lang/String;)V", null, null);
                mv.visitCode();
                mv.visitTypeInsn(187, clazz.name);
                mv.visitInsn(89);
                mv.visitMethodInsn(183, clazz.name, "<init>", "()V", false);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, clazz.name, "jvmdg$instanceMain", "([Ljava/lang/String;)V", false);
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                break;
            }
            case INSTANCE: {
                if ((clazz.access & 0x200) == 512) break;
                MethodVisitor mv = clazz.visitMethod(9 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "main", "([Ljava/lang/String;)V", null, null);
                mv.visitCode();
                mv.visitTypeInsn(187, clazz.name);
                mv.visitInsn(89);
                mv.visitMethodInsn(183, clazz.name, "<init>", "()V", false);
                mv.visitMethodInsn(182, clazz.name, "main", "()V", false);
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
                break;
            }
            default: {
                throw new IllegalArgumentException("No main method found");
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum MainType {
        TRADITIONAL("([Ljava/lang/String;)V"),
        STATIC_ARGS("([Ljava/lang/String;)V"),
        STATIC("()V"),
        INSTANCE_ARGS("([Ljava/lang/String;)V"),
        INSTANCE("()V");

        public final String desc;

        private MainType(String desc) {
            this.desc = desc;
        }
    }
}

