/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.providers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_I_ByteArrayOutputStream;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_I_FileReader;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_I_FileWriter;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_I_InputStream;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_I_OutputStream;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_I_Reader;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_I_Writer;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_CharSequence;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_Character;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_Class;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_I_ConstantBootstraps;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_String;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_StringBuffer;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_L_StringBuilder;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_C_SelectionKey;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_C_Selector;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Path;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_C_TimeUnit;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Collection;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_F_Predicate;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_OptionalDouble;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_OptionalInt;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_OptionalLong;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_R_Pattern;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Z_Deflater;
import xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Z_Inflater;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpClient;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpHeaders;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpResponse;
import xyz.wagyourtail.jvmdg.util.Function;
import xyz.wagyourtail.jvmdg.version.VersionProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Java11Downgrader
extends VersionProvider {
    public Java11Downgrader() {
        super(55, 54, 0);
    }

    public void init() {
        this.stub(J_I_ByteArrayOutputStream.class);
        this.stub(J_I_FileReader.class);
        this.stub(J_I_FileWriter.class);
        this.stub(J_I_InputStream.class);
        this.stub(J_I_OutputStream.class);
        this.stub(J_I_Reader.class);
        this.stub(J_I_Writer.class);
        this.stub(J_L_Character.class);
        this.stub(J_L_CharSequence.class);
        this.stub(J_L_Class.class);
        this.stub(J_L_String.class);
        this.stub(J_L_StringBuffer.class);
        this.stub(J_L_StringBuilder.class);
        this.stub(J_L_I_ConstantBootstraps.class);
        this.stub(J_N_C_SelectionKey.class);
        this.stub(J_N_C_Selector.class);
        this.stub(J_N_F_Files.class);
        this.stub(J_N_F_Path.class);
        this.stub(J_U_Collection.class);
        this.stub(J_U_Optional.class);
        this.stub(J_U_OptionalDouble.class);
        this.stub(J_U_OptionalInt.class);
        this.stub(J_U_OptionalLong.class);
        this.stub(J_U_C_TimeUnit.class);
        this.stub(J_U_F_Predicate.class);
        this.stub(J_U_R_Pattern.class);
        this.stub(J_U_Z_Deflater.class);
        this.stub(J_U_Z_Inflater.class);
        this.stub(J_N_H_HttpClient.class);
        this.stub(J_N_H_HttpHeaders.class);
        this.stub(J_N_H_HttpRequest.class);
        this.stub(J_N_H_HttpResponse.class);
    }

    public ClassNode otherTransforms(ClassNode clazz, Set<ClassNode> extra, Function<String, ClassNode> getReadOnly) throws IOException {
        super.otherTransforms(clazz);
        if (clazz.name.equals("module-info")) {
            return null;
        }
        this.fixNests(clazz, getReadOnly);
        this.replaceCondy(clazz);
        this.fixPrivateMethodsInInterfaces(clazz);
        return clazz;
    }

    public void fixNests(ClassNode clazz, Function<String, ClassNode> getReadOnly) {
        if (clazz.nestHostClass == null) {
            this.fixNestsForParent(clazz, getReadOnly);
        } else {
            this.fixNestsForChild(clazz, getReadOnly);
        }
    }

    public Map<String, Object> determinePrivateFieldsAndMethodsReadByNestMembers(ClassNode clazz, Collection<ClassNode> nestMembers) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (ClassNode nestMember : nestMembers) {
            fields.putAll(this.determinePrivateFieldsAndMethodsReadByNestMember(clazz, nestMember));
        }
        return fields;
    }

    public Map<String, Object> determinePrivateFieldsAndMethodsReadByNestMember(ClassNode clazz, ClassNode nestMember) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (nestMember.methods == null) {
            return fields;
        }
        HashMap<String, Object> nestMemberPrivates = new HashMap<String, Object>();
        for (FieldNode field : clazz.fields) {
            if ((field.access & 2) == 0) continue;
            nestMemberPrivates.put(field.name, field);
        }
        for (MethodNode method : clazz.methods) {
            if ((method.access & 2) == 0) continue;
            nestMemberPrivates.put(method.name + method.desc, method);
        }
        for (MethodNode method : nestMember.methods) {
            if (method.instructions == null) continue;
            for (Object insn : method.instructions) {
                if (insn instanceof FieldInsnNode) {
                    FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                    if (!fieldInsn.owner.equals(clazz.name) || !nestMemberPrivates.containsKey(fieldInsn.name)) continue;
                    fields.put(fieldInsn.name, nestMemberPrivates.get(fieldInsn.name));
                    continue;
                }
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (!methodInsn.owner.equals(clazz.name) || !nestMemberPrivates.containsKey(methodInsn.name + methodInsn.desc)) continue;
                fields.put(methodInsn.name + methodInsn.desc, nestMemberPrivates.get(methodInsn.name + methodInsn.desc));
            }
        }
        return fields;
    }

    public void useAccessors(ClassNode clazz, Map<String, ClassNode> nestMembers) {
        if (clazz.methods == null) {
            return;
        }
        for (MethodNode method : clazz.methods) {
            if (method.instructions == null) continue;
            block12: for (int i = 0; i < method.instructions.size(); ++i) {
                ClassNode target;
                AbstractInsnNode insn = method.instructions.get(i);
                if (insn instanceof FieldInsnNode) {
                    FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                    if (!nestMembers.containsKey(fieldInsn.owner)) continue;
                    target = nestMembers.get(fieldInsn.owner);
                    for (FieldNode field : target.fields) {
                        if (!field.name.equals(fieldInsn.name)) continue;
                        if ((field.access & 2) == 0) continue block12;
                        switch (insn.getOpcode()) {
                            case 178: {
                                method.instructions.set(insn, (AbstractInsnNode)new MethodInsnNode(184, fieldInsn.owner, "jvmdowngrader$nest$" + fieldInsn.owner.replace("/", "_") + "$get$" + fieldInsn.name, "()" + fieldInsn.desc, false));
                                continue block12;
                            }
                            case 179: {
                                method.instructions.set(insn, (AbstractInsnNode)new MethodInsnNode(184, fieldInsn.owner, "jvmdowngrader$nest$" + fieldInsn.owner.replace("/", "_") + "$set$" + fieldInsn.name, "(" + fieldInsn.desc + ")V", false));
                                continue block12;
                            }
                            case 180: {
                                method.instructions.set(insn, (AbstractInsnNode)new MethodInsnNode(182, fieldInsn.owner, "jvmdowngrader$nest$" + fieldInsn.owner.replace("/", "_") + "$get$" + fieldInsn.name, "()" + fieldInsn.desc, false));
                                continue block12;
                            }
                            case 181: {
                                method.instructions.set(insn, (AbstractInsnNode)new MethodInsnNode(182, fieldInsn.owner, "jvmdowngrader$nest$" + fieldInsn.owner.replace("/", "_") + "$set$" + fieldInsn.name, "(" + fieldInsn.desc + ")V", false));
                                continue block12;
                            }
                            default: {
                                throw new RuntimeException("Unexpected opcode: " + insn.getOpcode());
                            }
                        }
                    }
                    continue;
                }
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                if (!nestMembers.containsKey(methodInsn.owner) || methodInsn.name.equals("<init>")) continue;
                target = nestMembers.get(methodInsn.owner);
                for (MethodNode methodNode : target.methods) {
                    if (!methodNode.name.equals(methodInsn.name) || !methodNode.desc.equals(methodInsn.desc)) continue;
                    if ((methodNode.access & 2) == 0) continue block12;
                    switch (insn.getOpcode()) {
                        case 184: {
                            method.instructions.set(insn, (AbstractInsnNode)new MethodInsnNode(184, methodInsn.owner, "jvmdowngrader$nest$" + methodInsn.owner.replace("/", "_") + "$" + methodInsn.name, methodInsn.desc, false));
                            continue block12;
                        }
                        case 182: {
                            method.instructions.set(insn, (AbstractInsnNode)new MethodInsnNode(182, methodInsn.owner, "jvmdowngrader$nest$" + methodInsn.owner.replace("/", "_") + "$" + methodInsn.name, methodInsn.desc, false));
                            continue block12;
                        }
                        case 183: {
                            method.instructions.set(insn, (AbstractInsnNode)new MethodInsnNode(183, methodInsn.owner, "jvmdowngrader$nest$" + methodInsn.owner.replace("/", "_") + "$" + methodInsn.name, methodInsn.desc, false));
                            continue block12;
                        }
                        default: {
                            throw new RuntimeException("Unexpected opcode: " + insn.getOpcode());
                        }
                    }
                }
            }
        }
    }

    private void createAccessors(ClassNode clazz, Map<String, Object> fields) {
        for (String field : fields.keySet()) {
            if (field.contains("(")) {
                String name = field.substring(0, field.indexOf("("));
                String desc = field.substring(field.indexOf("("));
                Type methodType = Type.getMethodType((String)desc);
                Type[] args = methodType.getArgumentTypes();
                Type returnType = methodType.getReturnType();
                if (!(fields.get(field) instanceof MethodNode)) {
                    throw new RuntimeException("not method?");
                }
                MethodNode methodNode = (MethodNode)fields.get(field);
                boolean isStatic = (methodNode.access & 8) != 0;
                if (name.equals("<init>")) {
                    if (fields.get(field) instanceof MethodNode) {
                        methodNode = (MethodNode)fields.get(field);
                        methodNode.access &= 0xFFFFFFFD;
                        continue;
                    }
                    throw new RuntimeException("not method?");
                }
                MethodVisitor mv = clazz.visitMethod((isStatic ? 8 : 0) | 1 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "jvmdowngrader$nest$" + clazz.name.replace("/", "_") + "$" + name, desc, null, null);
                mv.visitCode();
                if (!isStatic) {
                    mv.visitVarInsn(25, 0);
                }
                int index = isStatic ? 0 : 1;
                for (Type arg : args) {
                    mv.visitVarInsn(arg.getOpcode(21), index);
                    index += arg.getSize();
                }
                mv.visitMethodInsn(isStatic ? 184 : 183, clazz.name, name, desc, false);
                if (returnType == Type.VOID_TYPE) {
                    mv.visitInsn(177);
                } else {
                    mv.visitInsn(returnType.getOpcode(172));
                }
                mv.visitEnd();
                continue;
            }
            String desc = ((FieldNode)fields.get((Object)field)).desc;
            Type fieldType = Type.getType((String)desc);
            if (!(fields.get(field) instanceof FieldNode)) {
                throw new RuntimeException("not field?");
            }
            FieldNode fieldNode = (FieldNode)fields.get(field);
            boolean isStatic = (fieldNode.access & 8) != 0;
            MethodVisitor mv = clazz.visitMethod((isStatic ? 8 : 0) | 1 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "jvmdowngrader$nest$" + clazz.name.replace("/", "_") + "$get$" + field, "()" + desc, null, null);
            mv.visitCode();
            if (!isStatic) {
                mv.visitVarInsn(25, 0);
            }
            mv.visitFieldInsn(isStatic ? 178 : 180, clazz.name, field, desc);
            mv.visitInsn(fieldType.getOpcode(172));
            mv.visitEnd();
            mv = clazz.visitMethod((isStatic ? 8 : 0) | 1 | (this.downgrader.flags.debugNoSynthetic ? 0 : 4096), "jvmdowngrader$nest$" + clazz.name.replace("/", "_") + "$set$" + field, "(" + desc + ")V", null, null);
            mv.visitCode();
            if (!isStatic) {
                mv.visitVarInsn(25, 0);
            }
            mv.visitVarInsn(fieldType.getOpcode(21), isStatic ? 0 : 1);
            mv.visitFieldInsn(isStatic ? 179 : 181, clazz.name, field, desc);
            mv.visitInsn(177);
            mv.visitEnd();
        }
    }

    public void fixNestsForParent(ClassNode clazz, Function<String, ClassNode> getReadOnly) {
        if (clazz.nestMembers == null) {
            return;
        }
        AnnotationVisitor av = clazz.visitAnnotation(Type.getType(NestMembers.class).getDescriptor(), true);
        AnnotationVisitor values = av.visitArray("value");
        for (String member : clazz.nestMembers) {
            values.visit(null, (Object)Type.getObjectType((String)member));
        }
        values.visitEnd();
        av.visitEnd();
        HashMap<String, ClassNode> nestMembers = new HashMap<String, ClassNode>();
        for (String member : clazz.nestMembers) {
            ClassNode node = getReadOnly.apply(member);
            if (node == null) continue;
            nestMembers.put(node.name, node);
        }
        this.createAccessors(clazz, this.determinePrivateFieldsAndMethodsReadByNestMembers(clazz, nestMembers.values()));
        this.useAccessors(clazz, nestMembers);
        clazz.nestMembers = null;
    }

    public void fixNestsForChild(ClassNode clazz, Function<String, ClassNode> getReadOnly) {
        if (clazz.nestHostClass == null) {
            return;
        }
        AnnotationVisitor av = clazz.visitAnnotation(Type.getType(NestHost.class).getDescriptor(), true);
        av.visit("value", (Object)Type.getObjectType((String)clazz.nestHostClass));
        av.visitEnd();
        HashMap<String, ClassNode> nestMembers = new HashMap<String, ClassNode>();
        ClassNode nestHost = getReadOnly.apply(clazz.nestHostClass);
        if (nestHost == null) {
            throw new RuntimeException("nest host not found?");
        }
        for (String member : nestHost.nestMembers) {
            ClassNode node = getReadOnly.apply(member);
            if (node == null) continue;
            nestMembers.put(node.name, node);
        }
        nestMembers.put(nestHost.name, nestHost);
        nestMembers.remove(clazz.name);
        this.createAccessors(clazz, this.determinePrivateFieldsAndMethodsReadByNestMembers(clazz, nestMembers.values()));
        this.useAccessors(clazz, nestMembers);
        clazz.nestHostClass = null;
    }

    public void replaceCondy(ClassNode clazz) {
        for (MethodNode method : clazz.methods) {
            this.replaceCondy(method);
        }
    }

    public void replaceCondy(MethodNode method) {
        for (int i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode insn = method.instructions.get(i);
            if (insn instanceof LdcInsnNode) {
                LdcInsnNode ldc = (LdcInsnNode)insn;
                if (ldc.cst instanceof ConstantDynamic) {
                    ConstantDynamic condy = (ConstantDynamic)ldc.cst;
                    Object[] bsmArgs = new Object[condy.getBootstrapMethodArgumentCount() + 1];
                    bsmArgs[0] = condy.getBootstrapMethod();
                    for (int j = 0; j < condy.getBootstrapMethodArgumentCount(); ++j) {
                        bsmArgs[j + 1] = condy.getBootstrapMethodArgument(j);
                    }
                    InvokeDynamicInsnNode indy = new InvokeDynamicInsnNode(condy.getName(), "()" + condy.getDescriptor(), new Handle(6, Type.getInternalName(J_L_I_ConstantBootstraps.class), "ldcCondyToIndy", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false), bsmArgs);
                    method.instructions.set(insn, (AbstractInsnNode)indy);
                    insn = indy;
                }
            }
            if (!(insn instanceof InvokeDynamicInsnNode)) continue;
            InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
            StringBuilder condyArgs = new StringBuilder();
            for (int j = 0; j < indy.bsmArgs.length; ++j) {
                if (!(indy.bsmArgs[j] instanceof ConstantDynamic)) continue;
                condyArgs.append((char)j);
            }
            if (condyArgs.length() <= 0) continue;
            ArrayList<Object> bsmArgs = new ArrayList<Object>();
            bsmArgs.add(indy.bsm);
            bsmArgs.add(condyArgs.toString());
            for (Object bsmArg : indy.bsmArgs) {
                if (bsmArg instanceof ConstantDynamic) {
                    ConstantDynamic condy = (ConstantDynamic)bsmArg;
                    this.insertCondyArgs(condy, bsmArgs);
                    continue;
                }
                bsmArgs.add(bsmArg);
            }
            indy = new InvokeDynamicInsnNode(indy.name, indy.desc, new Handle(6, Type.getInternalName(J_L_I_ConstantBootstraps.class), "nestedCondyInIndy", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false), bsmArgs.toArray());
            method.instructions.set(insn, (AbstractInsnNode)indy);
        }
    }

    public void insertCondyArgs(ConstantDynamic condy, List<Object> bsmArgs) {
        int j;
        bsmArgs.add(condy.getBootstrapMethod());
        bsmArgs.add(condy.getName());
        bsmArgs.add(Type.getType((String)condy.getDescriptor()));
        bsmArgs.add(condy.getBootstrapMethodArgumentCount());
        StringBuilder condyArgs = new StringBuilder();
        for (j = 0; j < condy.getBootstrapMethodArgumentCount(); ++j) {
            if (!(condy.getBootstrapMethodArgument(j) instanceof ConstantDynamic)) continue;
            condyArgs.append((char)j);
        }
        bsmArgs.add(condyArgs.toString());
        for (j = 0; j < condy.getBootstrapMethodArgumentCount(); ++j) {
            Object o = condy.getBootstrapMethodArgument(j);
            if (o instanceof ConstantDynamic) {
                this.insertCondyArgs((ConstantDynamic)o, bsmArgs);
                continue;
            }
            bsmArgs.add(o);
        }
    }

    public void fixPrivateMethodsInInterfaces(ClassNode node) {
        if ((node.access & 0x200) == 0) {
            return;
        }
        ArrayList<String> privateMethods = new ArrayList<String>();
        for (MethodNode method : node.methods) {
            if ((method.access & 2) == 0) continue;
            privateMethods.add(method.name + method.desc);
        }
        for (MethodNode method : node.methods) {
            if (method.instructions == null) continue;
            for (AbstractInsnNode insn : method.instructions) {
                Handle lambda;
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode min = (MethodInsnNode)insn;
                    if (min.getOpcode() != 185 || !min.owner.equals(node.name) || !privateMethods.contains(min.name + min.desc)) continue;
                    min.setOpcode(183);
                    continue;
                }
                if (!(insn instanceof InvokeDynamicInsnNode)) continue;
                InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
                if (!indy.bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory") || !(indy.bsmArgs[1] instanceof Handle) || !(lambda = (Handle)indy.bsmArgs[1]).getOwner().equals(node.name) || lambda.getTag() != 9 || !privateMethods.contains(lambda.getName() + lambda.getDesc())) continue;
                indy.bsmArgs[1] = new Handle(7, lambda.getOwner(), lambda.getName(), lambda.getDesc(), lambda.isInterface());
            }
        }
    }
}

