/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.util.Objects;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.j9.intl.IteratorSupport;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_U_Scanner {
    @Stub
    public static Stream<String> tokens(Scanner scanner) {
        return new ScannerStream(scanner, null).tokens();
    }

    @Stub
    public static Stream<MatchResult> findAll(Scanner scanner, Pattern pattern) {
        return new ScannerStream(scanner, pattern).findAll();
    }

    @Stub
    public static Stream<MatchResult> findAll(Scanner scanner, String patternString) {
        return new ScannerStream(scanner, Pattern.compile(patternString)).findAll();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ScannerStream {
        private final Scanner scanner;
        private final Pattern pattern;

        public ScannerStream(Scanner scanner, Pattern pattern) {
            this.scanner = scanner;
            this.pattern = pattern;
        }

        public Stream<String> tokens() {
            return new IteratorSupport<String>(this::hasNextToken, this::nextToken).stream();
        }

        public boolean hasNextToken() {
            return this.scanner.hasNext();
        }

        public String nextToken() {
            return this.scanner.next();
        }

        public Stream<MatchResult> findAll() {
            Objects.requireNonNull(this.pattern);
            return new IteratorSupport<MatchResult>(this::hasNextMatch, this::nextMatch).stream();
        }

        public boolean hasNextMatch() {
            return this.scanner.findWithinHorizon(this.pattern, 0) != null;
        }

        public MatchResult nextMatch() {
            return this.scanner.match();
        }
    }
}

