/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_U_S_Collectors {
    @Stub(ref=@Ref(value="Ljava/util/stream/Collectors;"))
    public static <T, U, A, R> Collector<T, ?, R> flatMapping(Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, A, R> downstream) {
        BiConsumer<A, ? super U> downstreamAccumulator = downstream.accumulator();
        return new FlatMappingCollector<T, U, A, R>(mapper, downstream).get();
    }

    @Stub(ref=@Ref(value="Ljava/util/stream/Collectors;"))
    public static <T, A, R> Collector<T, ?, R> filtering(Predicate<? super T> predicate, Collector<? super T, A, R> downstream) {
        return new FilteringCollector<T, A, R>(predicate, downstream).get();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class FilteringCollector<T, A, R> {
        private final Predicate<? super T> predicate;
        private final Collector<? super T, A, R> downstream;

        public FilteringCollector(Predicate<? super T> predicate, Collector<? super T, A, R> downstream) {
            this.predicate = predicate;
            this.downstream = downstream;
        }

        public Collector<T, ?, R> get() {
            return Collector.of(this.downstream.supplier(), this::accumulator, this.downstream.combiner(), this.downstream.finisher(), this.downstream.characteristics().toArray(new Collector.Characteristics[0]));
        }

        public void accumulator(A a, T t) {
            if (this.predicate.test(t)) {
                this.downstream.accumulator().accept(a, t);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class FlatMappingCollector<T, U, A, R> {
        private final Function<? super T, ? extends Stream<? extends U>> mapper;
        private final Collector<? super U, A, R> downstream;

        public FlatMappingCollector(Function<? super T, ? extends Stream<? extends U>> mapper, Collector<? super U, A, R> downstream) {
            this.mapper = mapper;
            this.downstream = downstream;
        }

        public Collector<T, ?, R> get() {
            BiConsumer<A, ? super U> downstreamAccumulator = this.downstream.accumulator();
            return Collector.of(this.downstream.supplier(), this::accumulator, this.downstream.combiner(), this.downstream.finisher(), this.downstream.characteristics().toArray(new Collector.Characteristics[0]));
        }

        public void accumulator(A a, T t) {
            try (Stream<U> result = this.mapper.apply(t);){
                if (result != null) {
                    ((Stream)result.sequential()).forEach(u -> this.downstream.accumulator().accept(a, u));
                }
            }
        }
    }
}

