/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_U_C_CompletableFuture {
    @Stub
    public static <U> CompletableFuture<U> newIncompleteFuture(CompletableFuture<U> future) {
        return new CompletableFuture();
    }

    @Stub
    public static Executor defaultExecutor(CompletableFuture<?> future) {
        return ForkJoinPool.commonPool();
    }

    @Stub
    public static <T> CompletableFuture<T> copy(CompletableFuture<T> future) {
        return future.thenApply(Function.identity());
    }

    @Stub
    public static <T> CompletionStage<T> minimalCompletionStage(CompletableFuture<T> future) {
        return future.thenApply(Function.identity());
    }

    @Stub
    public static <T> CompletableFuture<T> completeAsync(CompletableFuture<T> future, Supplier<? extends T> supplier, Executor executor) {
        if (supplier == null || executor == null) {
            throw new NullPointerException();
        }
        new Completer<T>(future, supplier).completeAsync(executor);
        return future;
    }

    @Stub
    public static <T> CompletableFuture<T> completeAsync(CompletableFuture<T> future, Supplier<? extends T> supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        new Completer<T>(future, supplier).completeAsync(ForkJoinPool.commonPool());
        return future;
    }

    @Stub
    public static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (future.isDone()) {
            return future;
        }
        new Completer<T>(future, null).orTimeout(timeout, unit);
        return future;
    }

    @Stub
    public static <T> CompletableFuture<T> completeOnTimeout(CompletableFuture<T> future, T value, long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (future.isDone()) {
            return future;
        }
        new Completer<T>(future, null).completeOnTimeout(value, timeout, unit);
        return future;
    }

    @Stub(ref=@Ref(value="Ljava/util/concurrent/CompletableFuture;"))
    public static Executor delayedExecutor(long delay, TimeUnit unit, Executor executor) {
        return new DelayedExecutor(executor, delay, unit);
    }

    @Stub(ref=@Ref(value="Ljava/util/concurrent/CompletableFuture;"))
    public static Executor delayedExecutor(long delay, TimeUnit unit) {
        return new DelayedExecutor(ForkJoinPool.commonPool(), delay, unit);
    }

    @Stub(ref=@Ref(value="Ljava/util/concurrent/CompletableFuture;"))
    public static <U> CompletionStage<U> completedStage(U value) {
        return CompletableFuture.completedFuture(value);
    }

    @Stub(ref=@Ref(value="Ljava/util/concurrent/CompletableFuture;"))
    public static <U> CompletableFuture<U> failedFuture(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    @Stub(ref=@Ref(value="Ljava/util/concurrent/CompletableFuture;"))
    public static <U> CompletionStage<U> failedStage(Throwable ex) {
        if (ex == null) {
            throw new NullPointerException();
        }
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(ex);
        return future;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class DelayedExecutor
    implements Executor {
        private final Executor executor;
        private final long delay;
        private final TimeUnit unit;

        public DelayedExecutor(Executor executor, long delay, TimeUnit unit) {
            this.executor = executor;
            this.delay = delay;
            this.unit = unit;
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(() -> {
                try {
                    Thread.sleep(this.unit.toMillis(this.delay));
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
                command.run();
            });
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Completer<T> {
        private final CompletableFuture<T> future;
        private final Supplier<? extends T> supplier;

        public Completer(CompletableFuture<T> future, Supplier<? extends T> supplier) {
            this.future = future;
            this.supplier = supplier;
        }

        public void completeAsync(Executor executor) {
            if (this.future.isDone()) {
                return;
            }
            executor.execute(this::complete);
        }

        public void complete() {
            if (this.future.isDone()) {
                return;
            }
            this.future.complete(this.supplier.get());
        }

        public void completeOnTimeout(T value, long timeout, TimeUnit unit) {
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(unit.toMillis(timeout));
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
                if (this.future.isDone()) {
                    return;
                }
                this.future.complete(value);
            });
        }

        public void orTimeout(long timeout, TimeUnit unit) {
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(unit.toMillis(timeout));
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.err);
                }
                if (this.future.isDone()) {
                    return;
                }
                this.future.completeExceptionally(new TimeoutException());
            });
        }
    }
}

