/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_T_LocalDate {
    @Stub(ref=@Ref(value="Ljava/time/LocalDate;"))
    public static LocalDate ofInstant(Instant instant, ZoneId zone) {
        ZonedDateTime zdt = instant.atZone(zone);
        return zdt.toLocalDate();
    }

    @Stub
    public static Stream<LocalDate> datesUntil(LocalDate start, LocalDate endExclusive) {
        long startEpochDay = start.toEpochDay();
        long endEpochDay = endExclusive.toEpochDay();
        if (endEpochDay < startEpochDay) {
            throw new IllegalArgumentException(endExclusive + " < " + start);
        }
        return LongStream.range(startEpochDay, endEpochDay).mapToObj(LocalDate::ofEpochDay);
    }

    @Stub
    public static Stream<LocalDate> datesUntil(LocalDate self, LocalDate endExclusive, Period step) {
        return new DatesUntil(self, endExclusive, step).dateStream();
    }

    @Stub
    public static long toEpochSecond(LocalDate date, LocalTime time, ZoneOffset off) {
        Objects.requireNonNull(time, "time");
        Objects.requireNonNull(off, "off");
        long secs = date.toEpochDay() * 60L * 60L * 24L + (long)time.toSecondOfDay();
        return secs - (long)off.getTotalSeconds();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class DatesUntil {
        private final long months;
        private final long days;
        private final LocalDate from;
        private final LocalDate to;
        private final long start;
        private final long end;

        public DatesUntil(LocalDate from, LocalDate to, Period step) {
            if (step.isZero()) {
                throw new IllegalArgumentException("step is zero");
            }
            long months = step.toTotalMonths();
            long days = step.getDays();
            if (months < 0L && days > 0L || months > 0L && days < 0L) {
                throw new IllegalArgumentException("period months and days are of opposite sign");
            }
            this.months = months;
            this.days = days;
            this.from = from;
            this.to = to;
            this.end = to.toEpochDay();
            this.start = from.toEpochDay();
        }

        public static long getProlepticMonth(LocalDate date) {
            return (long)date.getYear() * 12L + (long)date.getMonthValue() - 1L;
        }

        public Stream<LocalDate> dateStream() {
            long maxAddMonths;
            long until = this.end - this.start;
            if (until == 0L) {
                return Stream.empty();
            }
            int sign = this.months > 0L || this.days > 0L ? 1 : -1;
            if (sign < 0 ^ until < 0L) {
                throw new IllegalArgumentException(this.to + (sign < 0 ? " > " : " < ") + this.from);
            }
            if (this.months == 0L) {
                long steps = (until - (long)sign) / this.days;
                return LongStream.rangeClosed(0L, steps).mapToObj(this::mapWithinMonth);
            }
            long steps = until * 1600L / (this.months * 48699L + this.days * 1600L) + 1L;
            long addMonths = this.months * steps;
            long addDays = this.days * steps;
            long l = maxAddMonths = this.months > 0L ? DatesUntil.getProlepticMonth(LocalDate.MAX) - DatesUntil.getProlepticMonth(this.from) : DatesUntil.getProlepticMonth(this.from) - DatesUntil.getProlepticMonth(LocalDate.MIN);
            if (addMonths * (long)sign > maxAddMonths || (this.from.plusMonths(addMonths).toEpochDay() + addDays) * (long)sign >= this.end * (long)sign) {
                --steps;
                if ((addMonths -= this.months) * (long)sign > maxAddMonths || (this.from.plusMonths(addMonths).toEpochDay() + (addDays -= this.days)) * (long)sign >= this.end * (long)sign) {
                    --steps;
                }
            }
            return LongStream.rangeClosed(0L, steps).mapToObj(this::map);
        }

        public LocalDate mapWithinMonth(long n) {
            return LocalDate.ofEpochDay(this.start + n * this.days);
        }

        public LocalDate map(long n) {
            return this.from.plusMonths(this.months * n).plusDays(this.days * n);
        }
    }
}

