/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.time.DateTimeException;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_T_C_IsoChronology {
    @Stub
    public static long epochSecond(IsoChronology self, int prolepticYear, int month, int dayOfMonth, int hour, int minute, int second, ZoneOffset zoneOffset) {
        ChronoField.YEAR.checkValidValue(prolepticYear);
        ChronoField.MONTH_OF_YEAR.checkValidValue(month);
        ChronoField.DAY_OF_MONTH.checkValidValue(dayOfMonth);
        ChronoField.HOUR_OF_DAY.checkValidValue(hour);
        ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(second);
        Objects.requireNonNull(zoneOffset, "zoneOffset");
        if (dayOfMonth > 28) {
            int dom;
            switch (month) {
                case 2: {
                    dom = IsoChronology.INSTANCE.isLeapYear(prolepticYear) ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    dom = 30;
                    break;
                }
                default: {
                    dom = 31;
                }
            }
            if (dayOfMonth > dom) {
                if (dayOfMonth == 29) {
                    throw new DateTimeException("Invalid date 'February 29' as '" + prolepticYear + "' is not a leap year");
                }
                throw new DateTimeException("Invalid date '" + Month.of(month).name() + " " + dayOfMonth + "'");
            }
        }
        long totalDays = 0L;
        int timeinSec = 0;
        totalDays += 365L * (long)prolepticYear;
        totalDays = prolepticYear >= 0 ? (totalDays += ((long)prolepticYear + 3L) / 4L - ((long)prolepticYear + 99L) / 100L + ((long)prolepticYear + 399L) / 400L) : (totalDays -= (long)(prolepticYear / -4 - prolepticYear / -100 + prolepticYear / -400));
        totalDays += (367L * (long)month - 362L) / 12L;
        totalDays += (long)(dayOfMonth - 1);
        if (month > 2) {
            --totalDays;
            if (!IsoChronology.INSTANCE.isLeapYear(prolepticYear)) {
                --totalDays;
            }
        }
        timeinSec = (hour * 60 + minute) * 60 + second;
        return Math.addExact(Math.multiplyExact(totalDays -= 719528L, 86400L), (long)(timeinSec - zoneOffset.getTotalSeconds()));
    }
}

