/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.time.ZoneOffset;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.temporal.ChronoField;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Math;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_T_C_Chronology {
    @Stub
    public static long epochSecond(Chronology self, int prolepticYear, int month, int dayOfMonth, int hour, int minute, int second, ZoneOffset zoneOffset) {
        Objects.requireNonNull(zoneOffset, "zoneOffset");
        ChronoField.HOUR_OF_DAY.checkValidValue(hour);
        ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(second);
        long daysInSec = J_L_Math.multiplyExact(self.date(prolepticYear, month, dayOfMonth).toEpochDay(), 86400);
        long timeInSec = ((long)hour * 60L + (long)minute) * 60L + (long)second;
        return Math.addExact(daysInSec, timeInSec - (long)zoneOffset.getTotalSeconds());
    }

    @Stub
    public static long epochSecond(Chronology self, Era era, int yearOfEra, int month, int dayOfMonth, int hour, int minute, int second, ZoneOffset zoneOffset) {
        Objects.requireNonNull(era, "era");
        Objects.requireNonNull(zoneOffset, "zoneOffset");
        ChronoField.HOUR_OF_DAY.checkValidValue(hour);
        ChronoField.MINUTE_OF_HOUR.checkValidValue(minute);
        ChronoField.SECOND_OF_MINUTE.checkValidValue(second);
        long daysInSec = J_L_Math.multiplyExact(self.date(era, yearOfEra, month, dayOfMonth).toEpochDay(), 86400);
        long timeInSec = ((long)hour * 60L + (long)minute) * 60L + (long)second;
        return Math.addExact(daysInSec, timeInSec - (long)zoneOffset.getTotalSeconds());
    }
}

