/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_IllegalCallerException;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/lang/StackWalker")
public class J_L_StackWalker {
    static final EnumSet<Option> DEFAULT_EMPTY = EnumSet.noneOf(Option.class);
    private static final J_L_StackWalker DEFAULT = new J_L_StackWalker(DEFAULT_EMPTY);
    private final EnumSet<Option> options;
    private final boolean retainClassRef;

    private J_L_StackWalker(EnumSet<Option> options) {
        this.options = options;
        this.retainClassRef = options.contains((Object)Option.RETAIN_CLASS_REFERENCE);
    }

    public static J_L_StackWalker getInstance() {
        return DEFAULT;
    }

    public static J_L_StackWalker getInstance(Option option) {
        return new J_L_StackWalker(EnumSet.of(option));
    }

    public static J_L_StackWalker getInstance(Set<Option> options) {
        return new J_L_StackWalker(options.isEmpty() ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(options));
    }

    public static J_L_StackWalker getInstance(Set<Option> options, int i) {
        if (i <= 0) {
            throw new IllegalArgumentException("estimateDepth must be > 0");
        }
        return new J_L_StackWalker(EnumSet.copyOf(options));
    }

    private static boolean isReflectionFrame(String className) {
        return className.equals(Method.class.getName()) || className.equals(Constructor.class.getName()) || className.startsWith("sun.reflect.") || className.startsWith("jdk.internal.reflect.") || className.startsWith("java.lang.invoke.LambdaForm");
    }

    public <T> T walk(Function<? super Stream<StackFrame>, ? extends T> function) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Class[] classRef = SecurityManagerAdapter.INSTANCE.getClassContext();
        boolean showHidden = this.options.contains((Object)Option.SHOW_HIDDEN_FRAMES);
        boolean showReflect = this.options.contains((Object)Option.SHOW_REFLECT_FRAMES) || showHidden;
        AtomicInteger classRefOffset = new AtomicInteger();
        Stream<StackFrame> stackStream = IntStream.range(2, stackTrace.length).mapToObj(i -> {
            StackFrameImpl frame = new StackFrameImpl();
            frame.element = stackTrace[i];
            if (J_L_StackWalker.isReflectionFrame(stackTrace[i].getClassName())) {
                classRefOffset.addAndGet(-1);
            }
            frame.classRef = classRef[i + classRefOffset.get()];
            return frame;
        }).filter(e -> {
            if (showHidden) {
                return true;
            }
            if (e.getClassName().equals("xyz.wagyourtail.jvmdg.runtime.Bootstrap")) {
                return false;
            }
            if (e.getClassName().equals("xyz.wagyourtail.jvmdg.cli.Main")) {
                return false;
            }
            if (showReflect) {
                return true;
            }
            return !J_L_StackWalker.isReflectionFrame(e.getClassName());
        }).peek(e -> {
            if (!this.retainClassRef) {
                ((StackFrameImpl)e).classRef = null;
            }
        });
        return function.apply(stackStream);
    }

    public void forEach(Consumer<? super StackFrame> action) {
        this.walk(stream -> {
            stream.skip(1L).forEach(action);
            return null;
        });
    }

    public Class<?> getCallerClass() {
        return this.walk(stream -> ((StackFrame)stream.skip(2L).findFirst().orElseThrow(J_L_IllegalCallerException::new)).getDeclaringClass());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class SecurityManagerAdapter
    extends SecurityManager {
        static final SecurityManagerAdapter INSTANCE = new SecurityManagerAdapter();

        SecurityManagerAdapter() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class StackFrameImpl
    implements StackFrame {
        StackTraceElement element;
        Class<?> classRef;

        StackFrameImpl() {
        }

        @Override
        public String getClassName() {
            return this.element.getClassName();
        }

        @Override
        public String getMethodName() {
            return this.element.getMethodName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            if (this.classRef != null) {
                return this.classRef;
            }
            throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
        }

        @Override
        public int getByteCodeIndex() {
            return this.isNativeMethod() ? -1 : 0;
        }

        @Override
        public String getFileName() {
            return this.element.getFileName();
        }

        @Override
        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        @Override
        public boolean isNativeMethod() {
            return this.element.isNativeMethod();
        }

        @Override
        public StackTraceElement toStackTraceElement() {
            return this.element;
        }

        public String toString() {
            return this.element.toString();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/StackWalker$StackFrame")
    public static interface StackFrame {
        public String getClassName();

        public String getMethodName();

        public Class<?> getDeclaringClass();

        public int getByteCodeIndex();

        public String getFileName();

        public int getLineNumber();

        public boolean isNativeMethod();

        public StackTraceElement toStackTraceElement();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/StackWalker$Option")
    public static enum Option {
        RETAIN_CLASS_REFERENCE,
        SHOW_REFLECT_FRAMES,
        SHOW_HIDDEN_FRAMES;

    }
}

