/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Runtime {
    @Stub(ref=@Ref(value="java/lang/Runtime"))
    public static Version version() {
        return Version.INSTANCE;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/Runtime$Version")
    public static final class Version
    implements Comparable<Version> {
        public static final Version INSTANCE = Version.parse(System.getProperty("java.runtime.version"));
        private final List<Integer> version;
        private final Optional<String> pre;
        private final Optional<Integer> build;
        private final Optional<String> optional;

        private Version(List<Integer> unmodifiableListOfVersions, Optional<String> pre, Optional<Integer> build, Optional<String> optional) {
            this.version = unmodifiableListOfVersions;
            this.pre = pre;
            this.build = build;
            this.optional = optional;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Version parse(String s) {
            void var4_8;
            Optional<Integer> build;
            void var4_5;
            if (s == null) {
                throw new NullPointerException();
            }
            if (Version.isSimpleNumber(s)) {
                return new Version(Collections.singletonList(Integer.parseInt(s)), Optional.empty(), Optional.empty(), Optional.empty());
            }
            Matcher m = VersionPattern.VSTR_PATTERN.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid version string: '" + s + "'");
            }
            String[] split = m.group("VNUM").split("[._]");
            Integer[] version = new Integer[split.length];
            boolean bl = false;
            while (var4_5 < split.length) {
                version[var4_5] = Integer.parseInt(split[var4_5]);
                ++var4_5;
            }
            Optional<String> optional = Optional.ofNullable(m.group("PRE"));
            String b = m.group("BUILD");
            Optional<Integer> optional2 = build = b == null ? Optional.empty() : Optional.of(Integer.parseInt(b));
            if (optional.isPresent() && !build.isPresent() && optional.get().matches("b\\d+")) {
                build = Optional.of(Integer.parseInt(optional.get().substring(1)));
                Optional optional3 = Optional.empty();
            }
            Optional<String> optional4 = Optional.ofNullable(m.group("OPT"));
            if (build.isPresent()) return new Version(Arrays.asList(version), (Optional<String>)var4_8, build, optional4);
            if (m.group("PLUS") != null) {
                if (!optional4.isPresent()) throw new IllegalArgumentException("'+' found with neither build or optional components: '" + s + "'");
                if (!var4_8.isPresent()) return new Version(Arrays.asList(version), (Optional<String>)var4_8, build, optional4);
                throw new IllegalArgumentException("'+' found with pre-release and optional components:'" + s + "'");
            }
            if (!optional4.isPresent() || var4_8.isPresent()) return new Version(Arrays.asList(version), (Optional<String>)var4_8, build, optional4);
            throw new IllegalArgumentException("optional component must be preceded by a pre-release component or '+': '" + s + "'");
        }

        private static boolean isSimpleNumber(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char lowerBound;
                char c = s.charAt(i);
                char c2 = lowerBound = i > 0 ? (char)'0' : '1';
                if (c >= lowerBound && c <= '9') continue;
                return false;
            }
            return true;
        }

        public int major() {
            return this.version.get(0);
        }

        public int minor() {
            return this.version.size() > 1 ? this.version.get(1) : 0;
        }

        public int security() {
            return this.version.size() > 2 ? this.version.get(2) : 0;
        }

        public List<Integer> version() {
            return this.version;
        }

        public Optional<String> pre() {
            return this.pre;
        }

        public Optional<Integer> build() {
            return this.build;
        }

        public Optional<String> optional() {
            return this.optional;
        }

        @Override
        public int compareTo(Version o) {
            return this.compare(o, false);
        }

        public int compareToIgnoreOptional(Version obj) {
            return this.compare(obj, true);
        }

        private int compare(Version obj, boolean ignoreOpt) {
            if (obj == null) {
                throw new NullPointerException();
            }
            int ret = this.compareVersion(obj);
            if (ret != 0) {
                return ret;
            }
            ret = this.comparePre(obj);
            if (ret != 0) {
                return ret;
            }
            ret = this.compareBuild(obj);
            if (ret != 0) {
                return ret;
            }
            if (!ignoreOpt) {
                return this.compareOptional(obj);
            }
            return 0;
        }

        private int compareVersion(Version obj) {
            int size = this.version.size();
            int oSize = obj.version().size();
            int min = Math.min(size, oSize);
            for (int i = 0; i < min; ++i) {
                int oVal;
                int val = this.version.get(i);
                if (val == (oVal = obj.version().get(i).intValue())) continue;
                return val - oVal;
            }
            return size - oSize;
        }

        private int comparePre(Version obj) {
            Optional<String> oPre = obj.pre();
            if (!this.pre.isPresent()) {
                if (oPre.isPresent()) {
                    return 1;
                }
            } else {
                if (!oPre.isPresent()) {
                    return -1;
                }
                String val = this.pre.get();
                String oVal = oPre.get();
                if (val.matches("\\d+")) {
                    return oVal.matches("\\d+") ? new BigInteger(val).compareTo(new BigInteger(oVal)) : -1;
                }
                return oVal.matches("\\d+") ? 1 : val.compareTo(oVal);
            }
            return 0;
        }

        private int compareBuild(Version obj) {
            Optional<Integer> oBuild = obj.build();
            if (oBuild.isPresent()) {
                return this.build.map(integer -> integer.compareTo((Integer)oBuild.get())).orElse(-1);
            }
            if (this.build.isPresent()) {
                return 1;
            }
            return 0;
        }

        private int compareOptional(Version obj) {
            Optional<String> oOpt = obj.optional();
            if (!this.optional.isPresent()) {
                if (oOpt.isPresent()) {
                    return -1;
                }
            } else {
                return oOpt.map(s -> this.optional.get().compareTo((String)s)).orElse(1);
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.version.stream().map(Object::toString).collect(Collectors.joining(".")));
            this.pre.ifPresent(v -> sb.append("-").append((String)v));
            if (this.build.isPresent()) {
                sb.append("+").append(this.build.get());
                this.optional.ifPresent(s -> sb.append("-").append((String)s));
            } else if (this.optional.isPresent()) {
                sb.append(this.pre.isPresent() ? "-" : "+-");
                sb.append(this.optional.get());
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            boolean ret = this.equalsIgnoreOptional(obj);
            if (!ret) {
                return false;
            }
            Version that = (Version)obj;
            return this.optional().equals(that.optional());
        }

        public boolean equalsIgnoreOptional(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Version) {
                Version that = (Version)obj;
                return this.version().equals(that.version()) && this.pre().equals(that.pre()) && this.build().equals(that.build());
            }
            return false;
        }

        public int hashCode() {
            int h = 1;
            int p = 17;
            h = p * h + this.version.hashCode();
            h = p * h + this.pre.hashCode();
            h = p * h + this.build.hashCode();
            h = p * h + this.optional.hashCode();
            return h;
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        private static class VersionPattern {
            static final String VNUM_GROUP = "VNUM";
            static final String PRE_GROUP = "PRE";
            static final String PLUS_GROUP = "PLUS";
            static final String BUILD_GROUP = "BUILD";
            static final String OPT_GROUP = "OPT";
            private static final String VNUM = "(?:1\\.)?(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*[._][1-9][0-9]*)*)";
            private static final String PRE = "(?:-(?<PRE>[a-zA-Z0-9-_]+?))?";
            private static final String BUILD = "(?:(?<PLUS>\\+|-b)(?<BUILD>[0-9]+)?)?";
            private static final String OPT = "(?:-(?<OPT>[-~a-zA-Z0-9.]+))?";
            private static final String VSTR_FORMAT = "(?:1\\.)?(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*[._][1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9-_]+?))?(?:(?<PLUS>\\+|-b)(?<BUILD>[0-9]+)?)?(?:-(?<OPT>[-~a-zA-Z0-9.]+))?";
            static final Pattern VSTR_PATTERN = Pattern.compile("(?:1\\.)?(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*[._][1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9-_]+?))?(?:(?<PLUS>\\+|-b)(?<BUILD>[0-9]+)?)?(?:-(?<OPT>[-~a-zA-Z0-9.]+))?");

            private VersionPattern() {
            }
        }
    }
}

