/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.stub.java_base;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import xyz.wagyourtail.jvmdg.j9.intl.module.ModuleConstantHelper;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Module;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.CoverageIgnore;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="Ljava/lang/ModuleLayer;")
public class J_L_ModuleLayer {
    static final J_L_ModuleLayer EMPTY_MODULE_LAYER = new J_L_ModuleLayer(Collections.emptyList(), Collections.emptyMap());
    private final List<J_L_ModuleLayer> parents;
    private final Map<String, J_L_Module> modules;
    private volatile Set<J_L_Module> moduleSet;
    private volatile String strValue;

    @CoverageIgnore
    public J_L_ModuleLayer(List<J_L_ModuleLayer> parents, Map<String, J_L_Module> modules) {
        this.parents = parents;
        this.modules = modules;
    }

    public static J_L_ModuleLayer empty() {
        return EMPTY_MODULE_LAYER;
    }

    public static J_L_ModuleLayer boot() {
        return ModuleConstantHelper.BOOT_LAYER;
    }

    public List<J_L_ModuleLayer> parents() {
        return this.parents;
    }

    public Set<J_L_Module> modules() {
        if (this.moduleSet == null) {
            this.moduleSet = Collections.unmodifiableSet(new HashSet<J_L_Module>(this.modules.values()));
        }
        return this.moduleSet;
    }

    public Optional<J_L_Module> findModule(String name) {
        Objects.requireNonNull(name);
        return Optional.ofNullable(this.modules.get(name));
    }

    public ClassLoader findLoader(String name) {
        Optional<J_L_Module> optionalModule = this.findModule(name);
        if (optionalModule.isPresent()) {
            return optionalModule.get().getClassLoader();
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        if (this.strValue == null) {
            StringJoiner stringJoiner = new StringJoiner(", ");
            for (J_L_Module module : this.modules()) {
                stringJoiner.add(module.getName());
            }
            this.strValue = stringJoiner.toString();
        }
        return this.strValue;
    }
}

