/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j9.intl;

import java.lang.invoke.MethodHandles;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Module;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_System;
import xyz.wagyourtail.jvmdg.util.Pair;
import xyz.wagyourtail.jvmdg.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LoggerFinderImpl
extends J_L_System.LoggerFinder {
    public static final J_L_System.LoggerFinder INSTANCE = new LoggerFinderImpl();

    private static Level getLevel(J_L_System.Logger.Level level) {
        switch (level) {
            case ALL: {
                return Level.ALL;
            }
            case TRACE: {
                return Level.FINER;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case OFF: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unknown level: " + (Object)((Object)level));
    }

    @Override
    public J_L_System.Logger getLogger(String name, J_L_Module module) {
        return new LoggerImpl(name, module);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class LoggerImpl
    implements J_L_System.Logger {
        public final Logger logger;
        public final J_L_Module module;

        public LoggerImpl(String name, J_L_Module module) {
            this.logger = Logger.getLogger(name);
            this.module = module;
        }

        private static Pair<Class<?>, String> getCallerWithMethodName(MethodHandles.Lookup lookup) throws ClassNotFoundException {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (int i = 2; i < stack.length; ++i) {
                Class<?> cls;
                String className = stack[i].getClassName();
                if (Utils.isReflectionFrame(className) || J_L_System.Logger.class.isAssignableFrom(cls = Class.forName(className))) continue;
                return new Pair(cls, stack[i].getMethodName());
            }
            throw new ClassNotFoundException("Could not find caller class???");
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isLoggable(J_L_System.Logger.Level level) {
            return this.logger.isLoggable(LoggerFinderImpl.getLevel(level));
        }

        @Override
        public void log(J_L_System.Logger.Level level, ResourceBundle bundle, String message, Throwable thrown) {
            LogRecord record = new LogRecord(LoggerFinderImpl.getLevel(level), message);
            record.setThrown(thrown);
            try {
                Pair<Class<?>, String> caller = LoggerImpl.getCallerWithMethodName(MethodHandles.lookup());
                record.setSourceClassName(caller.getFirst().getName());
                record.setSourceMethodName(caller.getSecond());
            }
            catch (Throwable e) {
                Utils.sneakyThrow(e);
            }
            record.setResourceBundle(bundle);
            this.logger.log(record);
        }

        @Override
        public void log(J_L_System.Logger.Level level, ResourceBundle bundle, String format, Object ... args) {
            LogRecord record = new LogRecord(LoggerFinderImpl.getLevel(level), MessageFormat.format(format, args));
            try {
                Pair<Class<?>, String> caller = LoggerImpl.getCallerWithMethodName(MethodHandles.lookup());
                record.setSourceClassName(caller.getFirst().getName());
                record.setSourceMethodName(caller.getSecond());
            }
            catch (Throwable e) {
                Utils.sneakyThrow(e);
            }
            record.setResourceBundle(bundle);
            this.logger.log(record);
        }
    }
}

