/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_C_ConcurrentMap;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_DoubleSummaryStatistics;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_IntSummaryStatistics;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_LongSummaryStatistics;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_Map;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_Optional;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_StringJoiner;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BiConsumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BiFunction;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BinaryOperator;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Consumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Function;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Predicate;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Supplier;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_ToDoubleFunction;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_ToIntFunction;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_ToLongFunction;
import xyz.wagyourtail.jvmdg.j8.stub.stream.J_U_S_Collector;
import xyz.wagyourtail.jvmdg.util.Function;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/stream/Collectors")
public final class J_U_S_Collectors {
    private J_U_S_Collectors() {
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T, C extends Collection<T>> J_U_S_Collector<T, ?, C> toCollection(J_U_F_Supplier<C> collectionFactory) {
        return J_U_S_Collector.CollectorStatics.of(collectionFactory, new J_U_F_BiConsumer.BiConsumerAdapter<C, T>(){

            @Override
            public void accept(C collection, T t) {
                collection.add(t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<C>(){

            @Override
            public C apply(C o, C o2) {
                o.addAll(o2);
                return o;
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, List<T>> toList() {
        return J_U_S_Collectors.toCollection(new J_U_F_Supplier<List<T>>(){

            @Override
            public List<T> get() {
                return new ArrayList();
            }
        });
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, List<T>> toUnmodifiableList() {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<List<T>>(){

            @Override
            public List<T> get() {
                return new ArrayList();
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<List<T>, T>(){

            @Override
            public void accept(List<T> collection, T t) {
                collection.add(t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<List<T>>(){

            @Override
            public List<T> apply(List<T> o, List<T> o2) {
                o.addAll(o2);
                return o;
            }
        }, new J_U_F_Function.FunctionAdapter<List<T>, List<T>>(){

            @Override
            public List<T> apply(List<T> ts) {
                return Collections.unmodifiableList(ts);
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, Set<T>> toSet() {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<Set<T>>(){

            @Override
            public Set<T> get() {
                return new HashSet();
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<Set<T>, T>(){

            @Override
            public void accept(Set<T> collection, T t) {
                collection.add(t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<Set<T>>(){

            @Override
            public Set<T> apply(Set<T> o, Set<T> o2) {
                o.addAll(o2);
                return o;
            }
        }, J_U_S_Collector.Characteristics.UNORDERED);
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<Set<T>>(){

            @Override
            public Set<T> get() {
                return new HashSet();
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<Set<T>, T>(){

            @Override
            public void accept(Set<T> collection, T t) {
                collection.add(t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<Set<T>>(){

            @Override
            public Set<T> apply(Set<T> o, Set<T> o2) {
                o.addAll(o2);
                return o;
            }
        }, new J_U_F_Function.FunctionAdapter<Set<T>, Set<T>>(){

            @Override
            public Set<T> apply(Set<T> ts) {
                return Collections.unmodifiableSet(ts);
            }
        }, J_U_S_Collector.Characteristics.UNORDERED);
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static J_U_S_Collector<CharSequence, ?, String> joining() {
        return J_U_S_Collectors.joining("", "", "");
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static J_U_S_Collector<CharSequence, ?, String> joining(CharSequence delimiter) {
        return J_U_S_Collectors.joining(delimiter, "", "");
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static J_U_S_Collector<CharSequence, ?, String> joining(final CharSequence delimiter, final CharSequence prefix, final CharSequence suffix) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<J_U_StringJoiner>(){

            @Override
            public J_U_StringJoiner get() {
                return new J_U_StringJoiner(delimiter, prefix, suffix);
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<J_U_StringJoiner, CharSequence>(){

            @Override
            public void accept(J_U_StringJoiner jUStringJoiner, CharSequence charSequence) {
                jUStringJoiner.add(charSequence);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<J_U_StringJoiner>(){

            @Override
            public J_U_StringJoiner apply(J_U_StringJoiner jUStringJoiner, J_U_StringJoiner jUStringJoiner2) {
                jUStringJoiner.merge(jUStringJoiner2);
                return jUStringJoiner;
            }
        }, new J_U_F_Function.FunctionAdapter<J_U_StringJoiner, String>(){

            @Override
            public String apply(J_U_StringJoiner jUStringJoiner) {
                return jUStringJoiner.toString();
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T, U, A, R> J_U_S_Collector<T, ?, R> mapping(final J_U_F_Function<? super T, ? extends U> mapper, final J_U_S_Collector<? super U, A, R> downstream) {
        return new CollectorImpl(downstream.supplier(), new J_U_F_BiConsumer.BiConsumerAdapter<A, T>(){

            @Override
            public void accept(A a, T t) {
                downstream.accumulator().accept(a, mapper.apply(t));
            }
        }, downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T, A, R, RR> J_U_S_Collector<T, A, RR> collectingAndThen(J_U_S_Collector<T, A, R> downstream, J_U_F_Function<R, RR> andThen) {
        EnumSet<J_U_S_Collector.Characteristics> characteristics = downstream.characteristics().isEmpty() ? EnumSet.noneOf(J_U_S_Collector.Characteristics.class) : EnumSet.copyOf(downstream.characteristics());
        characteristics.remove((Object)J_U_S_Collector.Characteristics.IDENTITY_FINISH);
        return new CollectorImpl<T, A, RR>(downstream.supplier(), downstream.accumulator(), downstream.combiner(), downstream.finisher().andThen(andThen), Collections.unmodifiableSet(characteristics));
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, Long> counting() {
        return J_U_S_Collectors.summingLong(new J_U_F_ToLongFunction<T>(){

            @Override
            public long applyAsLong(T value) {
                return 1L;
            }
        });
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, J_U_Optional<T>> minBy(final Comparator<? super T> comparator) {
        return J_U_S_Collectors.reducing(new J_U_F_BinaryOperator.BinaryOperatorAdapter<T>(){

            @Override
            public T apply(T t, T t2) {
                return J_U_F_BinaryOperator.BinaryOperatorStatics.minBy(comparator).apply(t, t2);
            }
        });
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, J_U_Optional<T>> maxBy(final Comparator<? super T> comparator) {
        return J_U_S_Collectors.reducing(new J_U_F_BinaryOperator.BinaryOperatorAdapter<T>(){

            @Override
            public T apply(T t, T t2) {
                return J_U_F_BinaryOperator.BinaryOperatorStatics.maxBy(comparator).apply(t, t2);
            }
        });
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, Integer> summingInt(final J_U_F_ToIntFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<int[]>(){

            @Override
            public int[] get() {
                return new int[1];
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<int[], T>(){

            @Override
            public void accept(int[] ints, T t) {
                ints[0] = ints[0] + mapper.applyAsInt(t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<int[]>(){

            @Override
            public int[] apply(int[] ints, int[] ints2) {
                ints[0] = ints[0] + ints2[0];
                return ints;
            }
        }, new J_U_F_Function.FunctionAdapter<int[], Integer>(){

            @Override
            public Integer apply(int[] ints) {
                return ints[0];
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, Long> summingLong(final J_U_F_ToLongFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<long[]>(){

            @Override
            public long[] get() {
                return new long[1];
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<long[], T>(){

            @Override
            public void accept(long[] longs, T t) {
                longs[0] = longs[0] + mapper.applyAsLong(t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<long[]>(){

            @Override
            public long[] apply(long[] longs, long[] longs2) {
                longs[0] = longs[0] + longs2[0];
                return longs;
            }
        }, new J_U_F_Function.FunctionAdapter<long[], Long>(){

            @Override
            public Long apply(long[] longs) {
                return longs[0];
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    @Stub(ref=@Ref(value="java/util/stream/Collectors"))
    public static <T> J_U_S_Collector<T, ?, Double> summingDouble(final J_U_F_ToDoubleFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<double[]>(){

            @Override
            public double[] get() {
                return new double[1];
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<double[], T>(){

            @Override
            public void accept(double[] doubles, T t) {
                doubles[0] = doubles[0] + mapper.applyAsDouble(t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<double[]>(){

            @Override
            public double[] apply(double[] doubles, double[] doubles2) {
                doubles[0] = doubles[0] + doubles2[0];
                return doubles;
            }
        }, new J_U_F_Function.FunctionAdapter<double[], Double>(){

            @Override
            public Double apply(double[] longs) {
                return longs[0];
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T> J_U_S_Collector<T, ?, Double> averagingInt(final J_U_F_ToIntFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<long[]>(){

            @Override
            public long[] get() {
                return new long[2];
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<long[], T>(){

            @Override
            public void accept(long[] longs, T t) {
                longs[0] = longs[0] + (long)mapper.applyAsInt(t);
                longs[1] = longs[1] + 1L;
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<long[]>(){

            @Override
            public long[] apply(long[] longs, long[] longs2) {
                longs[0] = longs[0] + longs2[0];
                longs[1] = longs[1] + longs2[1];
                return longs;
            }
        }, new J_U_F_Function.FunctionAdapter<long[], Double>(){

            @Override
            public Double apply(long[] longs) {
                return longs[1] == 0L ? 0.0 : (double)longs[0] / (double)longs[1];
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T> J_U_S_Collector<T, ?, Double> averagingLong(final J_U_F_ToLongFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<long[]>(){

            @Override
            public long[] get() {
                return new long[2];
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<long[], T>(){

            @Override
            public void accept(long[] longs, T t) {
                longs[0] = longs[0] + mapper.applyAsLong(t);
                longs[1] = longs[1] + 1L;
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<long[]>(){

            @Override
            public long[] apply(long[] longs, long[] longs2) {
                longs[0] = longs[0] + longs2[0];
                longs[1] = longs[1] + longs2[1];
                return longs;
            }
        }, new J_U_F_Function.FunctionAdapter<long[], Double>(){

            @Override
            public Double apply(long[] longs) {
                return longs[1] == 0L ? 0.0 : (double)longs[0] / (double)longs[1];
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    static double[] sumWithCompensation(double[] intermediateSum, double value) {
        double tmp = value - intermediateSum[1];
        double sum = intermediateSum[0];
        double velvel = sum + tmp;
        intermediateSum[1] = velvel - sum - tmp;
        intermediateSum[0] = velvel;
        return intermediateSum;
    }

    static double computeFinalSum(double[] summands) {
        double tmp = summands[0] - summands[1];
        double simpleSum = summands[summands.length - 1];
        if (Double.isNaN(tmp) && Double.isInfinite(simpleSum)) {
            return simpleSum;
        }
        return tmp;
    }

    public static <T> J_U_S_Collector<T, ?, Double> averagingDouble(final J_U_F_ToDoubleFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<double[]>(){

            @Override
            public double[] get() {
                return new double[4];
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<double[], T>(){

            @Override
            public void accept(double[] doubles, T t) {
                double val = mapper.applyAsDouble(t);
                J_U_S_Collectors.sumWithCompensation(doubles, val);
                doubles[2] = doubles[2] + 1.0;
                doubles[3] = doubles[3] + val;
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<double[]>(){

            @Override
            public double[] apply(double[] doubles, double[] doubles2) {
                J_U_S_Collectors.sumWithCompensation(doubles, doubles2[0]);
                J_U_S_Collectors.sumWithCompensation(doubles, -doubles2[1]);
                doubles[2] = doubles[2] + doubles2[2];
                doubles[3] = doubles[3] + doubles2[3];
                return doubles;
            }
        }, new J_U_F_Function.FunctionAdapter<double[], Double>(){

            @Override
            public Double apply(double[] doubles) {
                return doubles[2] == 0.0 ? 0.0 : J_U_S_Collectors.computeFinalSum(doubles) / doubles[2];
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T> J_U_S_Collector<T, ?, T> reducing(T identity, final J_U_F_BinaryOperator<T> op) {
        return J_U_S_Collector.CollectorStatics.of(J_U_S_Collectors.boxSupplier(identity), new J_U_F_BiConsumer.BiConsumerAdapter<T[], T>(){

            @Override
            public void accept(T[] ts, T t) {
                ts[0] = op.apply(ts[0], t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<T[]>(){

            @Override
            public T[] apply(T[] ts, T[] ts2) {
                ts[0] = op.apply(ts[0], ts2[0]);
                return ts;
            }
        }, new J_U_F_Function.FunctionAdapter<T[], T>(){

            @Override
            public T apply(T[] ts) {
                return ts[0];
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    private static <T> J_U_F_Supplier<T[]> boxSupplier(final T in) {
        return new J_U_F_Supplier<T[]>(){

            @Override
            public T[] get() {
                return new Object[]{in};
            }
        };
    }

    public static <T> J_U_S_Collector<T, ?, J_U_Optional<T>> reducing(final J_U_F_BinaryOperator<T> op) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<1OptionalBox>(){

            @Override
            public 1OptionalBox get() {
                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                class OptionalBox
                implements J_U_F_Consumer<T> {
                    T value = null;
                    boolean present = false;
                    final /* synthetic */ J_U_F_BinaryOperator val$op;

                    OptionalBox(J_U_F_BinaryOperator j_U_F_BinaryOperator) {
                        this.val$op = j_U_F_BinaryOperator;
                    }

                    @Override
                    public void accept(T t) {
                        if (this.present) {
                            this.value = this.val$op.apply(this.value, t);
                        } else {
                            this.value = t;
                            this.present = true;
                        }
                    }

                    @Override
                    public J_U_F_Consumer<T> andThen(J_U_F_Consumer<? super T> after) {
                        return J_U_F_Consumer.ConsumerDefaults.andThen(this, after);
                    }
                }
                return new OptionalBox(op);
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<1OptionalBox, T>(){

            @Override
            public void accept(1OptionalBox optionalBox, T t) {
                optionalBox.accept(t);
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<1OptionalBox>(){

            @Override
            public 1OptionalBox apply(1OptionalBox optionalBox, 1OptionalBox optionalBox2) {
                if (optionalBox2.present) {
                    optionalBox.accept(optionalBox2.value);
                }
                return optionalBox;
            }
        }, new J_U_F_Function.FunctionAdapter<1OptionalBox, J_U_Optional<T>>(){

            @Override
            public J_U_Optional<T> apply(1OptionalBox optionalBox) {
                return J_U_Optional.ofNullable(optionalBox.value);
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T, U> J_U_S_Collector<T, ?, U> reducing(U identity, final J_U_F_Function<? super T, ? extends U> mapper, final J_U_F_BinaryOperator<U> op) {
        return J_U_S_Collector.CollectorStatics.of(J_U_S_Collectors.boxSupplier(identity), new J_U_F_BiConsumer.BiConsumerAdapter<U[], T>(){

            @Override
            public void accept(U[] us, T t) {
                us[0] = op.apply(us[0], mapper.apply(t));
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<U[]>(){

            @Override
            public U[] apply(U[] us, U[] us2) {
                us[0] = op.apply(us[0], us2[0]);
                return us;
            }
        }, new J_U_F_Function.FunctionAdapter<U[], U>(){

            @Override
            public U apply(U[] us) {
                return us[0];
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T, K> J_U_S_Collector<T, ?, Map<K, List<T>>> groupingBy(J_U_F_Function<? super T, ? extends K> classifier) {
        return J_U_S_Collectors.groupingBy(classifier, J_U_S_Collectors.toList());
    }

    public static <T, K, A, D> J_U_S_Collector<T, ?, Map<K, D>> groupingBy(J_U_F_Function<? super T, ? extends K> classifier, J_U_S_Collector<? super T, A, D> downstream) {
        return J_U_S_Collectors.groupingBy(classifier, new J_U_F_Supplier<Map<K, D>>(){

            @Override
            public Map<K, D> get() {
                return new HashMap();
            }
        }, downstream);
    }

    private static <K, V, M extends Map<K, V>> J_U_F_BinaryOperator<M> mapMerger(final J_U_F_BinaryOperator<V> mergeFunction) {
        return new J_U_F_BinaryOperator.BinaryOperatorAdapter<M>(){

            @Override
            public M apply(M m1, M m2) {
                for (Map.Entry e : m2.entrySet()) {
                    J_U_Map.merge(m1, e.getKey(), e.getValue(), mergeFunction);
                }
                return m1;
            }
        };
    }

    public static <T, K, D, A, M extends Map<K, D>> J_U_S_Collector<T, ?, M> groupingBy(final J_U_F_Function<? super T, ? extends K> classifier, J_U_F_Supplier<M> mapFactory, J_U_S_Collector<? super T, A, D> downstream) {
        final J_U_F_Supplier<A> downstreamSupplier = downstream.supplier();
        final J_U_F_BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        J_U_F_BiConsumer.BiConsumerAdapter accumulator = new J_U_F_BiConsumer.BiConsumerAdapter<Map<K, A>, T>(){

            @Override
            public void accept(Map<K, A> m, T t) {
                Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
                if (!m.containsKey(key)) {
                    m.put(key, downstreamSupplier.get());
                }
                downstreamAccumulator.accept(m.get(key), t);
            }
        };
        J_U_F_BinaryOperator<M> merger = J_U_S_Collectors.mapMerger(downstream.combiner());
        J_U_F_Supplier<M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)J_U_S_Collector.Characteristics.IDENTITY_FINISH)) {
            return J_U_S_Collector.CollectorStatics.of(mangledFactory, accumulator, merger, new J_U_S_Collector.Characteristics[0]);
        }
        final J_U_F_Function<A, D> downstreamFinisher = downstream.finisher();
        J_U_F_Function.FunctionAdapter finisher = new J_U_F_Function.FunctionAdapter<Map<K, A>, M>(){

            @Override
            public M apply(Map<K, A> intermediate) {
                J_U_Map.replaceAll(intermediate, new J_U_F_BiFunction.BiFunctionAdapter<K, A, A>(){

                    @Override
                    public A apply(K k, A a) {
                        return downstreamFinisher.apply(a);
                    }
                });
                Map castResult = intermediate;
                return castResult;
            }
        };
        return J_U_S_Collector.CollectorStatics.of(mangledFactory, accumulator, merger, finisher, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T, K> J_U_S_Collector<T, ?, ConcurrentMap<K, List<T>>> groupingByConcurrent(Function<? super T, ? extends K> classifier) {
        return J_U_S_Collectors.groupingByConcurrent(classifier, J_U_S_Collectors.toList());
    }

    public static <T, K, A, D> J_U_S_Collector<T, ?, ConcurrentMap<K, D>> groupingByConcurrent(Function<? super T, ? extends K> classifier, J_U_S_Collector<? super T, A, D> downstream) {
        return J_U_S_Collectors.groupingByConcurrent(classifier, new J_U_F_Supplier<ConcurrentMap<K, D>>(){

            @Override
            public ConcurrentMap<K, D> get() {
                return new ConcurrentHashMap();
            }
        }, downstream);
    }

    public static <T, K, D, A, M extends ConcurrentMap<K, D>> J_U_S_Collector<T, ?, M> groupingByConcurrent(final Function<? super T, ? extends K> classifier, J_U_F_Supplier<M> mapFactory, J_U_S_Collector<? super T, A, D> downstream) {
        final J_U_F_Supplier<A> downstreamSupplier = downstream.supplier();
        final J_U_F_BiConsumer<A, ? super T> downstreamAccumulator = downstream.accumulator();
        J_U_F_BinaryOperator<M> merger = J_U_S_Collectors.mapMerger(downstream.combiner());
        J_U_F_Supplier<M> mangledFactory = mapFactory;
        J_U_F_BiConsumer.BiConsumerAdapter accumulator = downstream.characteristics().contains((Object)J_U_S_Collector.Characteristics.CONCURRENT) ? new J_U_F_BiConsumer.BiConsumerAdapter<ConcurrentMap<K, A>, T>(){

            @Override
            public void accept(ConcurrentMap<K, A> kaConcurrentMap, T t) {
                Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
                Object container = J_U_C_ConcurrentMap.computeIfAbsent(kaConcurrentMap, key, new J_U_F_Function.FunctionAdapter<K, A>(){

                    @Override
                    public A apply(K k) {
                        return downstreamSupplier.get();
                    }
                });
                downstreamAccumulator.accept(container, t);
            }
        } : new J_U_F_BiConsumer.BiConsumerAdapter<ConcurrentMap<K, A>, T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(ConcurrentMap<K, A> kaConcurrentMap, T t) {
                Object container;
                Object key = Objects.requireNonNull(classifier.apply(t), "element cannot be mapped to a null key");
                Object a = container = J_U_C_ConcurrentMap.computeIfAbsent(kaConcurrentMap, key, new J_U_F_Function.FunctionAdapter<K, A>(){

                    @Override
                    public A apply(K k) {
                        return downstreamSupplier.get();
                    }
                });
                synchronized (a) {
                    downstreamAccumulator.accept(container, t);
                }
            }
        };
        if (downstream.characteristics().contains((Object)J_U_S_Collector.Characteristics.IDENTITY_FINISH)) {
            return J_U_S_Collector.CollectorStatics.of(mangledFactory, accumulator, merger, J_U_S_Collector.Characteristics.CONCURRENT);
        }
        final J_U_F_Function<A, D> downstreamFinisher = downstream.finisher();
        J_U_F_Function.FunctionAdapter finisher = new J_U_F_Function.FunctionAdapter<ConcurrentMap<K, A>, M>(){

            @Override
            public M apply(ConcurrentMap<K, A> kaConcurrentMap) {
                J_U_C_ConcurrentMap.replaceAll(kaConcurrentMap, new J_U_F_BiFunction.BiFunctionAdapter<K, A, A>(){

                    @Override
                    public A apply(K k, A a) {
                        return downstreamFinisher.apply(a);
                    }
                });
                return kaConcurrentMap;
            }
        };
        return J_U_S_Collector.CollectorStatics.of(mangledFactory, accumulator, merger, finisher, J_U_S_Collector.Characteristics.CONCURRENT);
    }

    public static <T> J_U_S_Collector<T, ?, Map<Boolean, List<T>>> partitioningBy(J_U_F_Predicate<? super T> predicate) {
        return J_U_S_Collectors.partitioningBy(predicate, J_U_S_Collectors.toList());
    }

    public static <T, D, A> J_U_S_Collector<T, ?, Map<Boolean, D>> partitioningBy(final J_U_F_Predicate<? super T> predicate, J_U_S_Collector<? super T, A, D> downstream) {
        return J_U_S_Collectors.groupingBy(new J_U_F_Function.FunctionAdapter<T, Boolean>(){

            @Override
            public Boolean apply(T t) {
                return predicate.test(t);
            }
        }, downstream);
    }

    private static <T, K, V> J_U_F_BiConsumer<Map<K, V>, T> uniqKeyMapAccumulator(final J_U_F_Function<? super T, ? extends K> keyMapper, final J_U_F_Function<? super T, ? extends V> valueMapper) {
        return new J_U_F_BiConsumer.BiConsumerAdapter<Map<K, V>, T>(){

            @Override
            public void accept(Map<K, V> kvMap, T t) {
                Object v;
                Object k = keyMapper.apply(t);
                Object old = J_U_Map.putIfAbsent(kvMap, k, v = Objects.requireNonNull(valueMapper.apply(t)));
                if (old != null) {
                    throw new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", k, old, v));
                }
            }
        };
    }

    private static <K, V, M extends Map<K, V>> J_U_F_BinaryOperator<M> uniqKeysMapMerger() {
        return new J_U_F_BinaryOperator.BinaryOperatorAdapter<M>(){

            @Override
            public M apply(M m, M m2) {
                for (Map.Entry e : m2.entrySet()) {
                    Object v;
                    Object k = e.getKey();
                    Object old = J_U_Map.putIfAbsent(m, k, v = Objects.requireNonNull(e.getValue()));
                    if (old == null) continue;
                    throw new IllegalStateException(String.format("Duplicate key %s (attempted merging values %s and %s)", k, old, v));
                }
                return m;
            }
        };
    }

    public static <T, K, U> J_U_S_Collector<T, ?, Map<K, U>> toMap(J_U_F_Function<? super T, ? extends K> keyMapper, J_U_F_Function<? super T, ? extends U> valueMapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<Map<K, U>>(){

            @Override
            public Map<K, U> get() {
                return new HashMap();
            }
        }, J_U_S_Collectors.uniqKeyMapAccumulator(keyMapper, valueMapper), J_U_S_Collectors.uniqKeysMapMerger(), new J_U_S_Collector.Characteristics[0]);
    }

    public static <T, K, U> J_U_S_Collector<T, ?, Map<K, U>> toUnmodifiableMap(J_U_F_Function<? super T, ? extends K> keyMapper, J_U_F_Function<? super T, ? extends U> valueMapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<Map<K, U>>(){

            @Override
            public Map<K, U> get() {
                return new HashMap();
            }
        }, J_U_S_Collectors.uniqKeyMapAccumulator(keyMapper, valueMapper), J_U_S_Collectors.uniqKeysMapMerger(), new J_U_F_Function.FunctionAdapter<Map<K, U>, Map<K, U>>(){

            @Override
            public Map<K, U> apply(Map<K, U> kuMap) {
                return Collections.unmodifiableMap(kuMap);
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T, K, U> J_U_S_Collector<T, ?, Map<K, U>> toMap(J_U_F_Function<? super T, ? extends K> keyMapper, J_U_F_Function<? super T, ? extends U> valueMapper, J_U_F_BinaryOperator<U> mergeFunction) {
        return J_U_S_Collectors.toMap(keyMapper, valueMapper, mergeFunction, new J_U_F_Supplier<Map<K, U>>(){

            @Override
            public Map<K, U> get() {
                return new HashMap();
            }
        });
    }

    public static <T, K, U> J_U_S_Collector<T, ?, Map<K, U>> toUnmodifiableMap(J_U_F_Function<? super T, ? extends K> keyMapper, J_U_F_Function<? super T, ? extends U> valueMapper, J_U_F_BinaryOperator<U> mergeFunction) {
        Objects.requireNonNull(keyMapper, "keyMapper");
        Objects.requireNonNull(valueMapper, "valueMapper");
        Objects.requireNonNull(mergeFunction, "mergeFunction");
        return J_U_S_Collectors.collectingAndThen(J_U_S_Collectors.toMap(keyMapper, valueMapper, mergeFunction), new J_U_F_Function.FunctionAdapter<Map<K, U>, Map<K, U>>(){

            @Override
            public Map<K, U> apply(Map<K, U> kuMap) {
                return Collections.unmodifiableMap(kuMap);
            }
        });
    }

    public static <T, K, U, M extends Map<K, U>> J_U_S_Collector<T, ?, M> toMap(J_U_F_Function<? super T, ? extends K> keyMapper, J_U_F_Function<? super T, ? extends U> valueMapper, J_U_F_BinaryOperator<U> mergeFunction, J_U_F_Supplier<M> mapSupplier) {
        return J_U_S_Collector.CollectorStatics.of(mapSupplier, J_U_S_Collectors.uniqKeyMapAccumulator(keyMapper, valueMapper), J_U_S_Collectors.mapMerger(mergeFunction), new J_U_S_Collector.Characteristics[0]);
    }

    public static <T, K, U> J_U_S_Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(J_U_F_Function<? super T, ? extends K> keyMapper, J_U_F_Function<? super T, ? extends U> valueMapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<Map<K, U>>(){

            @Override
            public Map<K, U> get() {
                return new ConcurrentHashMap();
            }
        }, J_U_S_Collectors.uniqKeyMapAccumulator(keyMapper, valueMapper), J_U_S_Collectors.uniqKeysMapMerger(), J_U_S_Collector.Characteristics.CONCURRENT);
    }

    public static <T, K, U> J_U_S_Collector<T, ?, ConcurrentMap<K, U>> toConcurrentMap(J_U_F_Function<? super T, ? extends K> keyMapper, J_U_F_Function<? super T, ? extends U> valueMapper, J_U_F_BinaryOperator<U> mergeFunction) {
        return J_U_S_Collectors.toConcurrentMap(keyMapper, valueMapper, mergeFunction, new J_U_F_Supplier<ConcurrentMap<K, U>>(){

            @Override
            public ConcurrentMap<K, U> get() {
                return new ConcurrentHashMap();
            }
        });
    }

    public static <T, K, U, M extends ConcurrentMap<K, U>> J_U_S_Collector<T, ?, M> toConcurrentMap(J_U_F_Function<? super T, ? extends K> keyMapper, J_U_F_Function<? super T, ? extends U> valueMapper, J_U_F_BinaryOperator<U> mergeFunction, J_U_F_Supplier<M> mapSupplier) {
        return J_U_S_Collector.CollectorStatics.of(mapSupplier, J_U_S_Collectors.uniqKeyMapAccumulator(keyMapper, valueMapper), J_U_S_Collectors.mapMerger(mergeFunction), J_U_S_Collector.Characteristics.CONCURRENT);
    }

    public static <T> J_U_S_Collector<T, ?, J_U_IntSummaryStatistics> summarizingInt(final J_U_F_ToIntFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<J_U_IntSummaryStatistics>(){

            @Override
            public J_U_IntSummaryStatistics get() {
                return new J_U_IntSummaryStatistics();
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<J_U_IntSummaryStatistics, T>(){

            @Override
            public void accept(J_U_IntSummaryStatistics jUIntSummaryStatistics, T t) {
                jUIntSummaryStatistics.accept(mapper.applyAsInt(t));
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<J_U_IntSummaryStatistics>(){

            @Override
            public J_U_IntSummaryStatistics apply(J_U_IntSummaryStatistics jUIntSummaryStatistics, J_U_IntSummaryStatistics jUIntSummaryStatistics2) {
                jUIntSummaryStatistics.combine(jUIntSummaryStatistics2);
                return jUIntSummaryStatistics;
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T> J_U_S_Collector<T, ?, J_U_LongSummaryStatistics> summarizingLong(final J_U_F_ToLongFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<J_U_LongSummaryStatistics>(){

            @Override
            public J_U_LongSummaryStatistics get() {
                return new J_U_LongSummaryStatistics();
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<J_U_LongSummaryStatistics, T>(){

            @Override
            public void accept(J_U_LongSummaryStatistics jUIntSummaryStatistics, T t) {
                jUIntSummaryStatistics.accept(mapper.applyAsLong(t));
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<J_U_LongSummaryStatistics>(){

            @Override
            public J_U_LongSummaryStatistics apply(J_U_LongSummaryStatistics jUIntSummaryStatistics, J_U_LongSummaryStatistics jUIntSummaryStatistics2) {
                jUIntSummaryStatistics.combine(jUIntSummaryStatistics2);
                return jUIntSummaryStatistics;
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    public static <T> J_U_S_Collector<T, ?, J_U_DoubleSummaryStatistics> summarizingDouble(final J_U_F_ToDoubleFunction<? super T> mapper) {
        return J_U_S_Collector.CollectorStatics.of(new J_U_F_Supplier<J_U_DoubleSummaryStatistics>(){

            @Override
            public J_U_DoubleSummaryStatistics get() {
                return new J_U_DoubleSummaryStatistics();
            }
        }, new J_U_F_BiConsumer.BiConsumerAdapter<J_U_DoubleSummaryStatistics, T>(){

            @Override
            public void accept(J_U_DoubleSummaryStatistics jUIntSummaryStatistics, T t) {
                jUIntSummaryStatistics.accept(mapper.applyAsDouble(t));
            }
        }, new J_U_F_BinaryOperator.BinaryOperatorAdapter<J_U_DoubleSummaryStatistics>(){

            @Override
            public J_U_DoubleSummaryStatistics apply(J_U_DoubleSummaryStatistics jUIntSummaryStatistics, J_U_DoubleSummaryStatistics jUIntSummaryStatistics2) {
                jUIntSummaryStatistics.combine(jUIntSummaryStatistics2);
                return jUIntSummaryStatistics;
            }
        }, new J_U_S_Collector.Characteristics[0]);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class CollectorImpl<T, A, R>
    implements J_U_S_Collector<T, A, R> {
        private final J_U_F_Supplier<A> supplier;
        private final J_U_F_BiConsumer<A, T> accumulator;
        private final J_U_F_BinaryOperator<A> combiner;
        private final J_U_F_Function<A, R> finisher;
        private final Set<J_U_S_Collector.Characteristics> characteristics;

        public CollectorImpl(J_U_F_Supplier<A> supplier, J_U_F_BiConsumer<A, T> accumulator, J_U_F_BinaryOperator<A> combiner, Set<J_U_S_Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = new J_U_F_Function.FunctionAdapter<A, R>(){

                @Override
                public R apply(A a) {
                    return a;
                }
            };
            this.characteristics = characteristics;
        }

        public CollectorImpl(J_U_F_Supplier<A> supplier, J_U_F_BiConsumer<A, T> accumulator, J_U_F_BinaryOperator<A> combiner, J_U_F_Function<A, R> finisher, Set<J_U_S_Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        @Override
        public J_U_F_Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public J_U_F_BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public J_U_F_BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public J_U_F_Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<J_U_S_Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

