/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.util.NoSuchElementException;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_LongConsumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_LongSupplier;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Supplier;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/Optionallong")
public class J_U_OptionalLong {
    private static final J_U_OptionalLong EMPTY = new J_U_OptionalLong();
    private final boolean isPresent;
    private final long value;

    private J_U_OptionalLong() {
        this.isPresent = false;
        this.value = 0L;
    }

    private J_U_OptionalLong(long value) {
        this.isPresent = true;
        this.value = value;
    }

    public static J_U_OptionalLong empty() {
        return EMPTY;
    }

    public static J_U_OptionalLong of(long value) {
        return new J_U_OptionalLong(value);
    }

    public long getAslong() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(J_U_F_LongConsumer action) {
        if (this.isPresent) {
            action.accept(this.value);
        }
    }

    public long orElse(long other) {
        return this.isPresent ? this.value : other;
    }

    public long orElseGet(J_U_F_LongSupplier supplier) {
        return this.isPresent ? this.value : supplier.getAsLong();
    }

    public long orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> long orElseThrow(J_U_F_Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof J_U_OptionalLong)) {
            return false;
        }
        J_U_OptionalLong other = (J_U_OptionalLong)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? (int)(this.value ^ this.value >>> 32) : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalLong[%s]", this.value) : "OptionalLong.empty";
    }
}

