/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_C_ConcurrentMap;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BiConsumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_BiFunction;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Function;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_U_Map {
    @Stub(ref=@Ref(value="java/util/Map"))
    public static <K extends Comparable<? super K>, V> Comparator<Map.Entry<K, V>> comparingByKey() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getKey()).compareTo(o2.getKey());
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Map"))
    public static <K, V extends Comparable<? super V>> Comparator<Map.Entry<K, V>> comparingByValue() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Map"))
    public static <K, V> Comparator<Map.Entry<K, V>> comparingByKey(final Comparator<? super K> cmp) {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return cmp.compare(o1.getKey(), o2.getKey());
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Map"))
    public static <K, V> Comparator<Map.Entry<K, V>> comparingByValue(final Comparator<? super V> cmp) {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return cmp.compare(o1.getValue(), o2.getValue());
            }
        };
    }

    @Stub
    public static <K, V> V getOrDefault(Map<K, V> self, Object key, V defaultValue) {
        if (self instanceof ConcurrentMap) {
            return J_U_C_ConcurrentMap.getOrDefault((ConcurrentMap)self, key, defaultValue);
        }
        V v = self.get(key);
        return v != null || self.containsKey(key) ? v : defaultValue;
    }

    @Stub
    public static <K, V> void forEach(Map<K, V> self, J_U_F_BiConsumer<? super K, ? super V> action) {
        if (self instanceof ConcurrentMap) {
            J_U_C_ConcurrentMap.forEach((ConcurrentMap)self, action);
            return;
        }
        Iterator<Map.Entry<K, V>> i$ = self.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<K, V> entry;
            V v = entry.getValue();
            entry = i$.next();
            K k = entry.getKey();
            action.accept(k != null ? k : null, v != null ? v : null);
        }
    }

    @Stub
    public static <T, U> void replaceAll(Map<T, U> self, J_U_F_BiFunction<T, U, U> function) {
        if (self instanceof ConcurrentMap) {
            J_U_C_ConcurrentMap.replaceAll((ConcurrentMap)self, function);
            return;
        }
        Iterator<Map.Entry<T, U>> i$ = self.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<T, U> entry;
            U v = entry.getValue();
            T k = (entry = i$.next()).getKey();
            entry.setValue(function.apply(k != null ? k : null, v != null ? v : null));
        }
    }

    @Stub
    public static <K, V> V putIfAbsent(Map<K, V> self, K key, V value) {
        V v = self.get(key);
        if (v == null) {
            v = self.put(key, value);
        }
        return v;
    }

    @Stub
    public static <K, V> boolean remove(Map<K, V> self, K key, V value) {
        if (self instanceof ConcurrentMap) {
            return J_U_C_ConcurrentMap.remove((ConcurrentMap)self, key, value);
        }
        V curValue = self.get(key);
        if (!Objects.equals(curValue, value) || curValue == null && !self.containsKey(key)) {
            return false;
        }
        self.remove(key);
        return true;
    }

    @Stub
    public static <K, V> boolean replace(Map<K, V> self, K key, V oldValue, V newValue) {
        if (self instanceof ConcurrentMap) {
            return J_U_C_ConcurrentMap.replace((ConcurrentMap)self, key, oldValue, newValue);
        }
        V curValue = self.get(key);
        if (!Objects.equals(curValue, oldValue) || curValue == null && !self.containsKey(key)) {
            return false;
        }
        self.put(key, newValue);
        return true;
    }

    @Stub
    public static <K, V> V replace(Map<K, V> self, K key, V value) {
        if (self instanceof ConcurrentMap) {
            return J_U_C_ConcurrentMap.replace((ConcurrentMap)self, key, value);
        }
        V curValue = self.get(key);
        if (curValue != null || self.containsKey(key)) {
            curValue = self.put(key, value);
        }
        return curValue;
    }

    @Stub
    public static <K, V> V computeIfAbsent(Map<K, V> self, K key, J_U_F_Function<? super K, ? extends V> mappingFunction) {
        V newValue;
        if (self instanceof ConcurrentMap) {
            return J_U_C_ConcurrentMap.computeIfAbsent((ConcurrentMap)self, key, mappingFunction);
        }
        V v = self.get(key);
        if (v == null && (newValue = mappingFunction.apply(key)) != null) {
            self.put(key, newValue);
            return newValue;
        }
        return v;
    }

    @Stub
    public static <K, V> V computeIfPresent(Map<K, V> self, K key, J_U_F_BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (self instanceof ConcurrentMap) {
            return J_U_C_ConcurrentMap.computeIfPresent((ConcurrentMap)self, key, remappingFunction);
        }
        V oldValue = self.get(key);
        if (oldValue != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                self.put(key, newValue);
                return newValue;
            }
            self.remove(key);
            return null;
        }
        return null;
    }

    @Stub
    public static <K, V> V compute(Map<K, V> self, K key, J_U_F_BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (self instanceof ConcurrentMap) {
            return J_U_C_ConcurrentMap.compute((ConcurrentMap)self, key, remappingFunction);
        }
        V oldValue = self.get(key);
        V newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            if (oldValue != null || self.containsKey(key)) {
                self.remove(key);
            }
            return null;
        }
        self.put(key, newValue);
        return newValue;
    }

    @Stub
    public static <K, V> V merge(Map<K, V> self, K key, V value, J_U_F_BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        if (self instanceof ConcurrentMap) {
            return J_U_C_ConcurrentMap.merge((ConcurrentMap)self, key, value, remappingFunction);
        }
        V oldValue = self.get(key);
        V v = newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        if (newValue == null) {
            self.remove(key);
        } else {
            self.put(key, newValue);
        }
        return newValue;
    }
}

