/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_IntConsumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_LongConsumer;
import xyz.wagyourtail.jvmdg.version.Adapter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/LongSummaryStatistics")
public class J_U_LongSummaryStatistics
implements J_U_F_IntConsumer,
J_U_F_LongConsumer {
    private long count;
    private long sum;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    @Override
    public void accept(int value) {
        this.accept((long)value);
    }

    public void combine(J_U_LongSummaryStatistics other) {
        this.count += other.count;
        this.sum += other.sum;
        this.min = Math.min(this.min, other.min);
        this.max = Math.max(this.max, other.max);
    }

    public final long getCount() {
        return this.count;
    }

    public final long getSum() {
        return this.sum;
    }

    public final long getMin() {
        return this.min;
    }

    public final long getMax() {
        return this.max;
    }

    public final double getAverage() {
        return this.getCount() > 0L ? (double)this.getSum() / (double)this.getCount() : 0.0;
    }

    public String toString() {
        return "IntSummaryStatistics{count=" + this.count + ", sum=" + this.sum + ", min=" + this.min + ", max=" + this.max + '}';
    }

    @Override
    public J_U_F_IntConsumer andThen(J_U_F_IntConsumer after) {
        return J_U_F_IntConsumer.IntConsumerDefaults.andThen(this, after);
    }

    @Override
    public void accept(long value) {
        ++this.count;
        this.sum += value;
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
    }

    @Override
    public J_U_F_LongConsumer andThen(J_U_F_LongConsumer after) {
        return J_U_F_LongConsumer.LongConsumerDefaults.andThen(this, after);
    }
}

