/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Function;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_ToDoubleFunction;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_ToIntFunction;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_ToLongFunction;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_U_Comparator {
    @Stub
    public static <T> Comparator<T> reversed(Comparator<T> self) {
        return Collections.reverseOrder(self);
    }

    @Stub
    public static <T> Comparator<T> thenComparing(final Comparator<T> self, final Comparator<? super T> other) {
        Objects.requireNonNull(other);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int res = self.compare(o1, o2);
                return res != 0 ? res : other.compare(o1, o2);
            }
        };
    }

    @Stub
    public static <T> Comparator<T> thenComparing(Comparator<T> self, J_U_F_Function<? super T, ? extends T> keyExtractor, Comparator<? super T> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return J_U_Comparator.thenComparing(self, J_U_Comparator.comparing(keyExtractor, keyComparator));
    }

    @Stub
    public static <T, U extends Comparable<? super U>> Comparator<T> comparing(Comparator<T> self, J_U_F_Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return J_U_Comparator.thenComparing(self, J_U_Comparator.comparing(keyExtractor));
    }

    @Stub
    public static <T> Comparator<T> thenComparingInt(Comparator<T> self, J_U_F_ToIntFunction keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return J_U_Comparator.thenComparing(self, J_U_Comparator.comparingInt(keyExtractor));
    }

    @Stub
    public static <T> Comparator<T> thenComparingLong(Comparator<T> self, J_U_F_ToLongFunction keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return J_U_Comparator.thenComparing(self, J_U_Comparator.comparingLong(keyExtractor));
    }

    @Stub
    public static <T> Comparator<T> thenComparingDouble(Comparator<T> self, J_U_F_ToDoubleFunction keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return J_U_Comparator.thenComparing(self, J_U_Comparator.comparingDouble(keyExtractor));
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T> Comparator<T> reverseOrder() {
        return Collections.reverseOrder();
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T> Comparator<T> naturalOrder() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T> Comparator<T> nullsFirst(final Comparator<T> comparator) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return comparator.compare(o1, o2);
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T> Comparator<T> nullsLast(final Comparator<T> comparator) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null) {
                    return o2 == null ? 0 : 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return comparator.compare(o1, o2);
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T, U> Comparator<T> comparing(final J_U_F_Function<? super T, ? extends U> keyExtractor, final Comparator<? super U> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return keyComparator.compare(keyExtractor.apply(o1), keyExtractor.apply(o2));
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T, U extends Comparable<? super U>> Comparator<T> comparing(final J_U_F_Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Comparable)keyExtractor.apply(o1)).compareTo(keyExtractor.apply(o2));
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T> Comparator<T> comparingInt(final J_U_F_ToIntFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Integer.compare(keyExtractor.applyAsInt(o1), keyExtractor.applyAsInt(o2));
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T> Comparator<T> comparingLong(final J_U_F_ToLongFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Long.compare(keyExtractor.applyAsLong(o1), keyExtractor.applyAsLong(o2));
            }
        };
    }

    @Stub(ref=@Ref(value="java/util/Comparator"))
    public static <T> Comparator<T> comparingDouble(final J_U_F_ToDoubleFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Double.compare(keyExtractor.applyAsDouble(o1), keyExtractor.applyAsDouble(o2));
            }
        };
    }
}

