/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.stub;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import xyz.wagyourtail.jvmdg.j8.stub.J_L_R_Type;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Class {
    @Stub
    public static String toGenericString(Class<?> clazz) {
        int i;
        if (clazz.isPrimitive()) {
            return clazz.toString();
        }
        StringBuilder sb = new StringBuilder();
        Class<?> component = clazz;
        int arrayDepth = 0;
        if (clazz.isArray()) {
            do {
                ++arrayDepth;
            } while ((component = component.getComponentType()).isArray());
            sb.append(component.getName());
        } else {
            int modifiers = clazz.getModifiers() & Modifier.classModifiers();
            if (modifiers != 0) {
                sb.append(Modifier.toString(modifiers));
                sb.append(' ');
            }
            if (clazz.isAnnotation()) {
                sb.append('@');
            }
            if (clazz.isInterface()) {
                sb.append("interface");
            } else if (clazz.isEnum()) {
                sb.append("enum");
            } else {
                sb.append("class");
            }
            sb.append(' ');
            sb.append(clazz.getName());
        }
        TypeVariable<Class<?>>[] typeparms = component.getTypeParameters();
        if (typeparms.length > 0) {
            sb.append('<');
            for (i = 0; i < typeparms.length; ++i) {
                sb.append(J_L_Class.typeVarBounds(typeparms[i]));
                if (i >= typeparms.length - 1) continue;
                sb.append(',');
            }
            sb.append('>');
        }
        if (arrayDepth > 0) {
            for (i = 0; i < arrayDepth; ++i) {
                sb.append("[]");
            }
        }
        return sb.toString();
    }

    private static String typeVarBounds(TypeVariable<?> typeVar) {
        Type[] bounds = typeVar.getBounds();
        if (bounds.length == 1 && bounds[0].equals(Object.class)) {
            return typeVar.getName();
        }
        StringBuilder sb = new StringBuilder(typeVar.getName()).append(" extends ");
        for (int i = 0; i < bounds.length; ++i) {
            sb.append(bounds[i] instanceof Class ? J_L_Class.getTypeName((Class)bounds[i]) : J_L_R_Type.getTypeName(bounds[i]));
            if (i >= bounds.length - 1) continue;
            sb.append(" & ");
        }
        return sb.toString();
    }

    @Stub
    public static String getTypeName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> cl = clazz;
                int dimensions = 0;
                do {
                    ++dimensions;
                } while ((cl = cl.getComponentType()).isArray());
                StringBuilder sb = new StringBuilder(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }

    @Stub
    public static <A extends Annotation> A[] getAnnotationsByType(Class<?> self, Class<A> clazz) {
        ArrayList<A> annotations = new ArrayList<A>();
        for (Annotation a : self.getAnnotations()) {
            if (!clazz.isInstance(a)) continue;
            annotations.add(clazz.cast(a));
        }
        return annotations.toArray(new Annotation[0]);
    }

    @Stub
    public static <A extends Annotation> A getDeclaredAnnotation(Class<?> self, Class<A> clazz) {
        for (Annotation a : self.getDeclaredAnnotations()) {
            if (!clazz.isInstance(a)) continue;
            return (A)((Annotation)clazz.cast(a));
        }
        return null;
    }

    @Stub
    public static <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<?> self, Class<A> clazz) {
        ArrayList<A> annotations = new ArrayList<A>();
        for (Annotation a : self.getDeclaredAnnotations()) {
            if (!clazz.isInstance(a)) continue;
            annotations.add(clazz.cast(a));
        }
        return annotations.toArray(new Annotation[0]);
    }
}

