/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.intl.spliterator;

import java.util.Comparator;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_Spliterator;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Consumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_LongConsumer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LongArraySpliterator
implements J_U_Spliterator.OfLong {
    private final long[] array;
    private final int fence;
    private final int characteristics;
    private int index;
    private long estimatedSize;

    public LongArraySpliterator(long[] array, int additionalCharacteristics) {
        this(array, 0, array.length, additionalCharacteristics);
    }

    public LongArraySpliterator(long[] array, int origin, int fence, int additionalCharacteristics) {
        this.array = array;
        this.index = origin;
        this.fence = fence;
        this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        this.estimatedSize = -1L;
    }

    public LongArraySpliterator(long[] array, int origin, int fence, int additionalCharacteristics, long estimatedSize) {
        this.array = array;
        this.index = origin;
        this.fence = fence;
        this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        this.estimatedSize = estimatedSize;
    }

    @Override
    public boolean tryAdvance(final J_U_F_Consumer<? super Long> action) {
        return this.tryAdvance(new J_U_F_LongConsumer.LongConsumerAdapter(){

            @Override
            public void accept(long value) {
                action.accept(value);
            }
        });
    }

    @Override
    public void forEachRemaining(final J_U_F_Consumer<? super Long> action) {
        this.forEachRemaining(new J_U_F_LongConsumer.LongConsumerAdapter(){

            @Override
            public void accept(long value) {
                action.accept(value);
            }
        });
    }

    @Override
    public long estimateSize() {
        if (this.estimatedSize < 0L) {
            this.estimatedSize = this.fence - this.index;
        }
        return this.estimatedSize;
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return (this.characteristics & characteristics) == characteristics;
    }

    @Override
    public Comparator<? super Long> getComparator() {
        return null;
    }

    @Override
    public J_U_Spliterator.OfLong trySplit() {
        int lo = this.index;
        int mid = lo + this.fence >>> 1;
        if (lo >= mid) {
            return null;
        }
        if (this.estimatedSize == -1L) {
            this.index = mid;
            return new LongArraySpliterator(this.array, lo, this.index, this.characteristics);
        }
        long prefixEstimatedSize = this.estimatedSize >>> 1;
        this.estimatedSize -= prefixEstimatedSize;
        this.index = mid;
        return new LongArraySpliterator(this.array, lo, this.index, this.characteristics, prefixEstimatedSize);
    }

    @Override
    public boolean tryAdvance(J_U_F_LongConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index >= 0 && this.index < this.fence) {
            action.accept(this.array[this.index++]);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(J_U_F_LongConsumer action) {
        int i;
        if (action == null) {
            throw new NullPointerException();
        }
        long[] a = this.array;
        int hi = this.fence;
        if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
            do {
                action.accept(a[i]);
            } while (++i < hi);
        }
    }
}

