/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.intl.spliterator;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import xyz.wagyourtail.jvmdg.j8.intl.spliterator.ArraySpliterator;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_Iterator;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_Spliterator;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Consumer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IteratorSpliterator<T>
implements J_U_Spliterator<T> {
    static final int BATCH_UNIT = 1024;
    static final int MAX_BATCH = 0x2000000;
    private final Collection<? extends T> collection;
    private final int characteristics;
    private Iterator<? extends T> it;
    private long est;
    private int batch;

    public IteratorSpliterator(Collection<? extends T> collection, int characteristics) {
        this.collection = collection;
        this.it = null;
        this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
    }

    public IteratorSpliterator(Iterator<? extends T> it, long size, int characteristics) {
        this.collection = null;
        this.it = it;
        this.est = size;
        this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
    }

    public IteratorSpliterator(Iterator<? extends T> it, int characteristics) {
        this.collection = null;
        this.it = it;
        this.est = Long.MAX_VALUE;
        this.characteristics = characteristics & 0xFFFFBFBF;
    }

    @Override
    public boolean tryAdvance(J_U_F_Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.it == null) {
            this.it = this.collection.iterator();
            this.est = this.collection.size();
        }
        if (this.it.hasNext()) {
            action.accept(this.it.next());
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(J_U_F_Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        Iterator<Object> i = this.it;
        if (i == null) {
            i = this.it = this.collection.iterator();
            this.est = this.collection.size();
        }
        J_U_Iterator.forEachRemaining(i, action);
    }

    @Override
    public J_U_Spliterator<T> trySplit() {
        long s;
        Iterator<Object> i = this.it;
        if (i == null) {
            i = this.it = this.collection.iterator();
            s = this.est = (long)this.collection.size();
        } else {
            s = this.est;
        }
        if (s > 1L && this.it.hasNext()) {
            int n = this.batch + 1024;
            if ((long)n > s) {
                n = (int)s;
            }
            if (n > 0x2000000) {
                n = 0x2000000;
            }
            Object[] a = new Object[n];
            int j = 0;
            do {
                a[j] = this.it.next();
            } while (++j < n && this.it.hasNext());
            this.batch = j;
            if (this.est != Long.MAX_VALUE) {
                this.est -= (long)j;
                return new ArraySpliterator<Object>(a, 0, j, this.characteristics);
            }
            return new ArraySpliterator<Object>(a, 0, j, this.characteristics, 0x3FFFFFFFFFFFFFFFL);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        if (this.it == null) {
            this.it = this.collection.iterator();
            this.est = this.collection.size();
        }
        return this.est;
    }

    @Override
    public long getExactSizeIfKnown() {
        if ((this.characteristics & 0x40) == 0) {
            return -1L;
        }
        return this.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return (this.characteristics & characteristics) == characteristics;
    }

    @Override
    public Comparator<? super T> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }
}

