/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.intl.spliterator;

import java.util.Comparator;
import xyz.wagyourtail.jvmdg.j8.intl.spliterator.DoubleArraySpliterator;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_PrimitiveIterator;
import xyz.wagyourtail.jvmdg.j8.stub.J_U_Spliterator;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_Consumer;
import xyz.wagyourtail.jvmdg.j8.stub.function.J_U_F_DoubleConsumer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DoubleIteratorSpliterator
implements J_U_Spliterator.OfDouble {
    static final int BATCH_UNIT = 1024;
    static final int MAX_BATCH = 0x2000000;
    private final int characteristics;
    private final J_U_PrimitiveIterator.OfDouble it;
    private long est;
    private int batch;

    public DoubleIteratorSpliterator(J_U_PrimitiveIterator.OfDouble it, long size, int characteristics) {
        this.it = it;
        this.est = size;
        this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
    }

    public DoubleIteratorSpliterator(J_U_PrimitiveIterator.OfDouble it, int characteristics) {
        this.it = it;
        this.est = Long.MAX_VALUE;
        this.characteristics = characteristics & 0xFFFFBFBF;
    }

    @Override
    public boolean tryAdvance(J_U_F_DoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.it.hasNext()) {
            action.accept(this.it.nextDouble());
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(final J_U_F_Consumer<? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        this.it.forEachRemaining(new J_U_F_DoubleConsumer.DoubleConsumerAdapter(){

            @Override
            public void accept(double value) {
                action.accept(value);
            }
        });
    }

    @Override
    public void forEachRemaining(J_U_F_DoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        this.it.forEachRemaining(action);
    }

    @Override
    public boolean tryAdvance(J_U_F_Consumer<? super Double> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.it.hasNext()) {
            action.accept((Double)this.it.nextDouble());
            return true;
        }
        return false;
    }

    @Override
    public J_U_Spliterator.OfDouble trySplit() {
        long s = this.est;
        if (s > 1L && this.it.hasNext()) {
            int n = this.batch + 1024;
            if ((long)n > s) {
                n = (int)s;
            }
            if (n > 0x2000000) {
                n = 0x2000000;
            }
            double[] a = new double[n];
            int j = 0;
            do {
                a[j] = this.it.nextDouble();
            } while (++j < n && this.it.hasNext());
            this.batch = j;
            if ((double)this.est != Double.MAX_VALUE) {
                this.est -= (long)j;
                return new DoubleArraySpliterator(a, 0, j, this.characteristics);
            }
            return new DoubleArraySpliterator(a, 0, j, this.characteristics, 0x3FFFFFFFFFFFFFFFL);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public long getExactSizeIfKnown() {
        if ((this.characteristics & 0x40) == 0) {
            return -1L;
        }
        return this.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return (this.characteristics & characteristics) == characteristics;
    }

    @Override
    public Comparator<? super Double> getComparator() {
        if (this.hasCharacteristics(4)) {
            return null;
        }
        throw new IllegalStateException();
    }
}

