/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.intl.collections;

import java.util.Collections;
import java.util.Queue;
import xyz.wagyourtail.jvmdg.j8.intl.collections.BackingCollection;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CheckedQueue<E>
extends BackingCollection<E>
implements Queue<E> {
    private final Queue<E> backing;
    private final Class<E> type;

    public CheckedQueue(Queue<E> backing, Class<E> type) {
        super(Collections.checkedCollection(backing, type));
        this.backing = backing;
        this.type = type;
    }

    E typeCheck(Object o) {
        if (o != null && !this.type.isInstance(o)) {
            throw new ClassCastException(this.badElementMsg(o));
        }
        return (E)o;
    }

    private String badElementMsg(Object o) {
        return "Attempt to insert " + o.getClass() + " element into collection with element type " + this.type;
    }

    @Override
    public boolean offer(E e) {
        return this.backing.offer(this.typeCheck(e));
    }

    @Override
    public E remove() {
        return this.backing.remove();
    }

    @Override
    public E poll() {
        return this.backing.poll();
    }

    @Override
    public E element() {
        return this.backing.element();
    }

    @Override
    public E peek() {
        return this.backing.peek();
    }
}

