/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j8.intl.collections;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedMap;
import xyz.wagyourtail.jvmdg.j8.intl.collections.BackingMap;
import xyz.wagyourtail.jvmdg.j8.intl.collections.CheckedNavigableSet;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CheckedNavigableMap<K, V>
extends BackingMap<K, V>
implements NavigableMap<K, V> {
    private final NavigableMap<K, V> backing;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public CheckedNavigableMap(Map<K, V> backing, Class<K> keyType, Class<V> valueType) {
        super(Collections.checkedMap(backing, keyType, valueType));
        this.backing = (NavigableMap)backing;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    private void typeCheck(Object key, Object value) {
        if (key != null && !this.keyType.isInstance(key)) {
            throw new ClassCastException(this.badKeyMsg(key));
        }
        if (value != null && !this.valueType.isInstance(value)) {
            throw new ClassCastException(this.badValueMsg(value));
        }
    }

    private String badKeyMsg(Object key) {
        return "Attempt to insert " + key.getClass() + " key into map with key type " + this.keyType;
    }

    private String badValueMsg(Object value) {
        return "Attempt to insert " + value.getClass() + " value into map with value type " + this.valueType;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        Map.Entry<K, V> lower = this.backing.lowerEntry(key);
        return null != lower ? new CheckedEntry<K, V, V>(lower, this.valueType) : null;
    }

    @Override
    public K lowerKey(K key) {
        return this.backing.lowerKey(key);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        Map.Entry<K, V> floor = this.backing.floorEntry(key);
        return null != floor ? new CheckedEntry<K, V, V>(floor, this.valueType) : null;
    }

    @Override
    public K floorKey(K key) {
        return this.backing.floorKey(key);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        Map.Entry<K, V> ceiling = this.backing.ceilingEntry(key);
        return null != ceiling ? new CheckedEntry<K, V, V>(ceiling, this.valueType) : null;
    }

    @Override
    public K ceilingKey(K key) {
        return this.backing.ceilingKey(key);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        Map.Entry<K, V> higher = this.backing.higherEntry(key);
        return null != higher ? new CheckedEntry<K, V, V>(higher, this.valueType) : null;
    }

    @Override
    public K higherKey(K key) {
        return this.backing.higherKey(key);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Map.Entry<K, V> first = this.backing.firstEntry();
        return null != first ? new CheckedEntry<K, V, V>(first, this.valueType) : null;
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Map.Entry<K, V> last = this.backing.lastEntry();
        return null != last ? new CheckedEntry<K, V, V>(last, this.valueType) : null;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> first = this.backing.pollFirstEntry();
        return null != first ? new CheckedEntry<K, V, V>(first, this.valueType) : null;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> last = this.backing.pollLastEntry();
        return null != last ? new CheckedEntry<K, V, V>(last, this.valueType) : null;
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return new CheckedNavigableMap<K, V>(this.backing.descendingMap(), this.keyType, this.valueType);
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new CheckedNavigableSet<K>(this.backing.navigableKeySet(), this.keyType);
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return new CheckedNavigableSet<K>(this.backing.descendingKeySet(), this.keyType);
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return new CheckedNavigableMap<K, V>(this.backing.subMap(fromKey, fromInclusive, toKey, toInclusive), this.keyType, this.valueType);
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new CheckedNavigableMap<K, V>(this.backing.headMap(toKey, inclusive), this.keyType, this.valueType);
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new CheckedNavigableMap<K, V>(this.backing.tailMap(fromKey, inclusive), this.keyType, this.valueType);
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.backing.comparator();
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return Collections.checkedSortedMap(this.backing.subMap(fromKey, toKey), this.keyType, this.valueType);
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return Collections.checkedSortedMap(this.backing.headMap(toKey), this.keyType, this.valueType);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return Collections.checkedSortedMap(this.backing.tailMap(fromKey), this.keyType, this.valueType);
    }

    @Override
    public K firstKey() {
        return this.backing.firstKey();
    }

    @Override
    public K lastKey() {
        return this.backing.lastKey();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CheckedEntry<K, V, T>
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> e;
        private final Class<T> valueType;

        CheckedEntry(Map.Entry<K, V> e, Class<T> valueType) {
            this.e = Objects.requireNonNull(e);
            this.valueType = Objects.requireNonNull(valueType);
        }

        @Override
        public K getKey() {
            return this.e.getKey();
        }

        @Override
        public V getValue() {
            return this.e.getValue();
        }

        @Override
        public int hashCode() {
            return this.e.hashCode();
        }

        public String toString() {
            return this.e.toString();
        }

        @Override
        public V setValue(V value) {
            if (value != null && !this.valueType.isInstance(value)) {
                throw new ClassCastException(this.badValueMsg(value));
            }
            return this.e.setValue(value);
        }

        private String badValueMsg(Object value) {
            return "Attempt to insert " + value.getClass() + " value into map with value type " + this.valueType;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.e.equals(new AbstractMap.SimpleImmutableEntry((Map.Entry)o));
        }
    }
}

