/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j25.stub.java_net_http;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpResponse;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_C_Flow;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={BodySubscribers.class, BodySubscribers.1.class, BodyHandlers.class})
public class J_N_H_HttpResponse {
    @Stub
    public static Optional<String> connectionLabel(xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpResponse<?> response) {
        return Optional.empty();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_N_H_HttpResponse.class)
    public static class BodySubscribers {
        @Stub(ref=@Ref(value="java/net/http/HttpResponse$BodySubscribers"))
        public static <T> J_N_H_HttpResponse.BodySubscriber<T> limiting(final J_N_H_HttpResponse.BodySubscriber<T> downstreamSubscriber, final long capacity) {
            Objects.requireNonNull(downstreamSubscriber, "downstreamSubscriber");
            if (capacity < 0L) {
                throw new IllegalArgumentException(BodySubscribers.jvmdowngrader$concat$limiting$1(capacity));
            }
            return new J_N_H_HttpResponse.BodySubscriber<T>(){
                long remainingCapacity;
                J_U_C_Flow.Subscription subscription;
                boolean completed;
                {
                    this.remainingCapacity = capacity;
                }

                @Override
                public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                    Objects.requireNonNull(subscription, "subscription");
                    if (this.completed || this.subscription != null) {
                        subscription.cancel();
                    } else {
                        this.subscription = subscription;
                        downstreamSubscriber.onSubscribe(subscription);
                    }
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    Objects.requireNonNull(item, "item");
                    if (this.subscription == null) {
                        return;
                    }
                    try {
                        long size = item.stream().mapToLong(Buffer::remaining).reduce(0L, Math::addExact);
                        if (size > this.remainingCapacity) {
                            throw new ArithmeticException();
                        }
                        this.remainingCapacity -= size;
                        downstreamSubscriber.onNext(item);
                    }
                    catch (ArithmeticException arithmeticException) {
                        this.completed = true;
                        this.subscription = null;
                        downstreamSubscriber.onError(new IOException(1.jvmdowngrader$concat$onNext$1(capacity)));
                        this.subscription.cancel();
                    }
                }

                @Override
                public void onError(Throwable throwable) {
                    Objects.requireNonNull(throwable, "throwable");
                    if (this.subscription != null) {
                        this.subscription = null;
                        this.completed = true;
                        downstreamSubscriber.onError(throwable);
                    }
                }

                @Override
                public void onComplete() {
                    if (this.subscription != null) {
                        this.subscription = null;
                        this.completed = true;
                        downstreamSubscriber.onComplete();
                    }
                }

                @Override
                public CompletionStage<T> getBody() {
                    return downstreamSubscriber.getBody();
                }

                private static /* synthetic */ String jvmdowngrader$concat$onNext$1(long l) {
                    return "body exceeded capacity: " + l;
                }
            };
        }

        private static /* synthetic */ String jvmdowngrader$concat$limiting$1(long l) {
            return "capacity must not be negative: " + l;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_N_H_HttpResponse.class)
    public static class BodyHandlers {
        @Stub(ref=@Ref(value="java/net/http/HttpResponse$BodyHandlers"))
        public static <T> J_N_H_HttpResponse.BodyHandler<T> limiting(J_N_H_HttpResponse.BodyHandler<T> downstreamHandler, long capacity) {
            Objects.requireNonNull(downstreamHandler, "downstreamHandler");
            if (capacity < 0L) {
                throw new IllegalArgumentException(BodyHandlers.jvmdowngrader$concat$limiting$1(capacity));
            }
            return info -> {
                J_N_H_HttpResponse.BodySubscriber downstreamSubscriber = downstreamHandler.apply(info);
                return BodySubscribers.limiting(downstreamSubscriber, capacity);
            };
        }

        private static /* synthetic */ String jvmdowngrader$concat$limiting$1(long l) {
            return "capacity must not be negative: " + l;
        }
    }
}

