/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j21.stub.java_base;

import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j21.impl.FakeVirtualThread;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={VirtualThreadBuilder.class, PlatformClassBuilder.class, BuilderImpl.class, Builder.class, Builder.OfVirtual.class, Builder.OfPlatform.class})
public class J_L_Thread {
    @Stub(ref=@Ref(value="java/lang/Thread"))
    public static Builder.OfPlatform ofPlatform() {
        return new PlatformClassBuilder();
    }

    @Stub(ref=@Ref(value="java/lang/Thread"))
    public static Builder.OfVirtual ofVirtual() {
        return new VirtualThreadBuilder();
    }

    @Stub(ref=@Ref(value="java/lang/Thread"))
    public static Thread startVirtualThread(Runnable runnable) {
        return new FakeVirtualThread(runnable, new Thread().getName(), true);
    }

    @Stub
    public static boolean isVirtual(Thread self) {
        return self instanceof FakeVirtualThread;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_L_Thread.class)
    private static class PlatformClassBuilder
    extends BuilderImpl<PlatformClassBuilder>
    implements Builder.OfPlatform {
        boolean daemon = false;
        ThreadGroup group;
        int priority = 0;
        long stackSize = 0L;

        PlatformClassBuilder() {
        }

        PlatformClassBuilder(PlatformClassBuilder other) {
            super(other);
            this.daemon = other.daemon;
            this.group = other.group;
            this.priority = other.priority;
            this.stackSize = other.stackSize;
        }

        @Override
        public Thread start(Runnable target) {
            Thread thread = this.unstarted(target);
            thread.start();
            return thread;
        }

        @Override
        public Thread unstarted(Runnable task) {
            String string = this.name == null ? new Thread().getName() : (String)this.name.get();
            xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Thread.preInit(this.inheritInheritableThreadLocals);
            Thread thread = new Thread(this.group, task, string, this.stackSize);
            xyz.wagyourtail.jvmdg.j9.stub.java_base.J_L_Thread.postInit();
            Thread thread2 = thread;
            thread2.setDaemon(this.daemon);
            if (this.priority != 0) {
                thread2.setPriority(this.priority);
            }
            thread2.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            return thread2;
        }

        @Override
        PlatformClassBuilder copy() {
            return new PlatformClassBuilder(this);
        }

        @Override
        public Builder.OfPlatform daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        @Override
        public Builder.OfPlatform group(ThreadGroup group) {
            this.group = group;
            return this;
        }

        @Override
        public Builder.OfPlatform priority(int priority) {
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException(PlatformClassBuilder.jvmdowngrader$concat$priority$1(priority));
            }
            this.priority = priority;
            return this;
        }

        @Override
        public Builder.OfPlatform stackSize(long stackSize) {
            if (stackSize < 0L) {
                throw new IllegalArgumentException(PlatformClassBuilder.jvmdowngrader$concat$stackSize$1(stackSize));
            }
            this.stackSize = stackSize;
            return this;
        }

        private static /* synthetic */ String jvmdowngrader$concat$priority$1(int n) {
            return "Priority out of range: " + n;
        }

        private static /* synthetic */ String jvmdowngrader$concat$stackSize$1(long l) {
            return "Non-positive stack size: " + l;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_L_Thread.class)
    private static class VirtualThreadBuilder
    extends BuilderImpl<VirtualThreadBuilder>
    implements Builder.OfVirtual {
        VirtualThreadBuilder() {
        }

        VirtualThreadBuilder(VirtualThreadBuilder other) {
            super(other);
        }

        @Override
        public Thread start(Runnable target) {
            Thread thread = this.unstarted(target);
            thread.start();
            return thread;
        }

        @Override
        public Thread unstarted(Runnable task) {
            FakeVirtualThread thread = new FakeVirtualThread(task, this.name == null ? new Thread().getName() : (String)this.name.get(), this.inheritInheritableThreadLocals);
            thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            return thread;
        }

        @Override
        VirtualThreadBuilder copy() {
            return new VirtualThreadBuilder(this);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_L_Thread.class)
    private static abstract class BuilderImpl<T extends BuilderImpl<T>>
    implements Builder {
        boolean inheritInheritableThreadLocals = true;
        Supplier<String> name;
        long count = 0L;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        BuilderImpl() {
        }

        BuilderImpl(T other) {
            this.inheritInheritableThreadLocals = ((BuilderImpl)other).inheritInheritableThreadLocals;
            this.name = ((BuilderImpl)other).name;
            this.count = ((BuilderImpl)other).count;
            this.uncaughtExceptionHandler = ((BuilderImpl)other).uncaughtExceptionHandler;
        }

        abstract T copy();

        @Override
        public ThreadFactory factory() {
            T copy = this.copy();
            return arg_0 -> copy.unstarted(arg_0);
        }

        public T inheritInheritableThreadLocals(boolean inherit) {
            this.inheritInheritableThreadLocals = inherit;
            return (T)this;
        }

        public T name(String name) {
            this.name = () -> name;
            return (T)this;
        }

        public T name(String prefix, long start) {
            this.name = () -> BuilderImpl.jvmdowngrader$concat$lambda$name$1$1(prefix, this.count++);
            this.count = start;
            return (T)this;
        }

        public T uncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
            this.uncaughtExceptionHandler = handler;
            return (T)this;
        }

        private static /* synthetic */ String jvmdowngrader$concat$lambda$name$1$1(String string, long l) {
            return string + "-" + l;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/lang/Thread$Builder")
    @NestHost(value=J_L_Thread.class)
    public static interface Builder {
        public ThreadFactory factory();

        public Builder inheritInheritableThreadLocals(boolean var1);

        public Builder name(String var1);

        public Builder name(String var1, long var2);

        public Thread start(Runnable var1);

        public Builder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler var1);

        public Thread unstarted(Runnable var1);

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @Adapter(value="java/lang/Thread$Builder$OfVirtual")
        @NestHost(value=J_L_Thread.class)
        public static interface OfVirtual
        extends Builder {
            @Override
            public OfVirtual inheritInheritableThreadLocals(boolean var1);

            @Override
            public OfVirtual name(String var1);

            @Override
            public OfVirtual name(String var1, long var2);

            @Override
            public OfVirtual uncaughtExceptionHandler(Thread.UncaughtExceptionHandler var1);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @Adapter(value="java/lang/Thread$Builder$OfPlatform")
        @NestHost(value=J_L_Thread.class)
        public static interface OfPlatform
        extends Builder {
            default public OfPlatform daemon() {
                return this.daemon(true);
            }

            public OfPlatform daemon(boolean var1);

            public OfPlatform group(ThreadGroup var1);

            @Override
            public OfPlatform inheritInheritableThreadLocals(boolean var1);

            @Override
            public OfPlatform name(String var1);

            @Override
            public OfPlatform name(String var1, long var2);

            public OfPlatform priority(int var1);

            public OfPlatform stackSize(long var1);

            @Override
            public OfPlatform uncaughtExceptionHandler(Thread.UncaughtExceptionHandler var1);
        }
    }
}

