/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j21.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SequencedSet<E>
implements Set<E> {
    final Map<E, Boolean> map;

    public SequencedSet(Map<E, Boolean> map) {
        this.map = map;
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            if (this.map.put(e, Boolean.TRUE) != null) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.map.keySet().removeAll(c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }
}

