/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j20.stub.java_base;

import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_L_Float {
    @Stub(ref=@Ref(value="java/lang/Float"))
    public static float float16ToFloat(short floatBinary16) {
        int bin16SignBit = 0x8000 & floatBinary16;
        int bin16ExpBits = 0x7C00 & floatBinary16;
        int bin16SignifBits = 0x3FF & floatBinary16;
        int SIGNIF_SHIFT = 13;
        float sign = bin16SignBit != 0 ? -1.0f : 1.0f;
        int bin16Exp = (bin16ExpBits >> 10) - 15;
        if (bin16Exp == -15) {
            return sign * (5.9604645E-8f * (float)bin16SignifBits);
        }
        if (bin16Exp == 16) {
            return bin16SignifBits == 0 ? sign * Float.POSITIVE_INFINITY : Float.intBitsToFloat(bin16SignBit << 16 | 0x7F800000 | bin16SignifBits << 13);
        }
        int floatExpBits = bin16Exp + 127 << 23;
        return Float.intBitsToFloat(bin16SignBit << 16 | floatExpBits | bin16SignifBits << 13);
    }

    @Stub(ref=@Ref(value="java/lang/Float"))
    public static short floatToFloat16(float f) {
        int doppel = Float.floatToRawIntBits(f);
        short sign_bit = (short)((doppel & Integer.MIN_VALUE) >> 16);
        if (Float.isNaN(f)) {
            return (short)(sign_bit | 0x7C00 | (doppel & 0x7FE000) >> 13 | (doppel & 0x1FF0) >> 4 | doppel & 0xF);
        }
        float abs_f = Math.abs(f);
        if (abs_f >= 65520.0f) {
            return (short)(sign_bit | 0x7C00);
        }
        if (abs_f <= 2.9802322E-8f) {
            return sign_bit;
        }
        int exp = Math.getExponent(f);
        assert (-25 <= exp && exp <= 15);
        int expdelta = 0;
        int msb = 0;
        if (exp < -14) {
            expdelta = -14 - exp;
            exp = -15;
            msb = 0x800000;
        }
        int f_signif_bits = doppel & 0x7FFFFF | msb;
        short signif_bits = (short)(f_signif_bits >> 13 + expdelta);
        int lsb = f_signif_bits & 1 << 13 + expdelta;
        int round = f_signif_bits & 1 << 12 + expdelta;
        int sticky = f_signif_bits & (1 << 12 + expdelta) - 1;
        if (round != 0 && (lsb | sticky) != 0) {
            signif_bits = (short)(signif_bits + 1);
        }
        return (short)(sign_bit | (exp + 15 << 10) + signif_bits);
    }
}

