/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j18.stub.java_base;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import xyz.wagyourtail.jvmdg.util.Utils;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class J_I_PrintStream {
    private static final MethodHandles.Lookup IMPL_LOOKUP = Utils.getImplLookup();
    private static final MethodHandle getCharOut;

    @Stub
    public static Charset charset(PrintStream printStream) {
        try {
            OutputStreamWriter writer = getCharOut.invokeExact(printStream);
            String encoding = writer.getEncoding();
            return Charset.forName(encoding);
        }
        catch (Throwable e) {
            Utils.sneakyThrow(e);
            return null;
        }
    }

    static {
        try {
            getCharOut = IMPL_LOOKUP.findGetter(PrintStream.class, "charOut", OutputStreamWriter.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

