/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j17.stub.java_base;

import java.util.Random;
import java.util.SplittableRandom;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.exc.MissingStubError;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j17.impl.random.BasicRandomGeneratorImpl;
import xyz.wagyourtail.jvmdg.j17.impl.random.SplittableRandomGeneratorImpl;
import xyz.wagyourtail.jvmdg.j17.stub.java_base.J_U_Random;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.Coerce;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Adapter(value="java/util/random/RandomGenerator")
@NestMembers(value={ArbitrarilyJumpableGenerator.class, LeapableGenerator.class, JumpableGenerator.class, SplittableGenerator.class, StreamableGenerator.class})
public interface J_U_R_RandomGenerator {
    public static boolean jvmdg$instanceof(Object obj) {
        return obj instanceof J_U_R_RandomGenerator || obj instanceof Random || obj instanceof SplittableRandom;
    }

    public static J_U_R_RandomGenerator jvmdg$checkcast(Object obj) {
        Object object = obj;
        if (object instanceof Random) {
            Random random = (Random)object;
            return new BasicRandomGeneratorImpl(random);
        }
        object = obj;
        if (object instanceof SplittableRandom) {
            SplittableRandom random = (SplittableRandom)object;
            return new SplittableRandomGeneratorImpl(random);
        }
        return (J_U_R_RandomGenerator)obj;
    }

    public static J_U_R_RandomGenerator of(String name) {
        throw MissingStubError.create();
    }

    public static J_U_R_RandomGenerator getDefault() {
        return new BasicRandomGeneratorImpl(new Random());
    }

    @Stub(noSpecial=true)
    public static boolean isDeprecated(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).isDeprecated();
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static DoubleStream doubles(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).doubles();
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static DoubleStream doubles(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, double lower, double upper) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).doubles(lower, upper);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static DoubleStream doubles(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long limit) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).doubles(limit);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static DoubleStream doubles(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long limit, double origin, double bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).doubles(limit, origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static IntStream ints(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).ints();
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static IntStream ints(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, int origin, int bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).ints(origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static IntStream ints(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long limit) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).ints(limit);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static IntStream ints(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long limit, int origin, int bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).ints(limit, origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static LongStream longs(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).longs();
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static LongStream longs(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long origin, long bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).longs(origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static LongStream longs(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long limit) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).longs(limit);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static LongStream longs(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long limit, long origin, long bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).longs(limit, origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static boolean nextBoolean(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextBoolean();
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static void nextBytes(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, byte[] bytes) {
        J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextBytes(bytes);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static float nextFloat(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextFloat();
    }

    @Stub(noSpecial=true)
    public static float nextFloat(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, float bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextFloat(bound);
    }

    @Stub(noSpecial=true)
    public static float nextFloat(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, float origin, float bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextFloat(origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static double nextDouble(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextDouble();
    }

    @Stub(noSpecial=true)
    public static double nextDouble(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, double bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextDouble(bound);
    }

    @Stub(noSpecial=true)
    public static double nextDouble(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, double origin, double bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextDouble(origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static int nextInt(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextInt();
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static int nextInt(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, int bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextInt(bound);
    }

    @Stub(noSpecial=true)
    public static int nextInt(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, int origin, int bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextInt(origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static long nextLong(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextLong();
    }

    @Stub(noSpecial=true)
    public static long nextLong(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextLong(bound);
    }

    @Stub(noSpecial=true)
    public static long nextLong(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, long origin, long bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextLong(origin, bound);
    }

    @Stub(noSpecial=true, excludeChild={"java/util/Random"})
    public static double nextGaussian(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextGaussian();
    }

    @Stub(noSpecial=true)
    public static double nextGaussian(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, double mean, double stdDev) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextGaussian(mean, stdDev);
    }

    @Stub(noSpecial=true)
    public static double nextExponential(@Coerce(value=J_U_R_RandomGenerator.class) Object obj) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextExponential();
    }

    default public boolean isDeprecated() {
        return false;
    }

    default public DoubleStream doubles() {
        return DoubleStream.generate(this::nextDouble).sequential();
    }

    default public DoubleStream doubles(double lower, double upper) {
        if (!(lower < upper) || !(upper - lower < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return DoubleStream.generate(() -> this.nextDouble(lower, upper)).sequential();
    }

    default public DoubleStream doubles(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        return this.doubles().limit(limit).sequential();
    }

    default public DoubleStream doubles(long limit, double origin, double bound) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        if (!(origin < bound) || !(bound - origin < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return DoubleStream.generate(() -> this.nextDouble(origin, bound)).limit(limit).sequential();
    }

    default public IntStream ints() {
        return IntStream.generate(this::nextInt).sequential();
    }

    default public IntStream ints(int origin, int bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return IntStream.generate(() -> this.nextInt(origin, bound)).sequential();
    }

    default public IntStream ints(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        return this.ints().limit(limit).sequential();
    }

    default public IntStream ints(long limit, int origin, int bound) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return this.ints(origin, bound).limit(limit).sequential();
    }

    default public LongStream longs() {
        return LongStream.generate(this::nextLong).sequential();
    }

    default public LongStream longs(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return LongStream.generate(() -> this.nextLong(origin, bound)).sequential();
    }

    default public LongStream longs(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        return this.longs().limit(limit).sequential();
    }

    default public LongStream longs(long limit, long origin, long bound) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return this.longs(origin, bound).limit(limit).sequential();
    }

    default public boolean nextBoolean() {
        return this.nextInt() < 0;
    }

    default public void nextBytes(byte[] bytes) {
        int n;
        long rnd;
        int i = 0;
        int len = bytes.length;
        int words = len >> 3;
        while (words-- > 0) {
            rnd = this.nextLong();
            for (n = 0; n < 8; ++n) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
        if (i < len) {
            rnd = this.nextLong();
            for (n = 0; n < len - i; ++n) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
    }

    default public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    default public float nextFloat(float bound) {
        if (bound <= 0.0f) {
            throw new IllegalArgumentException("bound must be positive");
        }
        float r = this.nextFloat();
        if ((r *= bound) >= bound) {
            r = Math.nextDown(bound);
        }
        return r;
    }

    default public float nextFloat(float origin, float bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        float r = this.nextFloat();
        if ((r = r * (bound - origin) + origin) >= bound) {
            r = Math.nextDown(bound);
        }
        return r;
    }

    default public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    default public double nextDouble(double bound) {
        if (bound <= 0.0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        double r = this.nextDouble();
        if ((r *= bound) >= bound) {
            r = Math.nextDown(bound);
        }
        return r;
    }

    default public double nextDouble(double origin, double bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        double r = this.nextDouble();
        if ((r = r * (bound - origin) + origin) >= bound) {
            r = Math.nextDown(bound);
        }
        return r;
    }

    default public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    default public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        int r = this.nextInt();
        int m = bound - 1;
        if ((bound & m) == 0) {
            r &= m;
        } else {
            int u = r >>> 1;
            while (u + m - (r = u % bound) < 0) {
                u = this.nextInt() >>> 1;
            }
        }
        return r;
    }

    default public int nextInt(int origin, int bound) {
        int r = this.nextInt();
        if (origin < bound) {
            int n = bound - origin;
            int m = n - 1;
            if ((n & m) == 0) {
                r = (r & m) + origin;
            } else if (n > 0) {
                int u = r >>> 1;
                while (u + m - (r = u % n) < 0) {
                    u = this.nextInt() >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = this.nextInt();
                }
            }
        }
        return r;
    }

    public long nextLong();

    default public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long m = bound - 1L;
        long r = this.nextLong();
        if ((bound & m) == 0L) {
            r &= m;
        } else {
            long u = r >>> 1;
            while (u + m - (r = u % bound) < 0L) {
                u = this.nextLong() >>> 1;
            }
        }
        return r;
    }

    default public long nextLong(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        long r = this.nextLong();
        long n = bound - origin;
        long m = n - 1L;
        if ((n & m) == 0L) {
            r = (r & m) + origin;
        } else if (n > 0L) {
            long u = r >>> 1;
            while (u + m - (r = u % n) < 0L) {
                u = this.nextLong() >>> 1;
            }
            r += origin;
        } else {
            while (r < origin || r >= bound) {
                r = this.nextLong();
            }
        }
        return r;
    }

    default public double nextGaussian() {
        throw MissingStubError.create();
    }

    default public double nextGaussian(double mean, double stdDev) {
        throw MissingStubError.create();
    }

    default public double nextExponential() {
        throw MissingStubError.create();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/util/random/RandomGenerator$ArbitrarilyJumpableGenerator")
    @NestHost(value=J_U_R_RandomGenerator.class)
    public static interface ArbitrarilyJumpableGenerator
    extends LeapableGenerator {
        public static ArbitrarilyJumpableGenerator of(String name) {
            throw MissingStubError.create();
        }

        @Override
        public ArbitrarilyJumpableGenerator copy();

        public void jumpPowerOfTwo(int var1);

        public void jump(double var1);

        @Override
        default public void jump() {
            this.jump(this.jumpDistance());
        }

        default public Stream<ArbitrarilyJumpableGenerator> jumps(double distance) {
            return (Stream)Stream.generate(() -> this.copyAndJump(distance)).sequential();
        }

        default public Stream<ArbitrarilyJumpableGenerator> jumps(long limit, double distance) {
            return this.jumps(distance).limit(limit);
        }

        @Override
        default public void leap() {
            this.jump(this.leapDistance());
        }

        default public ArbitrarilyJumpableGenerator copyAndJump(double distance) {
            ArbitrarilyJumpableGenerator copy = this.copy();
            this.jump(distance);
            return copy;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/util/random/RandomGenerator$LeapableGenerator")
    @NestHost(value=J_U_R_RandomGenerator.class)
    public static interface LeapableGenerator
    extends JumpableGenerator {
        public static LeapableGenerator of(String name) {
            throw MissingStubError.create();
        }

        @Override
        public LeapableGenerator copy();

        public void leap();

        public double leapDistance();

        default public Stream<JumpableGenerator> leaps() {
            return (Stream)Stream.generate(this::copyAndLeap).sequential();
        }

        default public Stream<JumpableGenerator> leaps(long limit) {
            return this.leaps().limit(limit);
        }

        default public JumpableGenerator copyAndLeap() {
            LeapableGenerator copy = this.copy();
            this.leap();
            return copy;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/util/random/RandomGenerator$JumpableGenerator")
    @NestHost(value=J_U_R_RandomGenerator.class)
    public static interface JumpableGenerator
    extends StreamableGenerator {
        public static JumpableGenerator of(String name) {
            throw MissingStubError.create();
        }

        public JumpableGenerator copy();

        public void jump();

        public double jumpDistance();

        default public Stream<J_U_R_RandomGenerator> jumps() {
            return (Stream)Stream.generate(this::copyAndJump).sequential();
        }

        default public Stream<J_U_R_RandomGenerator> jumps(long limit) {
            return this.jumps().limit(limit);
        }

        @Override
        default public Stream<J_U_R_RandomGenerator> rngs() {
            return this.jumps();
        }

        @Override
        default public Stream<J_U_R_RandomGenerator> rngs(long limit) {
            return this.jumps(limit);
        }

        default public J_U_R_RandomGenerator copyAndJump() {
            JumpableGenerator copy = this.copy();
            this.jump();
            return copy;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/util/random/RandomGenerator$SplittableGenerator")
    @NestHost(value=J_U_R_RandomGenerator.class)
    public static interface SplittableGenerator
    extends StreamableGenerator {
        public static boolean jvmdg$instanceof(Object obj) {
            return obj instanceof SplittableGenerator || obj instanceof SplittableRandom;
        }

        public static SplittableGenerator jvmdg$checkcast(Object obj) {
            Object object = obj;
            if (object instanceof SplittableRandom) {
                SplittableRandom random = (SplittableRandom)object;
                return new SplittableRandomGeneratorImpl(random);
            }
            return (SplittableGenerator)obj;
        }

        public static SplittableGenerator of(String name) {
            throw MissingStubError.create();
        }

        @Stub(noSpecial=true)
        public static SplittableGenerator split(@Coerce(value=J_U_Random.class) Object obj) {
            return SplittableGenerator.jvmdg$checkcast(obj).split();
        }

        @Stub(noSpecial=true)
        public static SplittableGenerator split(@Coerce(value=J_U_Random.class) Object obj, SplittableGenerator source) {
            return SplittableGenerator.jvmdg$checkcast(obj).split(source);
        }

        @Stub(noSpecial=true)
        public static Stream<SplittableGenerator> splits(@Coerce(value=J_U_Random.class) Object obj) {
            return SplittableGenerator.jvmdg$checkcast(obj).splits();
        }

        @Stub(noSpecial=true)
        public static Stream<SplittableGenerator> splits(@Coerce(value=J_U_Random.class) Object obj, long size) {
            return SplittableGenerator.jvmdg$checkcast(obj).splits(size);
        }

        @Stub(noSpecial=true)
        public static Stream<SplittableGenerator> splits(@Coerce(value=J_U_Random.class) Object obj, SplittableGenerator source) {
            return SplittableGenerator.jvmdg$checkcast(obj).splits(source);
        }

        @Stub(noSpecial=true)
        public static Stream<SplittableGenerator> splits(@Coerce(value=J_U_Random.class) Object obj, long size, SplittableGenerator source) {
            return SplittableGenerator.jvmdg$checkcast(obj).splits(size, source);
        }

        @Stub(noSpecial=true)
        public static Stream<J_U_R_RandomGenerator> rngs(@Coerce(value=J_U_Random.class) Object obj) {
            return SplittableGenerator.jvmdg$checkcast(obj).rngs();
        }

        @Stub(noSpecial=true)
        public static Stream<J_U_R_RandomGenerator> rngs(@Coerce(value=J_U_Random.class) Object obj, long limit) {
            return SplittableGenerator.jvmdg$checkcast(obj).rngs(limit);
        }

        public SplittableGenerator split();

        public SplittableGenerator split(SplittableGenerator var1);

        default public Stream<SplittableGenerator> splits() {
            return this.splits(this);
        }

        public Stream<SplittableGenerator> splits(long var1);

        public Stream<SplittableGenerator> splits(SplittableGenerator var1);

        public Stream<SplittableGenerator> splits(long var1, SplittableGenerator var3);

        @Override
        default public Stream<J_U_R_RandomGenerator> rngs() {
            return this.splits();
        }

        @Override
        default public Stream<J_U_R_RandomGenerator> rngs(long limit) {
            return this.splits(limit);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Adapter(value="java/util/random/RandomGenerator$StreamableGenerator")
    @NestHost(value=J_U_R_RandomGenerator.class)
    public static interface StreamableGenerator
    extends J_U_R_RandomGenerator {
        public static boolean jvmdg$instanceof(Object obj) {
            return obj instanceof StreamableGenerator || obj instanceof SplittableRandom;
        }

        public static StreamableGenerator jvmdg$checkcast(Object obj) {
            Object object = obj;
            if (object instanceof SplittableRandom) {
                SplittableRandom random = (SplittableRandom)object;
                return new SplittableRandomGeneratorImpl(random);
            }
            return (StreamableGenerator)obj;
        }

        public static StreamableGenerator of(String name) {
            throw MissingStubError.create();
        }

        @Stub(noSpecial=true)
        public static Stream<J_U_R_RandomGenerator> rngs(@Coerce(value=J_U_Random.class) Object obj) {
            return StreamableGenerator.jvmdg$checkcast(obj).rngs();
        }

        @Stub(noSpecial=true)
        public static Stream<J_U_R_RandomGenerator> rngs(@Coerce(value=J_U_Random.class) Object obj, long limit) {
            return StreamableGenerator.jvmdg$checkcast(obj).rngs(limit);
        }

        public Stream<J_U_R_RandomGenerator> rngs();

        default public Stream<J_U_R_RandomGenerator> rngs(long limit) {
            if (limit < 0L) {
                throw new IllegalArgumentException("size must be non-negative");
            }
            return this.rngs().limit(limit);
        }
    }
}

