/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j16.stub.java_net_http;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpHeaders;
import xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_C_Flow;
import xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={BodyPublishers.class, BodyPublishers.1.class, BodyPublishers.1.class, BodyPublishers.2.class, BodyPublishers.1.class})
public class J_N_H_HttpRequest {
    @Stub(ref=@Ref(value="Ljava/net/http/HttpRequest;"))
    public static J_N_H_HttpRequest.Builder newBuilder(xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest request, BiPredicate<String, String> filter) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(filter);
        J_N_H_HttpRequest.Builder builder = xyz.wagyourtail.jvmdg.j11.stub.java_net_http.J_N_H_HttpRequest.newBuilder();
        builder.uri(request.uri());
        builder.expectContinue(request.expectContinue());
        J_N_H_HttpHeaders headers = J_N_H_HttpHeaders.of(request.headers().map(), filter);
        for (Map.Entry<String, List<String>> entry : headers.map().entrySet()) {
            for (String value : entry.getValue()) {
                builder.header(entry.getKey(), value);
            }
        }
        request.version().ifPresent(builder::version);
        request.timeout().ifPresent(builder::timeout);
        String method = request.method();
        Optional<J_N_H_HttpRequest.BodyPublisher> publisher = request.bodyPublisher();
        if (publisher.isPresent()) {
            builder.method(method, publisher.get());
        } else {
            switch (method) {
                case "GET": {
                    builder.GET();
                    break;
                }
                case "DELETE": {
                    builder.DELETE();
                    break;
                }
                default: {
                    builder.method(method, J_N_H_HttpRequest.BodyPublishers.noBody());
                }
            }
        }
        return builder;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_N_H_HttpRequest.class)
    public static class BodyPublishers {
        @Stub(ref=@Ref(value="java/net/http/HttpRequest$BodyPublishers"))
        public static J_N_H_HttpRequest.BodyPublisher concat(final J_N_H_HttpRequest.BodyPublisher ... publishers) {
            return new J_N_H_HttpRequest.BodyPublisher(){

                @Override
                public long contentLength() {
                    long sum = 0L;
                    for (J_N_H_HttpRequest.BodyPublisher publisher : publishers) {
                        sum += publisher.contentLength();
                    }
                    return sum;
                }

                @Override
                public void subscribe(final J_U_C_Flow.Subscriber<? super ByteBuffer> subscriber) {
                    subscriber.onSubscribe(new J_U_C_Flow.Subscription(){
                        private final Iterator<J_N_H_HttpRequest.BodyPublisher> iterator;
                        private boolean completed;
                        {
                            this.iterator = J_U_List.of(publishers).iterator();
                        }

                        @Override
                        public void request(long n) {
                            if (n <= 0L) {
                                subscriber.onError(new IllegalArgumentException("n <= 0"));
                                return;
                            }
                            if (this.completed) {
                                return;
                            }
                            try {
                                while (n > 0L) {
                                    if (!this.iterator.hasNext()) {
                                        this.completed = true;
                                        subscriber.onComplete();
                                        return;
                                    }
                                    J_N_H_HttpRequest.BodyPublisher publisher = this.iterator.next();
                                    final long contentLength = publisher.contentLength();
                                    if (contentLength > 0L) {
                                        publisher.subscribe(new J_U_C_Flow.Subscriber<ByteBuffer>(){
                                            private long remaining;
                                            {
                                                this.remaining = contentLength;
                                            }

                                            @Override
                                            public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                                                subscription.request(Long.MAX_VALUE);
                                            }

                                            @Override
                                            public void onNext(ByteBuffer item) {
                                                subscriber.onNext(item);
                                                this.remaining -= (long)item.remaining();
                                                if (this.remaining == 0L) {
                                                    subscriber.onComplete();
                                                }
                                            }

                                            @Override
                                            public void onError(Throwable throwable) {
                                                subscriber.onError(throwable);
                                            }

                                            @Override
                                            public void onComplete() {
                                            }
                                        });
                                    } else {
                                        publisher.subscribe(new J_U_C_Flow.Subscriber<ByteBuffer>(){

                                            @Override
                                            public void onSubscribe(J_U_C_Flow.Subscription subscription) {
                                                subscription.request(Long.MAX_VALUE);
                                            }

                                            @Override
                                            public void onNext(ByteBuffer item) {
                                                subscriber.onNext(item);
                                            }

                                            @Override
                                            public void onError(Throwable throwable) {
                                                subscriber.onError(throwable);
                                            }

                                            @Override
                                            public void onComplete() {
                                                subscriber.onComplete();
                                            }
                                        });
                                    }
                                    --n;
                                }
                            }
                            catch (Throwable t) {
                                subscriber.onError(t);
                            }
                        }

                        @Override
                        public void cancel() {
                            this.completed = true;
                        }
                    });
                }
            };
        }
    }
}

