/*
 * Decompiled with CFR 0.152.
 */
package xyz.wagyourtail.jvmdg.j16.stub.java_base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@NestMembers(value={MapMultiDoubleConsumer.class, MapMultiLongConsumer.class, MapMultiIntConsumer.class, MapMultiConsumer.class})
public class J_U_S_Stream {
    private static final Class<?> REF_PIPELINE;

    @Stub
    public static <T, R> Stream<R> mapMulti(Stream<T> stream, BiConsumer<? super T, ? super Consumer<R>> mapper) {
        return stream.flatMap(new MapMultiConsumer(mapper));
    }

    @Stub
    public static <T> IntStream mapMultiToInt(Stream<T> stream, BiConsumer<? super T, ? super IntConsumer> mapper) {
        return stream.flatMapToInt(new MapMultiIntConsumer<T>(mapper));
    }

    @Stub
    public static <T> LongStream mapMultiToLong(Stream<T> stream, BiConsumer<? super T, ? super LongConsumer> mapper) {
        return stream.flatMapToLong(new MapMultiLongConsumer<T>(mapper));
    }

    @Stub
    public static <T> DoubleStream mapMultiToDouble(Stream<T> stream, BiConsumer<? super T, ? super DoubleConsumer> mapper) {
        return stream.flatMapToDouble(new MapMultiDoubleConsumer<T>(mapper));
    }

    @Stub
    public static <T> List<T> toList(Stream<T> stream) {
        List<Object> unsafeList = Arrays.asList(stream.toArray());
        if (REF_PIPELINE.isAssignableFrom(stream.getClass())) {
            return Collections.unmodifiableList(unsafeList);
        }
        return Collections.unmodifiableList(new ArrayList<Object>(unsafeList));
    }

    static {
        try {
            REF_PIPELINE = Class.forName("java.util.stream.ReferencePipeline");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_U_S_Stream.class)
    public static class MapMultiConsumer<T, R>
    implements Function<T, Stream<R>> {
        private final BiConsumer<? super T, ? super Consumer<R>> mapper;

        public MapMultiConsumer(BiConsumer<? super T, ? super Consumer<R>> mapper) {
            this.mapper = mapper;
        }

        @Override
        public Stream<R> apply(T t) {
            Stream.Builder builder = Stream.builder();
            this.mapper.accept(t, builder);
            return builder.build();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_U_S_Stream.class)
    public static class MapMultiIntConsumer<T>
    implements Function<T, IntStream> {
        private final BiConsumer<? super T, ? super IntConsumer> mapper;

        public MapMultiIntConsumer(BiConsumer<? super T, ? super IntConsumer> mapper) {
            this.mapper = mapper;
        }

        @Override
        public IntStream apply(T t) {
            IntStream.Builder builder = IntStream.builder();
            this.mapper.accept(t, builder);
            return builder.build();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_U_S_Stream.class)
    public static class MapMultiLongConsumer<T>
    implements Function<T, LongStream> {
        private final BiConsumer<? super T, ? super LongConsumer> mapper;

        public MapMultiLongConsumer(BiConsumer<? super T, ? super LongConsumer> mapper) {
            this.mapper = mapper;
        }

        @Override
        public LongStream apply(T t) {
            LongStream.Builder builder = LongStream.builder();
            this.mapper.accept(t, builder);
            return builder.build();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @NestHost(value=J_U_S_Stream.class)
    public static class MapMultiDoubleConsumer<T>
    implements Function<T, DoubleStream> {
        private final BiConsumer<? super T, ? super DoubleConsumer> mapper;

        public MapMultiDoubleConsumer(BiConsumer<? super T, ? super DoubleConsumer> mapper) {
            this.mapper = mapper;
        }

        @Override
        public DoubleStream apply(T t) {
            DoubleStream.Builder builder = DoubleStream.builder();
            this.mapper.accept(t, builder);
            return builder.build();
        }
    }
}

